/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.console.filter.AbstractQueryFilter;

public class AmqMessagesQueryFilter
extends AbstractQueryFilter {
    private URI brokerUrl;
    private Destination destination;

    public AmqMessagesQueryFilter(URI brokerUrl, Destination destination) {
        super(null);
        this.brokerUrl = brokerUrl;
        this.destination = destination;
    }

    public List query(List queries) throws Exception {
        String selector = "";
        Iterator i = queries.iterator();
        while (i.hasNext()) {
            selector = selector + "(" + i.next().toString() + ") AND ";
        }
        if (!selector.equals("")) {
            selector = selector.substring(0, selector.length() - 5);
        }
        if (this.destination instanceof ActiveMQQueue) {
            return this.queryMessages((ActiveMQQueue)this.destination, selector);
        }
        return this.queryMessages((ActiveMQTopic)this.destination, selector);
    }

    protected List queryMessages(ActiveMQQueue queue, String selector) throws Exception {
        Connection conn = this.createConnection(this.getBrokerUrl());
        Session sess = conn.createSession(false, 1);
        QueueBrowser browser = sess.createBrowser((Queue)queue, selector);
        ArrayList messages = Collections.list(browser.getEnumeration());
        conn.close();
        return messages;
    }

    protected List queryMessages(ActiveMQTopic topic, String selector) throws Exception {
        return null;
    }

    protected Connection createConnection(URI brokerUrl) throws JMSException {
        Connection conn = new ActiveMQConnectionFactory(brokerUrl).createConnection();
        conn.start();
        return conn;
    }

    public URI getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(URI brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }
}

