/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.metrics.Metrics2ReplicationMetrics;
import org.apache.accumulo.master.metrics.ReplicationMetrics;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.hadoop.metrics2.MetricsSystem;

public class MasterMetricsFactory {
    private final boolean useOldMetrics;
    private final MetricsSystem metricsSystem;
    private final Master master;

    public MasterMetricsFactory(AccumuloConfiguration conf, Master master) {
        Objects.requireNonNull(conf);
        this.useOldMetrics = conf.getBoolean(Property.GENERAL_LEGACY_METRICS);
        this.master = master;
        this.metricsSystem = this.useOldMetrics ? null : MetricsSystemHelper.getInstance();
    }

    public Metrics createReplicationMetrics() {
        if (this.useOldMetrics) {
            return new ReplicationMetrics(this.master);
        }
        return new Metrics2ReplicationMetrics(this.master, this.metricsSystem);
    }
}

