/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.DelegationTokenConfigSerializer;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletSplit;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.security.thrift.TDelegationToken;
import org.apache.accumulo.core.security.thrift.TDelegationTokenConfig;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.FateServiceHandler;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.TraceRepo;
import org.apache.accumulo.master.tserverOps.ShutdownTServer;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.util.NamespacePropUtil;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.util.TabletIterator;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterClientServiceHandler
extends FateServiceHandler
implements MasterClientService.Iface {
    private static final Logger log = Master.log;
    private static final Logger drainLog = LoggerFactory.getLogger((String)"org.apache.accumulo.master.MasterDrainImpl");
    private Instance instance;

    protected MasterClientServiceHandler(Master master) {
        super(master);
        this.instance = master.getInstance();
    }

    public long initiateFlush(TInfo tinfo, TCredentials c, String tableId) throws ThriftSecurityException, ThriftTableOperationException {
        byte[] fid;
        String namespaceId = this.getNamespaceIdFromTableId(TableOperation.FLUSH, tableId);
        this.master.security.canFlush(c, tableId, namespaceId);
        String zTablePath = "/accumulo/" + this.master.getInstance().getInstanceID() + "/tables" + "/" + tableId + "/flush-id";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            fid = zoo.mutate(zTablePath, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] currentValue) throws Exception {
                    long flushID = Long.parseLong(new String(currentValue));
                    return ("" + ++flushID).getBytes();
                }
            });
        }
        catch (KeeperException.NoNodeException nne) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
        }
        catch (Exception e) {
            Master.log.warn("{}", (Object)e.getMessage(), (Object)e);
            throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.OTHER, null);
        }
        return Long.parseLong(new String(fid));
    }

    public void waitForFlush(TInfo tinfo, TCredentials c, String tableId, ByteBuffer startRow, ByteBuffer endRow, long flushID, long maxLoops) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = this.getNamespaceIdFromTableId(TableOperation.FLUSH, tableId);
        this.master.security.canFlush(c, tableId, namespaceId);
        if (endRow != null && startRow != null && ByteBufferUtil.toText((ByteBuffer)startRow).compareTo((BinaryComparable)ByteBufferUtil.toText((ByteBuffer)endRow)) >= 0) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        HashSet<TServerInstance> serversToFlush = new HashSet<TServerInstance>(this.master.tserverSet.getCurrentServers());
        for (long l = 0L; l < maxLoops; ++l) {
            for (TServerInstance instance : serversToFlush) {
                try {
                    LiveTServerSet.TServerConnection server = this.master.tserverSet.getConnection(instance);
                    if (server == null) continue;
                    server.flush(this.master.masterLock, tableId, ByteBufferUtil.toBytes((ByteBuffer)startRow), ByteBufferUtil.toBytes((ByteBuffer)endRow));
                }
                catch (TException ex) {
                    Master.log.error(ex.toString());
                }
            }
            if (l == maxLoops - 1L) break;
            UtilWaitThread.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            serversToFlush.clear();
            try {
                IsolatedScanner scanner;
                Connector conn = this.master.getConnector();
                if (tableId.equals("!0")) {
                    scanner = new IsolatedScanner(conn.createScanner("accumulo.root", Authorizations.EMPTY));
                    scanner.setRange(MetadataSchema.TabletsSection.getRange());
                } else {
                    scanner = new IsolatedScanner(conn.createScanner("accumulo.metadata", Authorizations.EMPTY));
                    Range range = new KeyExtent(tableId, null, ByteBufferUtil.toText((ByteBuffer)startRow)).toMetadataRange();
                    scanner.setRange(range.clip(MetadataSchema.TabletsSection.getRange()));
                }
                MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.fetch((ScannerBase)scanner);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
                RowIterator ri = new RowIterator((Iterable)scanner);
                int tabletsToWaitFor = 0;
                int tabletCount = 0;
                Text ert = ByteBufferUtil.toText((ByteBuffer)endRow);
                while (ri.hasNext()) {
                    Iterator row = ri.next();
                    long tabletFlushID = -1L;
                    int logs = 0;
                    boolean online = false;
                    TServerInstance server = null;
                    Map.Entry entry = null;
                    while (row.hasNext()) {
                        entry = (Map.Entry)row.next();
                        Key key = (Key)entry.getKey();
                        if (MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.equals(key.getColumnFamily(), key.getColumnQualifier())) {
                            tabletFlushID = Long.parseLong(((Value)entry.getValue()).toString());
                        }
                        if (MetadataSchema.TabletsSection.LogColumnFamily.NAME.equals((Object)key.getColumnFamily())) {
                            ++logs;
                        }
                        if (!MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME.equals((Object)key.getColumnFamily())) continue;
                        online = true;
                        server = new TServerInstance((Value)entry.getValue(), key.getColumnQualifier());
                    }
                    if ((online || logs > 0) && tabletFlushID < flushID) {
                        ++tabletsToWaitFor;
                        if (server != null) {
                            serversToFlush.add(server);
                        }
                    }
                    ++tabletCount;
                    Text tabletEndRow = new KeyExtent(((Key)entry.getKey()).getRow(), (Text)null).getEndRow();
                    if (tabletEndRow != null && (ert == null || tabletEndRow.compareTo((BinaryComparable)ert) < 0)) continue;
                    break;
                }
                if (tabletsToWaitFor == 0) break;
                if (tabletCount != 0 || Tables.exists((Instance)this.master.getInstance(), (String)tableId)) continue;
                throw new ThriftTableOperationException(tableId, null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
            }
            catch (AccumuloException e) {
                Master.log.debug("Failed to scan accumulo.metadata table to wait for flush " + tableId, (Throwable)e);
                continue;
            }
            catch (TabletIterator.TabletDeletedException tde) {
                Master.log.debug("Failed to scan accumulo.metadata table to wait for flush " + tableId, (Throwable)tde);
                continue;
            }
            catch (AccumuloSecurityException e) {
                Master.log.warn("{}", (Object)e.getMessage(), (Object)e);
                throw new ThriftSecurityException();
            }
            catch (TableNotFoundException e) {
                Master.log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new ThriftTableOperationException();
            }
        }
    }

    private String getNamespaceIdFromTableId(TableOperation tableOp, String tableId) throws ThriftTableOperationException {
        String namespaceId;
        try {
            namespaceId = Tables.getNamespaceId((Instance)this.instance, (String)tableId);
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId, null, tableOp, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        return namespaceId;
    }

    public MasterMonitorInfo getMasterStats(TInfo info, TCredentials credentials) throws ThriftSecurityException {
        return this.master.getMasterMonitorInfo();
    }

    public void removeTableProperty(TInfo info, TCredentials credentials, String tableName, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, null, TableOperation.REMOVE_PROPERTY);
    }

    public void setTableProperty(TInfo info, TCredentials credentials, String tableName, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, value, TableOperation.SET_PROPERTY);
    }

    public void shutdown(TInfo info, TCredentials c, boolean stopTabletServers) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        if (stopTabletServers) {
            this.master.setMasterGoalState(MasterGoalState.CLEAN_STOP);
            EventCoordinator.Listener eventListener = this.master.nextEvent.getListener();
            do {
                eventListener.waitForEvents(1000L);
            } while (this.master.tserverSet.size() > 0);
        }
        this.master.setMasterState(MasterState.STOP);
    }

    public void shutdownTabletServer(TInfo info, TCredentials c, String tabletServer, boolean force) throws ThriftSecurityException {
        LiveTServerSet.TServerConnection server;
        this.master.security.canPerformSystemActions(c);
        TServerInstance doomed = this.master.tserverSet.find(tabletServer);
        if (!force && (server = this.master.tserverSet.getConnection(doomed)) == null) {
            Master.log.warn("No server found for name " + tabletServer);
            return;
        }
        long tid = this.master.fate.startTransaction();
        log.debug("Seeding FATE op to shutdown " + tabletServer + " with tid " + tid);
        this.master.fate.seedTransaction(tid, new TraceRepo<Master>(new ShutdownTServer(doomed, force)), false);
        this.master.fate.waitForCompletion(tid);
        this.master.fate.delete(tid);
        log.debug("FATE op shutting down " + tabletServer + " finished");
    }

    public void reportSplitExtent(TInfo info, TCredentials credentials, String serverName, TabletSplit split) {
        KeyExtent oldTablet = new KeyExtent(split.oldTablet);
        if (this.master.migrations.remove(oldTablet) != null) {
            Master.log.info("Canceled migration of " + split.oldTablet);
        }
        for (TServerInstance instance : this.master.tserverSet.getCurrentServers()) {
            if (!serverName.equals(instance.hostPort())) continue;
            this.master.nextEvent.event("%s reported split %s, %s", serverName, new KeyExtent((TKeyExtent)split.newTablets.get(0)), new KeyExtent((TKeyExtent)split.newTablets.get(1)));
            return;
        }
        Master.log.warn("Got a split from a server we don't recognize: " + serverName);
    }

    public void reportTabletStatus(TInfo info, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent ttablet) {
        KeyExtent tablet = new KeyExtent(ttablet);
        switch (status) {
            case LOAD_FAILURE: {
                Master.log.error(serverName + " reports assignment failed for tablet " + tablet);
                break;
            }
            case LOADED: {
                this.master.nextEvent.event("tablet %s was loaded on %s", tablet, serverName);
                break;
            }
            case UNLOADED: {
                this.master.nextEvent.event("tablet %s was unloaded from %s", tablet, serverName);
                break;
            }
            case UNLOAD_ERROR: {
                Master.log.error(serverName + " reports unload failed for tablet " + tablet);
                break;
            }
            case UNLOAD_FAILURE_NOT_SERVING: {
                if (!Master.log.isTraceEnabled()) break;
                Master.log.trace(serverName + " reports unload failed: not serving tablet, could be a split: " + tablet);
                break;
            }
            case CHOPPED: {
                this.master.nextEvent.event("tablet %s chopped", tablet);
            }
        }
    }

    public void setMasterGoalState(TInfo info, TCredentials c, MasterGoalState state) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        this.master.setMasterGoalState(state);
    }

    public void removeSystemProperty(TInfo info, TCredentials c, String property) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        try {
            SystemPropUtil.removeSystemProperty((String)property);
            this.updatePlugins(property);
        }
        catch (Exception e) {
            Master.log.error("Problem removing config property in zookeeper", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSystemProperty(TInfo info, TCredentials c, String property, String value) throws ThriftSecurityException, TException {
        this.master.security.canPerformSystemActions(c);
        try {
            SystemPropUtil.setSystemProperty((String)property, (String)value);
            this.updatePlugins(property);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Master.log.error("Problem setting config property in zookeeper", (Throwable)e);
            throw new TException(e.getMessage());
        }
    }

    public void setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, value, TableOperation.SET_PROPERTY);
    }

    public void removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, null, TableOperation.REMOVE_PROPERTY);
    }

    private void alterNamespaceProperty(TCredentials c, String namespace, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = null;
        namespaceId = ClientServiceHandler.checkNamespaceId((Instance)this.master.getInstance(), (String)namespace, (TableOperation)op);
        if (!this.master.security.canAlterNamespace(c, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null) {
                NamespacePropUtil.removeNamespaceProperty((String)namespaceId, (String)property);
            } else {
                NamespacePropUtil.setNamespaceProperty((String)namespaceId, (String)property, (String)value);
            }
        }
        catch (KeeperException.NoNodeException e) {
            ClientServiceHandler.checkNamespaceId((Instance)this.master.getInstance(), (String)namespaceId, (TableOperation)op);
            log.info("Error altering namespace property", (Throwable)e);
            throw new ThriftTableOperationException(namespaceId, namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespaceproperty");
        }
        catch (Exception e) {
            log.error("Problem altering namespace property", (Throwable)e);
            throw new ThriftTableOperationException(namespaceId, namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespace property");
        }
    }

    private void alterTableProperty(TCredentials c, String tableName, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId;
        String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)op);
        if (!this.master.security.canAlterTable(c, tableId, namespaceId = this.getNamespaceIdFromTableId(op, tableId))) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null || value.isEmpty()) {
                TablePropUtil.removeTableProperty((String)tableId, (String)property);
            } else if (!TablePropUtil.setTableProperty((String)tableId, (String)property, (String)value)) {
                throw new Exception("Invalid table property.");
            }
        }
        catch (KeeperException.NoNodeException e) {
            ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)op);
            log.info("Error altering table property", (Throwable)e);
            throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
        }
        catch (Exception e) {
            log.error("Problem altering table property", (Throwable)e);
            throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
        }
    }

    private void updatePlugins(String property) {
        if (property.equals(Property.MASTER_TABLET_BALANCER.getKey())) {
            TabletBalancer balancer = (TabletBalancer)this.master.getConfiguration().instantiateClassProperty(Property.MASTER_TABLET_BALANCER, TabletBalancer.class, (Object)new DefaultLoadBalancer());
            balancer.init(this.master.getConfigurationFactory());
            this.master.tabletBalancer = balancer;
            log.info("tablet balancer changed to " + this.master.tabletBalancer.getClass().getName());
        }
    }

    public void waitForBalance(TInfo tinfo) throws TException {
        this.master.waitForBalance(tinfo);
    }

    public List<String> getActiveTservers(TInfo tinfo, TCredentials credentials) throws TException {
        Set<TServerInstance> tserverInstances = this.master.onlineTabletServers();
        ArrayList<String> servers = new ArrayList<String>();
        for (TServerInstance tserverInstance : tserverInstances) {
            servers.add(tserverInstance.getLocation().toString());
        }
        return servers;
    }

    public TDelegationToken getDelegationToken(TInfo tinfo, TCredentials credentials, TDelegationTokenConfig tConfig) throws ThriftSecurityException, TException {
        if (!this.master.security.canObtainDelegationToken(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (!this.master.delegationTokensAvailable()) {
            throw new TException("Delegation tokens are not available for use");
        }
        DelegationTokenConfig config = DelegationTokenConfigSerializer.deserialize((TDelegationTokenConfig)tConfig);
        AuthenticationTokenSecretManager secretManager = this.master.getSecretManager();
        try {
            Map.Entry pair = secretManager.generateToken(credentials.principal, config);
            return new TDelegationToken(ByteBuffer.wrap(((Token)pair.getKey()).getPassword()), ((AuthenticationTokenIdentifier)pair.getValue()).getThriftIdentifier());
        }
        catch (Exception e) {
            throw new TException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainReplicationTable(TInfo tfino, TCredentials credentials, String tableName, Set<String> logsToWatch) throws TException {
        BatchScanner bs;
        Connector conn;
        try {
            conn = this.master.getConnector();
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new RuntimeException("Failed to obtain connector", e);
        }
        Text tableId = new Text(this.getTableId(this.master.getInstance(), tableName));
        drainLog.trace("Waiting for {} to be replicated for {}", logsToWatch, (Object)tableId);
        drainLog.trace("Reading from metadata table");
        Set<Range> range = Collections.singleton(new Range(MetadataSchema.ReplicationSection.getRange()));
        try {
            bs = conn.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException("Could not read metadata table", e);
        }
        bs.setRanges(range);
        bs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        try {
            if (!this.allReferencesReplicated(bs, tableId, logsToWatch)) {
                boolean e = false;
                return e;
            }
        }
        finally {
            bs.close();
        }
        drainLog.trace("reading from replication table");
        try {
            bs = conn.createBatchScanner("accumulo.replication", Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException("Replication table was not found", e);
        }
        bs.setRanges(Collections.singleton(new Range()));
        try {
            boolean bl = this.allReferencesReplicated(bs, tableId, logsToWatch);
            return bl;
        }
        finally {
            bs.close();
        }
    }

    protected String getTableId(Instance instance, String tableName) throws ThriftTableOperationException {
        return ClientServiceHandler.checkTableId((Instance)instance, (String)tableName, null);
    }

    protected boolean allReferencesReplicated(BatchScanner bs, Text tableId, Set<String> relevantLogs) {
        Text rowHolder = new Text();
        Text colfHolder = new Text();
        for (Map.Entry entry : bs) {
            String file;
            drainLog.trace("Got key {}", (Object)((Key)entry.getKey()).toStringNoTruncate());
            ((Key)entry.getKey()).getColumnQualifier(rowHolder);
            if (!tableId.equals((Object)rowHolder)) continue;
            ((Key)entry.getKey()).getRow(rowHolder);
            ((Key)entry.getKey()).getColumnFamily(colfHolder);
            if (colfHolder.equals((Object)MetadataSchema.ReplicationSection.COLF)) {
                file = rowHolder.toString();
                file = file.substring(MetadataSchema.ReplicationSection.getRowPrefix().length());
            } else if (colfHolder.equals((Object)ReplicationSchema.OrderSection.NAME)) {
                file = ReplicationSchema.OrderSection.getFile((Key)((Key)entry.getKey()), (Text)rowHolder);
                long timeClosed = ReplicationSchema.OrderSection.getTimeClosed((Key)((Key)entry.getKey()), (Text)rowHolder);
                drainLog.trace("Order section: {} and {}", (Object)timeClosed, (Object)file);
            } else {
                file = rowHolder.toString();
            }
            if (!relevantLogs.contains(file)) {
                drainLog.trace("Found file that we didn't care about {}", (Object)file);
                continue;
            }
            drainLog.trace("Found file that we *do* care about {}", (Object)file);
            try {
                Replication.Status stat = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                if (!StatusUtil.isFullyReplicated((Replication.Status)stat)) {
                    drainLog.trace("{} and {} is not replicated", (Object)file, (Object)ProtobufUtil.toString((GeneratedMessage)stat));
                    return false;
                }
                drainLog.trace("{} and {} is replicated", (Object)file, (Object)ProtobufUtil.toString((GeneratedMessage)stat));
            }
            catch (InvalidProtocolBufferException e) {
                drainLog.trace("Could not parse protobuf for {}", entry.getKey(), (Object)e);
            }
        }
        return true;
    }
}

