/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import com.google.common.base.Optional;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.MoveExportedFiles;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PopulateMetadataTable
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(PopulateMetadataTable.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    PopulateMetadataTable(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readMappingFile(VolumeManager fs, ImportedTableInfo tableInfo) throws Exception {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(tableInfo.importDir, "mappings.txt")), StandardCharsets.UTF_8));){
            HashMap<String, String> map = new HashMap<String, String>();
            String line = null;
            while ((line = in.readLine()) != null) {
                String[] sa = line.split(":", 2);
                map.put(sa[0], sa[1]);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Path path = new Path(this.tableInfo.exportDir, "exportMetadata.zip");
        BatchWriter mbw = null;
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            VolumeManager fs = master.getFileSystem();
            mbw = master.getConnector().createBatchWriter("accumulo.metadata", new BatchWriterConfig());
            zis = new ZipInputStream((InputStream)fs.open(path));
            Map<String, String> fileNameMappings = PopulateMetadataTable.readMappingFile(fs, this.tableInfo);
            log.info("importDir is " + this.tableInfo.importDir);
            String bulkDir = this.tableInfo.importDir;
            String[] tableDirs = ServerConstants.getTablesDirs();
            while ((zipEntry = zis.getNextEntry()) != null) {
                Text endRow;
                if (!zipEntry.getName().equals("metadata.bin")) continue;
                DataInputStream in = new DataInputStream(new BufferedInputStream(zis));
                Key key = new Key();
                Value val = new Value();
                Mutation m = null;
                Text currentRow = null;
                int dirCount = 0;
                do {
                    String absolutePath;
                    String tabletDir;
                    Text cq;
                    key.readFields((DataInput)in);
                    val.readFields((DataInput)in);
                    endRow = new KeyExtent(key.getRow(), (Text)null).getEndRow();
                    Text metadataRow = new KeyExtent(this.tableInfo.tableId, endRow, null).getMetadataEntry();
                    if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                        String oldName = new Path(key.getColumnQualifier().toString()).getName();
                        String newName = fileNameMappings.get(oldName);
                        if (newName == null) {
                            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "File " + oldName + " does not exist in import dir");
                        }
                        cq = new Text(bulkDir + "/" + newName);
                    } else {
                        cq = key.getColumnQualifier();
                    }
                    if (m == null) {
                        tabletDir = new String(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])Constants.CLONE_PREFIX_BYTES), StandardCharsets.UTF_8);
                        absolutePath = this.getClonedTabletDir(master, tableDirs, tabletDir);
                        m = new Mutation(metadataRow);
                        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(absolutePath.getBytes(StandardCharsets.UTF_8)));
                        currentRow = metadataRow;
                    }
                    if (!currentRow.equals((Object)metadataRow)) {
                        mbw.addMutation(m);
                        tabletDir = new String(FastFormat.toZeroPaddedString((long)dirCount++, (int)8, (int)16, (byte[])Constants.CLONE_PREFIX_BYTES), StandardCharsets.UTF_8);
                        absolutePath = this.getClonedTabletDir(master, tableDirs, tabletDir);
                        m = new Mutation(metadataRow);
                        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(absolutePath.getBytes(StandardCharsets.UTF_8)));
                    }
                    m.put(key.getColumnFamily(), cq, val);
                } while (endRow != null || !MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key));
                mbw.addMutation(m);
                break;
            }
            MoveExportedFiles moveExportedFiles = new MoveExportedFiles(this.tableInfo);
            return moveExportedFiles;
        }
        catch (IOException ioe) {
            log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error reading " + path + " " + ioe.getMessage());
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {
                    log.warn("Failed to close zip file ", (Throwable)ioe);
                }
            }
            if (mbw != null) {
                mbw.close();
            }
        }
    }

    protected String getClonedTabletDir(Master master, String[] tableDirs, String tabletDir) {
        String tableDir = master.getFileSystem().choose(Optional.of((Object)this.tableInfo.tableId), tableDirs);
        return tableDir + "/" + this.tableInfo.tableId + "/" + tabletDir;
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTableUtil.deleteTable((String)this.tableInfo.tableId, (boolean)false, (ClientContext)environment, (ZooLock)environment.getMasterLock());
    }
}

