/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CleanUp;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.tables.TableManager;

public class DeleteTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;

    public DeleteTable(String tableId) {
        this.tableId = tableId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        try {
            String namespaceId = Tables.getNamespaceId((Instance)environment.getInstance(), (String)this.tableId);
            return Utils.reserveNamespace(namespaceId, tid, false, false, TableOperation.DELETE) + Utils.reserveTable(this.tableId, tid, true, true, TableOperation.DELETE);
        }
        catch (IllegalArgumentException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof TableNotFoundException) {
                return 0L;
            }
            throw ex;
        }
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        try {
            String namespaceId = Tables.getNamespaceId((Instance)environment.getInstance(), (String)this.tableId);
            TableManager.getInstance().transitionTableState(this.tableId, TableState.DELETING);
            environment.getEventCoordinator().event("deleting table %s ", this.tableId);
            return new CleanUp(this.tableId, namespaceId);
        }
        catch (IllegalArgumentException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof TableNotFoundException) {
                return null;
            }
            throw ex;
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        String namespaceId = Tables.getNamespaceId((Instance)environment.getInstance(), (String)this.tableId);
        Utils.unreserveNamespace(namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, true);
    }
}

