/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.PopulateMetadataTable;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MapImportFileNames
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(MapImportFileNames.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MapImportFileNames(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Path path = new Path(this.tableInfo.importDir, "mappings.txt");
        BufferedWriter mappingsWriter = null;
        try {
            VolumeManager fs = environment.getFileSystem();
            fs.mkdirs(new Path(this.tableInfo.importDir));
            FileStatus[] files = fs.listStatus(new Path(this.tableInfo.exportDir));
            UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
            mappingsWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path), StandardCharsets.UTF_8));
            for (FileStatus fileStatus : files) {
                String fileName = fileStatus.getPath().getName();
                log.info("filename " + fileStatus.getPath().toString());
                String[] sa = fileName.split("\\.");
                String extension = "";
                if (sa.length > 1) {
                    extension = sa[sa.length - 1];
                    if (!FileOperations.getValidExtensions().contains(extension)) {
                        continue;
                    }
                } else {
                    extension = "map";
                }
                String newName = "I" + namer.getNextName() + "." + extension;
                mappingsWriter.append(fileName);
                mappingsWriter.append(':');
                mappingsWriter.append(newName);
                mappingsWriter.newLine();
            }
            mappingsWriter.close();
            mappingsWriter = null;
            PopulateMetadataTable populateMetadataTable = new PopulateMetadataTable(this.tableInfo);
            return populateMetadataTable;
        }
        catch (IOException ioe) {
            log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error writing mapping file " + path + " " + ioe.getMessage());
        }
        finally {
            if (mappingsWriter != null) {
                try {
                    mappingsWriter.close();
                }
                catch (IOException ioe) {
                    log.warn("Failed to close " + path, (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        env.getFileSystem().deleteRecursively(new Path(this.tableInfo.importDir));
    }
}

