/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.CompactionStrategyConfigUtil;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.master.thrift.FateService;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.Validator;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.BulkImport;
import org.apache.accumulo.master.tableOps.CancelCompactions;
import org.apache.accumulo.master.tableOps.ChangeTableState;
import org.apache.accumulo.master.tableOps.CloneTable;
import org.apache.accumulo.master.tableOps.CompactRange;
import org.apache.accumulo.master.tableOps.CreateNamespace;
import org.apache.accumulo.master.tableOps.CreateTable;
import org.apache.accumulo.master.tableOps.DeleteNamespace;
import org.apache.accumulo.master.tableOps.DeleteTable;
import org.apache.accumulo.master.tableOps.ExportTable;
import org.apache.accumulo.master.tableOps.ImportTable;
import org.apache.accumulo.master.tableOps.RenameNamespace;
import org.apache.accumulo.master.tableOps.RenameTable;
import org.apache.accumulo.master.tableOps.TableRangeOp;
import org.apache.accumulo.master.tableOps.TraceRepo;
import org.apache.accumulo.master.util.TableValidators;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;

class FateServiceHandler
implements FateService.Iface {
    protected final Master master;
    protected static final Logger log = Master.log;

    public FateServiceHandler(Master master) {
        this.master = master;
    }

    public long beginFateOperation(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.master.fate.startTransaction();
    }

    public void executeFateOperation(TInfo tinfo, TCredentials c, long opid, FateOperation op, List<ByteBuffer> arguments, Map<String, String> options, boolean autoCleanup) throws ThriftSecurityException, ThriftTableOperationException {
        this.authenticate(c);
        switch (op) {
            case NAMESPACE_CREATE: {
                TableOperation tableOp = TableOperation.CREATE;
                String namespace = this.validateNamespaceArgument(arguments.get(0), tableOp, null);
                if (!this.master.security.canCreateNamespace(c, namespace)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CreateNamespace(c.getPrincipal(), namespace, options)), autoCleanup);
                break;
            }
            case NAMESPACE_RENAME: {
                TableOperation tableOp = TableOperation.RENAME;
                String oldName = this.validateNamespaceArgument(arguments.get(0), tableOp, (Validator<String>)Namespaces.NOT_DEFAULT.and(Namespaces.NOT_ACCUMULO));
                String newName = this.validateNamespaceArgument(arguments.get(1), tableOp, null);
                String namespaceId = ClientServiceHandler.checkNamespaceId((Instance)this.master.getInstance(), (String)oldName, (TableOperation)tableOp);
                if (!this.master.security.canRenameNamespace(c, namespaceId, oldName, newName)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new RenameNamespace(namespaceId, oldName, newName)), autoCleanup);
                break;
            }
            case NAMESPACE_DELETE: {
                TableOperation tableOp = TableOperation.DELETE;
                String namespace = this.validateNamespaceArgument(arguments.get(0), tableOp, (Validator<String>)Namespaces.NOT_DEFAULT.and(Namespaces.NOT_ACCUMULO));
                String namespaceId = ClientServiceHandler.checkNamespaceId((Instance)this.master.getInstance(), (String)namespace, (TableOperation)tableOp);
                if (!this.master.security.canDeleteNamespace(c, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new DeleteNamespace(namespaceId)), autoCleanup);
                break;
            }
            case TABLE_CREATE: {
                String namespaceId;
                TableOperation tableOp = TableOperation.CREATE;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                TimeType timeType = TimeType.valueOf((String)ByteBufferUtil.toString((ByteBuffer)arguments.get(1)));
                try {
                    namespaceId = Namespaces.getNamespaceId((Instance)this.master.getInstance(), (String)((String)Tables.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                if (!this.master.security.canCreateTable(c, tableName, namespaceId)) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CreateTable(c.getPrincipal(), tableName, timeType, options, namespaceId)), autoCleanup);
                break;
            }
            case TABLE_RENAME: {
                boolean canRename;
                TableOperation tableOp = TableOperation.RENAME;
                final String oldTableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String newTableName = this.validateTableNameArgument(arguments.get(1), tableOp, new Validator<String>(){

                    public boolean isValid(String argument) {
                        String oldNamespace = (String)Tables.qualify((String)oldTableName).getFirst();
                        return oldNamespace.equals(Tables.qualify((String)argument).getFirst());
                    }

                    public String invalidMessage(String argument) {
                        return "Cannot move tables to a new namespace by renaming. The namespace for " + oldTableName + " does not match " + argument;
                    }
                });
                String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)oldTableName, (TableOperation)tableOp);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canRename = this.master.security.canRenameTable(c, tableId, oldTableName, newTableName, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, oldTableName, TableOperation.RENAME);
                    throw e;
                }
                if (!canRename) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                try {
                    this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new RenameTable(tableId, oldTableName, newTableName)), autoCleanup);
                    break;
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, oldTableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
            }
            case TABLE_CLONE: {
                boolean canCloneTable;
                String namespaceId;
                TableOperation tableOp = TableOperation.CLONE;
                String srcTableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                String tableName = this.validateTableNameArgument(arguments.get(1), tableOp, TableValidators.NOT_SYSTEM);
                try {
                    namespaceId = Namespaces.getNamespaceId((Instance)this.master.getInstance(), (String)((String)Tables.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                try {
                    canCloneTable = this.master.security.canCloneTable(c, srcTableId, tableName, namespaceId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, srcTableId, null, TableOperation.CLONE);
                    throw e;
                }
                if (!canCloneTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                HashMap<String, String> propertiesToSet = new HashMap<String, String>();
                HashSet<String> propertiesToExclude = new HashSet<String>();
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    if (entry.getKey().startsWith("!")) {
                        propertiesToExclude.add(entry.getKey().substring("!".length()));
                        continue;
                    }
                    if (!TablePropUtil.isPropertyValid((String)entry.getKey(), (String)entry.getValue())) {
                        throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.OTHER, "Property or value not valid " + entry.getKey() + "=" + entry.getValue());
                    }
                    propertiesToSet.put(entry.getKey(), entry.getValue());
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CloneTable(c.getPrincipal(), srcTableId, tableName, propertiesToSet, propertiesToExclude)), autoCleanup);
                break;
            }
            case TABLE_DELETE: {
                boolean canDeleteTable;
                TableOperation tableOp = TableOperation.DELETE;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)tableOp);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canDeleteTable = this.master.security.canDeleteTable(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.DELETE);
                    throw e;
                }
                if (!canDeleteTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new DeleteTable(tableId)), autoCleanup);
                break;
            }
            case TABLE_ONLINE: {
                boolean canOnlineOfflineTable;
                TableOperation tableOp = TableOperation.ONLINE;
                String tableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canOnlineOfflineTable = this.master.security.canOnlineOfflineTable(c, tableId, op, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.ONLINE);
                    throw e;
                }
                if (!canOnlineOfflineTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ChangeTableState(tableId, tableOp)), autoCleanup);
                break;
            }
            case TABLE_OFFLINE: {
                boolean canOnlineOfflineTable;
                TableOperation tableOp = TableOperation.OFFLINE;
                String tableId = this.validateTableIdArgument(arguments.get(0), tableOp, TableValidators.NOT_ROOT_ID);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canOnlineOfflineTable = this.master.security.canOnlineOfflineTable(c, tableId, op, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.OFFLINE);
                    throw e;
                }
                if (!canOnlineOfflineTable) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ChangeTableState(tableId, tableOp)), autoCleanup);
                break;
            }
            case TABLE_MERGE: {
                boolean canMerge;
                TableOperation tableOp = TableOperation.MERGE;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, null);
                Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)tableOp);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canMerge = this.master.security.canMerge(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.MERGE);
                    throw e;
                }
                if (!canMerge) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                Master.log.debug("Creating merge op: " + tableId + " " + startRow + " " + endRow);
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new TableRangeOp(MergeInfo.Operation.MERGE, tableId, startRow, endRow)), autoCleanup);
                break;
            }
            case TABLE_DELETE_RANGE: {
                boolean canDeleteRange;
                TableOperation tableOp = TableOperation.DELETE_RANGE;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_METADATA);
                Text startRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(1));
                Text endRow = ByteBufferUtil.toText((ByteBuffer)arguments.get(2));
                String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)tableOp);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canDeleteRange = this.master.security.canDeleteRange(c, tableId, tableName, startRow, endRow, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.DELETE_RANGE);
                    throw e;
                }
                if (!canDeleteRange) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new TableRangeOp(MergeInfo.Operation.DELETE, tableId, startRow, endRow)), autoCleanup);
                break;
            }
            case TABLE_BULK_IMPORT: {
                boolean canBulkImport;
                TableOperation tableOp = TableOperation.BULK_IMPORT;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String dir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                String failDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(2));
                boolean setTime = Boolean.parseBoolean(ByteBufferUtil.toString((ByteBuffer)arguments.get(3)));
                String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)tableOp);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canBulkImport = this.master.security.canBulkImport(c, tableId, tableName, dir, failDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.BULK_IMPORT);
                    throw e;
                }
                if (!canBulkImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new BulkImport(tableId, dir, failDir, setTime)), autoCleanup);
                break;
            }
            case TABLE_COMPACT: {
                boolean canCompact;
                TableOperation tableOp = TableOperation.COMPACT;
                String tableId = this.validateTableIdArgument(arguments.get(0), tableOp, null);
                byte[] startRow = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(1));
                byte[] endRow = ByteBufferUtil.toBytes((ByteBuffer)arguments.get(2));
                List iterators = IteratorUtil.decodeIteratorSettings((byte[])ByteBufferUtil.toBytes((ByteBuffer)arguments.get(3)));
                CompactionStrategyConfig compactionStrategy = CompactionStrategyConfigUtil.decode((byte[])ByteBufferUtil.toBytes((ByteBuffer)arguments.get(4)));
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canCompact = this.master.security.canCompact(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.COMPACT);
                    throw e;
                }
                if (!canCompact) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CompactRange(tableId, startRow, endRow, iterators, compactionStrategy)), autoCleanup);
                break;
            }
            case TABLE_CANCEL_COMPACT: {
                boolean canCancelCompact;
                TableOperation tableOp = TableOperation.COMPACT_CANCEL;
                String tableId = this.validateTableIdArgument(arguments.get(0), tableOp, null);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canCancelCompact = this.master.security.canCompact(c, tableId, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, null, TableOperation.COMPACT_CANCEL);
                    throw e;
                }
                if (!canCancelCompact) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new CancelCompactions(tableId)), autoCleanup);
                break;
            }
            case TABLE_IMPORT: {
                boolean canImport;
                String namespaceId;
                TableOperation tableOp = TableOperation.IMPORT;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                try {
                    namespaceId = Namespaces.getNamespaceId((Instance)this.master.getInstance(), (String)((String)Tables.qualify((String)tableName).getFirst()));
                }
                catch (NamespaceNotFoundException e) {
                    throw new ThriftTableOperationException(null, tableName, tableOp, TableOperationExceptionType.NAMESPACE_NOTFOUND, "");
                }
                try {
                    canImport = this.master.security.canImport(c, tableName, exportDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, null, tableName, TableOperation.IMPORT);
                    throw e;
                }
                if (!canImport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ImportTable(c.getPrincipal(), tableName, exportDir, namespaceId)), autoCleanup);
                break;
            }
            case TABLE_EXPORT: {
                boolean canExport;
                TableOperation tableOp = TableOperation.EXPORT;
                String tableName = this.validateTableNameArgument(arguments.get(0), tableOp, TableValidators.NOT_SYSTEM);
                String exportDir = ByteBufferUtil.toString((ByteBuffer)arguments.get(1));
                String tableId = ClientServiceHandler.checkTableId((Instance)this.master.getInstance(), (String)tableName, (TableOperation)tableOp);
                String namespaceId = Tables.getNamespaceId((Instance)this.master.getInstance(), (String)tableId);
                try {
                    canExport = this.master.security.canExport(c, tableId, tableName, exportDir, namespaceId);
                }
                catch (ThriftSecurityException e) {
                    this.throwIfTableMissingSecurityException(e, tableId, tableName, TableOperation.EXPORT);
                    throw e;
                }
                if (!canExport) {
                    throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
                this.master.fate.seedTransaction(opid, new TraceRepo<Master>(new ExportTable(tableName, tableId, exportDir)), autoCleanup);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void throwIfTableMissingSecurityException(ThriftSecurityException e, String tableId, String tableName, TableOperation op) throws ThriftTableOperationException {
        if (e.isSetCode() && SecurityErrorCode.TABLE_DOESNT_EXIST == e.getCode()) {
            throw new ThriftTableOperationException(tableId, tableName, op, TableOperationExceptionType.NOTFOUND, "Table no longer exists");
        }
    }

    public String waitForFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException, ThriftTableOperationException {
        this.authenticate(credentials);
        ReadOnlyTStore.TStatus status = this.master.fate.waitForCompletion(opid);
        if (status == ReadOnlyTStore.TStatus.FAILED) {
            Exception e = this.master.fate.getException(opid);
            if (e instanceof ThriftTableOperationException) {
                throw (ThriftTableOperationException)e;
            }
            if (e instanceof ThriftSecurityException) {
                throw (ThriftSecurityException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        String ret = this.master.fate.getReturn(opid);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public void finishFateOperation(TInfo tinfo, TCredentials credentials, long opid) throws ThriftSecurityException {
        this.authenticate(credentials);
        this.master.fate.delete(opid);
    }

    protected void authenticate(TCredentials credentials) throws ThriftSecurityException {
        if (!this.master.security.authenticateUser(credentials, credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
        }
    }

    private String validateTableIdArgument(ByteBuffer tableIdArg, TableOperation op, Validator<String> userValidator) throws ThriftTableOperationException {
        String tableId = tableIdArg == null ? null : ByteBufferUtil.toString((ByteBuffer)tableIdArg);
        try {
            return (String)TableValidators.VALID_ID.and(userValidator).validate((Object)tableId);
        }
        catch (IllegalArgumentException e) {
            String why = e.getMessage();
            log.warn(why);
            throw new ThriftTableOperationException(tableId, null, op, TableOperationExceptionType.INVALID_NAME, why);
        }
    }

    private String validateTableNameArgument(ByteBuffer tableNameArg, TableOperation op, Validator<String> userValidator) throws ThriftTableOperationException {
        String tableName = tableNameArg == null ? null : ByteBufferUtil.toString((ByteBuffer)tableNameArg);
        return this._validateArgument(tableName, op, TableValidators.VALID_NAME.and(userValidator));
    }

    private String validateNamespaceArgument(ByteBuffer namespaceArg, TableOperation op, Validator<String> userValidator) throws ThriftTableOperationException {
        String namespace = namespaceArg == null ? null : ByteBufferUtil.toString((ByteBuffer)namespaceArg);
        return this._validateArgument(namespace, op, Namespaces.VALID_NAME.and(userValidator));
    }

    private <T> T _validateArgument(T arg, TableOperation op, Validator<T> validator) throws ThriftTableOperationException {
        try {
            return (T)validator.validate(arg);
        }
        catch (IllegalArgumentException e) {
            String why = e.getMessage();
            log.warn(why);
            throw new ThriftTableOperationException(null, String.valueOf(arg), op, TableOperationExceptionType.INVALID_NAME, why);
        }
    }
}

