/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tserverOps;

import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TTransportException;

public class ShutdownTServer
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ShutdownTServer.class);
    private TServerInstance server;
    private boolean force;

    public ShutdownTServer(TServerInstance server, boolean force) {
        this.server = server;
        this.force = force;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        if (this.force) {
            String path = ZooUtil.getRoot((Instance)master.getInstance()) + "/tservers" + "/" + this.server.getLocation();
            ZooLock.deleteLock((String)path);
            path = ZooUtil.getRoot((Instance)master.getInstance()) + "/dead/tservers" + "/" + this.server.getLocation();
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            zoo.putPersistentData(path, "forced down".getBytes(Constants.UTF8), ZooUtil.NodeExistsPolicy.OVERWRITE);
            return null;
        }
        EventCoordinator.Listener listener = master.getEventCoordinator().getListener();
        master.shutdownTServer(this.server);
        while (master.onlineTabletServers().contains(this.server)) {
            LiveTServerSet.TServerConnection connection = master.getConnection(this.server);
            if (connection != null) {
                try {
                    TabletServerStatus status = connection.getTableMap(false);
                    if (status.tableMap != null && status.tableMap.isEmpty()) {
                        log.info((Object)("tablet server hosts no tablets " + this.server));
                        connection.halt(master.getMasterLock());
                        log.info((Object)("tablet server asked to halt " + this.server));
                        break;
                    }
                }
                catch (TTransportException ex) {
                }
                catch (Exception ex) {
                    log.error((Object)("Error talking to tablet server " + this.server + ": " + ex));
                }
            }
            listener.waitForEvents(1000L);
        }
        return null;
    }

    @Override
    public void undo(long tid, Master m) throws Exception {
    }
}

