/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.hadoop.mapreduce.FileOutputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.FileOutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class FileOutputFormatBuilderImpl<T>
implements FileOutputFormatBuilder,
FileOutputFormatBuilder.PathParams<T>,
FileOutputFormatBuilder.OutputOptions<T> {
    Class<?> callingClass;
    Path outputPath;
    Optional<String> comp = Optional.empty();
    Optional<Long> dataBlockSize = Optional.empty();
    Optional<Long> fileBlockSize = Optional.empty();
    Optional<Long> indexBlockSize = Optional.empty();
    Optional<Integer> replication = Optional.empty();
    Optional<SamplerConfiguration> sampler = Optional.empty();
    Collection<SummarizerConfiguration> summarizers = Collections.emptySet();

    public FileOutputFormatBuilderImpl(Class<?> callingClass) {
        this.callingClass = callingClass;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> outputPath(Path path) {
        this.outputPath = Objects.requireNonNull(path);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> compression(String compressionType) {
        this.comp = Optional.of(compressionType);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> dataBlockSize(long dataBlockSize) {
        this.dataBlockSize = Optional.of(dataBlockSize);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> fileBlockSize(long fileBlockSize) {
        this.fileBlockSize = Optional.of(fileBlockSize);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> indexBlockSize(long indexBlockSize) {
        this.indexBlockSize = Optional.of(indexBlockSize);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> replication(int replication) {
        this.replication = Optional.of(replication);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> sampler(SamplerConfiguration samplerConfig) {
        this.sampler = Optional.of(samplerConfig);
        return this;
    }

    @Override
    public FileOutputFormatBuilder.OutputOptions<T> summarizers(SummarizerConfiguration ... summarizerConfigs) {
        this.summarizers = Arrays.asList(Objects.requireNonNull(summarizerConfigs));
        return this;
    }

    @Override
    public void store(T j) {
        if (j instanceof Job) {
            this.store((Job)j);
        } else if (j instanceof JobConf) {
            this.store((JobConf)j);
        } else {
            throw new IllegalArgumentException("Unexpected type " + j.getClass().getName());
        }
    }

    @Override
    private void store(Job job) {
        FileOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        this._store(job.getConfiguration());
    }

    private void _store(Configuration conf) {
        if (this.comp.isPresent()) {
            FileOutputConfigurator.setCompressionType(this.callingClass, conf, this.comp.get());
        }
        if (this.dataBlockSize.isPresent()) {
            FileOutputConfigurator.setDataBlockSize(this.callingClass, conf, this.dataBlockSize.get());
        }
        if (this.fileBlockSize.isPresent()) {
            FileOutputConfigurator.setFileBlockSize(this.callingClass, conf, this.fileBlockSize.get());
        }
        if (this.indexBlockSize.isPresent()) {
            FileOutputConfigurator.setIndexBlockSize(this.callingClass, conf, this.indexBlockSize.get());
        }
        if (this.replication.isPresent()) {
            FileOutputConfigurator.setReplication(this.callingClass, conf, this.replication.get());
        }
        if (this.sampler.isPresent()) {
            FileOutputConfigurator.setSampler(this.callingClass, conf, this.sampler.get());
        }
        if (this.summarizers.size() > 0) {
            FileOutputConfigurator.setSummarizers(this.callingClass, conf, this.summarizers.toArray(new SummarizerConfiguration[0]));
        }
    }

    @Override
    private void store(JobConf job) {
        org.apache.hadoop.mapred.FileOutputFormat.setOutputPath((JobConf)job, (Path)this.outputPath);
        this._store((Configuration)job);
    }
}

