/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.provider.managed;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ServerConfiguration;

public abstract class AbstractServerConfiguration
extends ServerConfiguration {
    private final String host;
    private final int port;
    private final boolean secure;

    protected AbstractServerConfiguration(RequestContext request) {
        Object ohost = request.getProperty(RequestContext.Property.SERVERNAME);
        Object oport = request.getProperty(RequestContext.Property.SERVERPORT);
        Object osec = request.getProperty(RequestContext.Property.SECURE);
        this.host = ohost != null ? (String)ohost : "localhost";
        this.port = oport != null ? (Integer)oport : 9002;
        this.secure = osec != null ? (Boolean)osec : false;
    }

    public String getAdapterConfigLocation() {
        return "abdera/adapter/config/";
    }

    public String getFeedConfigLocation() {
        return "abdera/adapter/";
    }

    public String getFeedConfigSuffix() {
        return ".properties";
    }

    public int getPort() {
        return this.port;
    }

    public String getServerUri() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.secure ? "https://" : "http://");
        buf.append(this.host);
        if (this.port != 80) {
            buf.append(":");
            buf.append(this.port);
        }
        return buf.toString();
    }

    public FeedConfiguration loadFeedConfiguration(String feedId) throws IOException {
        String fileName = String.valueOf(this.getFeedConfigLocation()) + feedId + this.getFeedConfigSuffix();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (in == null) {
            throw new FileNotFoundException();
        }
        Properties props = new Properties();
        props.load(in);
        in.close();
        return FeedConfiguration.getFeedConfiguration(feedId, props, this);
    }
}

