/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceManager;

public class DefaultWorkspaceManager
extends AbstractWorkspaceManager {
    private static final String URI_GEN_DELIMS = ":/?#[]@";
    public static final String COLLECTION_ADAPTER_ATTRIBUTE = "collectionProvider";

    public CollectionAdapter getCollectionAdapter(RequestContext request) {
        String path = String.valueOf(request.getTargetBasePath()) + request.getTargetPath();
        CollectionAdapter ca = (CollectionAdapter)request.getAttribute(RequestContext.Scope.REQUEST, COLLECTION_ADAPTER_ATTRIBUTE);
        if (ca != null) {
            return ca;
        }
        for (WorkspaceInfo wi : this.workspaces) {
            for (CollectionInfo ci : wi.getCollections(request)) {
                String href = ci.getHref(request);
                if (!path.equals(href) && (href == null || !path.startsWith(href) || !URI_GEN_DELIMS.contains(path.substring(href.length(), href.length() + 1)))) continue;
                return (CollectionAdapter)((Object)ci);
            }
        }
        return null;
    }
}

