/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.xmlsec;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.security.SignatureOptions;
import org.apache.abdera.security.xmlsec.XmlSecurityOptions;

public class XmlSignatureOptions
extends XmlSecurityOptions
implements SignatureOptions {
    private PrivateKey signingKey = null;
    private PublicKey publickey = null;
    private X509Certificate cert = null;
    private String[] linkrels = null;
    private boolean signlinks = false;
    private List<String> references = new ArrayList<String>();
    private String algo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";

    public String getSigningAlgorithm() {
        return this.algo;
    }

    public SignatureOptions setSigningAlgorithm(String algorithm) {
        this.algo = algorithm;
        return this;
    }

    protected XmlSignatureOptions(Abdera abdera) {
        super(abdera);
    }

    public PrivateKey getSigningKey() {
        return this.signingKey;
    }

    public SignatureOptions setSigningKey(PrivateKey privateKey) {
        this.signingKey = privateKey;
        return this;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public SignatureOptions setCertificate(X509Certificate cert) {
        this.cert = cert;
        return this;
    }

    public SignatureOptions addReference(String href) {
        if (!this.references.contains(href)) {
            this.references.add(href);
        }
        return this;
    }

    public String[] getReferences() {
        return this.references.toArray(new String[this.references.size()]);
    }

    public PublicKey getPublicKey() {
        return this.publickey;
    }

    public SignatureOptions setPublicKey(PublicKey publickey) {
        this.publickey = publickey;
        return this;
    }

    public boolean isSignLinks() {
        return this.signlinks;
    }

    public SignatureOptions setSignLinks(boolean signlinks) {
        this.signlinks = signlinks;
        return this;
    }

    public String[] getSignLinkRels() {
        return this.linkrels;
    }

    public SignatureOptions setSignedLinkRels(String ... rel) {
        this.linkrels = rel;
        return this;
    }
}

