/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextWrapper;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.abdera.writer.Writer;

public abstract class AbstractEncryptedResponseFilter
implements Filter {
    public AbstractEncryptedResponseFilter() {
        this.initProvider();
    }

    protected void initProvider() {
    }

    protected void addProvider(Provider provider) {
        if (Security.getProvider(provider.getName()) == null) {
            Security.addProvider(provider);
        }
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        Object arg = this.initArg(request);
        if (this.doEncryption(request, arg)) {
            return new EncryptingResponseContext(request.getAbdera(), request, chain.next(request), arg);
        }
        return chain.next(request);
    }

    protected abstract boolean doEncryption(RequestContext var1, Object var2);

    protected abstract EncryptionOptions initEncryptionOptions(RequestContext var1, ResponseContext var2, Encryption var3, Object var4);

    protected abstract Object initArg(RequestContext var1);

    private class EncryptingResponseContext
    extends ResponseContextWrapper {
        private final RequestContext request;
        private final AbderaSecurity security;
        private final Abdera abdera;
        private final Object arg;

        public EncryptingResponseContext(Abdera abdera, RequestContext request, ResponseContext response, Object arg) {
            super(response);
            this.abdera = abdera;
            this.request = request;
            this.security = new AbderaSecurity(abdera);
            this.arg = arg;
        }

        public void writeTo(OutputStream out, Writer writer) throws IOException {
            try {
                this.encrypt(out, null);
            }
            catch (Exception se) {
                throw new RuntimeException(se);
            }
        }

        public void writeTo(OutputStream out) throws IOException {
            try {
                this.encrypt(out, null);
            }
            catch (Exception se) {
                throw new RuntimeException(se);
            }
        }

        private void encrypt(OutputStream aout, Writer writer) throws Exception {
            Document doc = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (writer == null) {
                    super.writeTo((OutputStream)out);
                } else {
                    super.writeTo((OutputStream)out, writer);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                doc = this.abdera.getParser().parse((InputStream)in);
            }
            catch (Exception out) {
                // empty catch block
            }
            if (doc != null) {
                Encryption enc = this.security.getEncryption();
                EncryptionOptions options = AbstractEncryptedResponseFilter.this.initEncryptionOptions(this.request, this.response, enc, this.arg);
                doc = enc.encrypt(doc, options);
            }
            if (doc == null) {
                throw new RuntimeException("There was an error encrypting the response");
            }
            doc.writeTo(aout);
        }
    }
}

