/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.opensearch.server.impl;

import java.util.ArrayList;
import org.apache.abdera.ext.opensearch.model.OpenSearchDescription;
import org.apache.abdera.ext.opensearch.model.Query;
import org.apache.abdera.ext.opensearch.model.Url;
import org.apache.abdera.ext.opensearch.server.OpenSearchInfo;
import org.apache.abdera.ext.opensearch.server.OpenSearchQueryInfo;
import org.apache.abdera.ext.opensearch.server.OpenSearchUrlInfo;
import org.apache.abdera.protocol.server.RequestContext;

public class SimpleOpenSearchInfo
implements OpenSearchInfo {
    private String shortName;
    private String description;
    private String[] tags;
    private OpenSearchQueryInfo[] queries;
    private OpenSearchUrlInfo[] urls;

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String ... tags) {
        this.tags = tags;
    }

    public OpenSearchQueryInfo[] getQueries() {
        return this.queries;
    }

    public void setQueries(OpenSearchQueryInfo ... queries) {
        this.queries = queries;
    }

    public OpenSearchUrlInfo[] getUrls() {
        return this.urls;
    }

    public void setUrls(OpenSearchUrlInfo ... urls) {
        this.urls = urls;
    }

    public OpenSearchDescription asOpenSearchDescriptionElement(RequestContext request) {
        OpenSearchDescription document = new OpenSearchDescription(request.getAbdera());
        document.setShortName(this.shortName);
        document.setDescription(this.description);
        document.setTags(this.tags);
        if (this.urls != null) {
            ArrayList<Url> urlElements = new ArrayList<Url>(this.urls.length);
            for (OpenSearchUrlInfo urlInfo : this.urls) {
                urlElements.add(urlInfo.asUrlElement(request));
            }
            document.addUrls(urlElements.toArray(new Url[this.urls.length]));
        }
        if (this.queries != null) {
            ArrayList<Query> queryElements = new ArrayList<Query>(this.queries.length);
            for (OpenSearchQueryInfo queryInfo : this.queries) {
                queryElements.add(queryInfo.asQueryElement(request));
            }
            document.addQueries(queryElements.toArray(new Query[this.queries.length]));
        }
        return document;
    }
}

