/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.html;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.htmlparser.sax.HtmlSerializer;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Div;
import org.xml.sax.InputSource;

public class HtmlHelper {
    public static Div parse(String value) {
        return HtmlHelper.parse(new Abdera(), value);
    }

    public static Div parse(InputStream in) {
        return HtmlHelper.parse(new Abdera(), in);
    }

    public static Div parse(InputStream in, String charset) {
        return HtmlHelper.parse(new Abdera(), in, charset);
    }

    public static Div parse(Reader in) {
        return HtmlHelper.parse(new Abdera(), in);
    }

    public static Div parse(Abdera abdera, String value) {
        return HtmlHelper.parse(abdera, new StringReader(value));
    }

    public static Div parse(Abdera abdera, InputStream in) {
        return HtmlHelper.parse(abdera, in, "UTF-8");
    }

    public static Div parse(Abdera abdera, InputStream in, String charset) {
        try {
            return HtmlHelper.parse(abdera, new InputStreamReader(in, charset));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Div parse(Abdera abdera, Reader in) {
        String result = null;
        Div div = abdera.getFactory().newDiv();
        try {
            HtmlParser htmlParser = new HtmlParser();
            htmlParser.setBogusXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
            htmlParser.setMappingLangToXmlLang(true);
            htmlParser.setReportingDoctype(false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            HtmlSerializer ser = new HtmlSerializer(w);
            htmlParser.setContentHandler(ser);
            htmlParser.setLexicalHandler(ser);
            htmlParser.parseFragment(new InputSource(in), "div");
            ((Writer)w).flush();
            result = new String(out.toByteArray(), "UTF-8");
            div.setValue(result);
            return div;
        }
        catch (Exception e) {
            if (result != null) {
                div.setText(result);
            }
            return div;
        }
    }
}

