/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeInfo;
import nu.validator.htmlparser.impl.AttributesImpl;
import nu.validator.htmlparser.impl.ContentModelFlag;
import nu.validator.htmlparser.impl.EmptyAttributes;
import nu.validator.htmlparser.impl.EncodingInfo;
import nu.validator.htmlparser.impl.Entities;
import nu.validator.htmlparser.impl.HtmlInputStreamReader;
import nu.validator.htmlparser.impl.TokenHandler;
import nu.validator.htmlparser.impl.XmlLangAttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Tokenizer
implements Locator {
    private static final Pattern NCNAME_PATTERN = Pattern.compile("(?:[\\u0041-\\u005A]|[\\u0061-\\u007A]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u00FF]|[\\u0100-\\u0131]|[\\u0134-\\u013E]|[\\u0141-\\u0148]|[\\u014A-\\u017E]|[\\u0180-\\u01C3]|[\\u01CD-\\u01F0]|[\\u01F4-\\u01F5]|[\\u01FA-\\u0217]|[\\u0250-\\u02A8]|[\\u02BB-\\u02C1]|\\u0386|[\\u0388-\\u038A]|\\u038C|[\\u038E-\\u03A1]|[\\u03A3-\\u03CE]|[\\u03D0-\\u03D6]|\\u03DA|\\u03DC|\\u03DE|\\u03E0|[\\u03E2-\\u03F3]|[\\u0401-\\u040C]|[\\u040E-\\u044F]|[\\u0451-\\u045C]|[\\u045E-\\u0481]|[\\u0490-\\u04C4]|[\\u04C7-\\u04C8]|[\\u04CB-\\u04CC]|[\\u04D0-\\u04EB]|[\\u04EE-\\u04F5]|[\\u04F8-\\u04F9]|[\\u0531-\\u0556]|\\u0559|[\\u0561-\\u0586]|[\\u05D0-\\u05EA]|[\\u05F0-\\u05F2]|[\\u0621-\\u063A]|[\\u0641-\\u064A]|[\\u0671-\\u06B7]|[\\u06BA-\\u06BE]|[\\u06C0-\\u06CE]|[\\u06D0-\\u06D3]|\\u06D5|[\\u06E5-\\u06E6]|[\\u0905-\\u0939]|\\u093D|[\\u0958-\\u0961]|[\\u0985-\\u098C]|[\\u098F-\\u0990]|[\\u0993-\\u09A8]|[\\u09AA-\\u09B0]|\\u09B2|[\\u09B6-\\u09B9]|[\\u09DC-\\u09DD]|[\\u09DF-\\u09E1]|[\\u09F0-\\u09F1]|[\\u0A05-\\u0A0A]|[\\u0A0F-\\u0A10]|[\\u0A13-\\u0A28]|[\\u0A2A-\\u0A30]|[\\u0A32-\\u0A33]|[\\u0A35-\\u0A36]|[\\u0A38-\\u0A39]|[\\u0A59-\\u0A5C]|\\u0A5E|[\\u0A72-\\u0A74]|[\\u0A85-\\u0A8B]|\\u0A8D|[\\u0A8F-\\u0A91]|[\\u0A93-\\u0AA8]|[\\u0AAA-\\u0AB0]|[\\u0AB2-\\u0AB3]|[\\u0AB5-\\u0AB9]|\\u0ABD|\\u0AE0|[\\u0B05-\\u0B0C]|[\\u0B0F-\\u0B10]|[\\u0B13-\\u0B28]|[\\u0B2A-\\u0B30]|[\\u0B32-\\u0B33]|[\\u0B36-\\u0B39]|\\u0B3D|[\\u0B5C-\\u0B5D]|[\\u0B5F-\\u0B61]|[\\u0B85-\\u0B8A]|[\\u0B8E-\\u0B90]|[\\u0B92-\\u0B95]|[\\u0B99-\\u0B9A]|\\u0B9C|[\\u0B9E-\\u0B9F]|[\\u0BA3-\\u0BA4]|[\\u0BA8-\\u0BAA]|[\\u0BAE-\\u0BB5]|[\\u0BB7-\\u0BB9]|[\\u0C05-\\u0C0C]|[\\u0C0E-\\u0C10]|[\\u0C12-\\u0C28]|[\\u0C2A-\\u0C33]|[\\u0C35-\\u0C39]|[\\u0C60-\\u0C61]|[\\u0C85-\\u0C8C]|[\\u0C8E-\\u0C90]|[\\u0C92-\\u0CA8]|[\\u0CAA-\\u0CB3]|[\\u0CB5-\\u0CB9]|\\u0CDE|[\\u0CE0-\\u0CE1]|[\\u0D05-\\u0D0C]|[\\u0D0E-\\u0D10]|[\\u0D12-\\u0D28]|[\\u0D2A-\\u0D39]|[\\u0D60-\\u0D61]|[\\u0E01-\\u0E2E]|\\u0E30|[\\u0E32-\\u0E33]|[\\u0E40-\\u0E45]|[\\u0E81-\\u0E82]|\\u0E84|[\\u0E87-\\u0E88]|\\u0E8A|\\u0E8D|[\\u0E94-\\u0E97]|[\\u0E99-\\u0E9F]|[\\u0EA1-\\u0EA3]|\\u0EA5|\\u0EA7|[\\u0EAA-\\u0EAB]|[\\u0EAD-\\u0EAE]|\\u0EB0|[\\u0EB2-\\u0EB3]|\\u0EBD|[\\u0EC0-\\u0EC4]|[\\u0F40-\\u0F47]|[\\u0F49-\\u0F69]|[\\u10A0-\\u10C5]|[\\u10D0-\\u10F6]|\\u1100|[\\u1102-\\u1103]|[\\u1105-\\u1107]|\\u1109|[\\u110B-\\u110C]|[\\u110E-\\u1112]|\\u113C|\\u113E|\\u1140|\\u114C|\\u114E|\\u1150|[\\u1154-\\u1155]|\\u1159|[\\u115F-\\u1161]|\\u1163|\\u1165|\\u1167|\\u1169|[\\u116D-\\u116E]|[\\u1172-\\u1173]|\\u1175|\\u119E|\\u11A8|\\u11AB|[\\u11AE-\\u11AF]|[\\u11B7-\\u11B8]|\\u11BA|[\\u11BC-\\u11C2]|\\u11EB|\\u11F0|\\u11F9|[\\u1E00-\\u1E9B]|[\\u1EA0-\\u1EF9]|[\\u1F00-\\u1F15]|[\\u1F18-\\u1F1D]|[\\u1F20-\\u1F45]|[\\u1F48-\\u1F4D]|[\\u1F50-\\u1F57]|\\u1F59|\\u1F5B|\\u1F5D|[\\u1F5F-\\u1F7D]|[\\u1F80-\\u1FB4]|[\\u1FB6-\\u1FBC]|\\u1FBE|[\\u1FC2-\\u1FC4]|[\\u1FC6-\\u1FCC]|[\\u1FD0-\\u1FD3]|[\\u1FD6-\\u1FDB]|[\\u1FE0-\\u1FEC]|[\\u1FF2-\\u1FF4]|[\\u1FF6-\\u1FFC]|\\u2126|[\\u212A-\\u212B]|\\u212E|[\\u2180-\\u2182]|[\\u3041-\\u3094]|[\\u30A1-\\u30FA]|[\\u3105-\\u312C]|[\\uAC00-\\uD7A3]|[\\u4E00-\\u9FA5]|\\u3007|[\\u3021-\\u3029]|_)(?:[\\u0030-\\u0039]|[\\u0660-\\u0669]|[\\u06F0-\\u06F9]|[\\u0966-\\u096F]|[\\u09E6-\\u09EF]|[\\u0A66-\\u0A6F]|[\\u0AE6-\\u0AEF]|[\\u0B66-\\u0B6F]|[\\u0BE7-\\u0BEF]|[\\u0C66-\\u0C6F]|[\\u0CE6-\\u0CEF]|[\\u0D66-\\u0D6F]|[\\u0E50-\\u0E59]|[\\u0ED0-\\u0ED9]|[\\u0F20-\\u0F29]|[\\u0041-\\u005A]|[\\u0061-\\u007A]|[\\u00C0-\\u00D6]|[\\u00D8-\\u00F6]|[\\u00F8-\\u00FF]|[\\u0100-\\u0131]|[\\u0134-\\u013E]|[\\u0141-\\u0148]|[\\u014A-\\u017E]|[\\u0180-\\u01C3]|[\\u01CD-\\u01F0]|[\\u01F4-\\u01F5]|[\\u01FA-\\u0217]|[\\u0250-\\u02A8]|[\\u02BB-\\u02C1]|\\u0386|[\\u0388-\\u038A]|\\u038C|[\\u038E-\\u03A1]|[\\u03A3-\\u03CE]|[\\u03D0-\\u03D6]|\\u03DA|\\u03DC|\\u03DE|\\u03E0|[\\u03E2-\\u03F3]|[\\u0401-\\u040C]|[\\u040E-\\u044F]|[\\u0451-\\u045C]|[\\u045E-\\u0481]|[\\u0490-\\u04C4]|[\\u04C7-\\u04C8]|[\\u04CB-\\u04CC]|[\\u04D0-\\u04EB]|[\\u04EE-\\u04F5]|[\\u04F8-\\u04F9]|[\\u0531-\\u0556]|\\u0559|[\\u0561-\\u0586]|[\\u05D0-\\u05EA]|[\\u05F0-\\u05F2]|[\\u0621-\\u063A]|[\\u0641-\\u064A]|[\\u0671-\\u06B7]|[\\u06BA-\\u06BE]|[\\u06C0-\\u06CE]|[\\u06D0-\\u06D3]|\\u06D5|[\\u06E5-\\u06E6]|[\\u0905-\\u0939]|\\u093D|[\\u0958-\\u0961]|[\\u0985-\\u098C]|[\\u098F-\\u0990]|[\\u0993-\\u09A8]|[\\u09AA-\\u09B0]|\\u09B2|[\\u09B6-\\u09B9]|[\\u09DC-\\u09DD]|[\\u09DF-\\u09E1]|[\\u09F0-\\u09F1]|[\\u0A05-\\u0A0A]|[\\u0A0F-\\u0A10]|[\\u0A13-\\u0A28]|[\\u0A2A-\\u0A30]|[\\u0A32-\\u0A33]|[\\u0A35-\\u0A36]|[\\u0A38-\\u0A39]|[\\u0A59-\\u0A5C]|\\u0A5E|[\\u0A72-\\u0A74]|[\\u0A85-\\u0A8B]|\\u0A8D|[\\u0A8F-\\u0A91]|[\\u0A93-\\u0AA8]|[\\u0AAA-\\u0AB0]|[\\u0AB2-\\u0AB3]|[\\u0AB5-\\u0AB9]|\\u0ABD|\\u0AE0|[\\u0B05-\\u0B0C]|[\\u0B0F-\\u0B10]|[\\u0B13-\\u0B28]|[\\u0B2A-\\u0B30]|[\\u0B32-\\u0B33]|[\\u0B36-\\u0B39]|\\u0B3D|[\\u0B5C-\\u0B5D]|[\\u0B5F-\\u0B61]|[\\u0B85-\\u0B8A]|[\\u0B8E-\\u0B90]|[\\u0B92-\\u0B95]|[\\u0B99-\\u0B9A]|\\u0B9C|[\\u0B9E-\\u0B9F]|[\\u0BA3-\\u0BA4]|[\\u0BA8-\\u0BAA]|[\\u0BAE-\\u0BB5]|[\\u0BB7-\\u0BB9]|[\\u0C05-\\u0C0C]|[\\u0C0E-\\u0C10]|[\\u0C12-\\u0C28]|[\\u0C2A-\\u0C33]|[\\u0C35-\\u0C39]|[\\u0C60-\\u0C61]|[\\u0C85-\\u0C8C]|[\\u0C8E-\\u0C90]|[\\u0C92-\\u0CA8]|[\\u0CAA-\\u0CB3]|[\\u0CB5-\\u0CB9]|\\u0CDE|[\\u0CE0-\\u0CE1]|[\\u0D05-\\u0D0C]|[\\u0D0E-\\u0D10]|[\\u0D12-\\u0D28]|[\\u0D2A-\\u0D39]|[\\u0D60-\\u0D61]|[\\u0E01-\\u0E2E]|\\u0E30|[\\u0E32-\\u0E33]|[\\u0E40-\\u0E45]|[\\u0E81-\\u0E82]|\\u0E84|[\\u0E87-\\u0E88]|\\u0E8A|\\u0E8D|[\\u0E94-\\u0E97]|[\\u0E99-\\u0E9F]|[\\u0EA1-\\u0EA3]|\\u0EA5|\\u0EA7|[\\u0EAA-\\u0EAB]|[\\u0EAD-\\u0EAE]|\\u0EB0|[\\u0EB2-\\u0EB3]|\\u0EBD|[\\u0EC0-\\u0EC4]|[\\u0F40-\\u0F47]|[\\u0F49-\\u0F69]|[\\u10A0-\\u10C5]|[\\u10D0-\\u10F6]|\\u1100|[\\u1102-\\u1103]|[\\u1105-\\u1107]|\\u1109|[\\u110B-\\u110C]|[\\u110E-\\u1112]|\\u113C|\\u113E|\\u1140|\\u114C|\\u114E|\\u1150|[\\u1154-\\u1155]|\\u1159|[\\u115F-\\u1161]|\\u1163|\\u1165|\\u1167|\\u1169|[\\u116D-\\u116E]|[\\u1172-\\u1173]|\\u1175|\\u119E|\\u11A8|\\u11AB|[\\u11AE-\\u11AF]|[\\u11B7-\\u11B8]|\\u11BA|[\\u11BC-\\u11C2]|\\u11EB|\\u11F0|\\u11F9|[\\u1E00-\\u1E9B]|[\\u1EA0-\\u1EF9]|[\\u1F00-\\u1F15]|[\\u1F18-\\u1F1D]|[\\u1F20-\\u1F45]|[\\u1F48-\\u1F4D]|[\\u1F50-\\u1F57]|\\u1F59|\\u1F5B|\\u1F5D|[\\u1F5F-\\u1F7D]|[\\u1F80-\\u1FB4]|[\\u1FB6-\\u1FBC]|\\u1FBE|[\\u1FC2-\\u1FC4]|[\\u1FC6-\\u1FCC]|[\\u1FD0-\\u1FD3]|[\\u1FD6-\\u1FDB]|[\\u1FE0-\\u1FEC]|[\\u1FF2-\\u1FF4]|[\\u1FF6-\\u1FFC]|\\u2126|[\\u212A-\\u212B]|\\u212E|[\\u2180-\\u2182]|[\\u3041-\\u3094]|[\\u30A1-\\u30FA]|[\\u3105-\\u312C]|[\\uAC00-\\uD7A3]|[\\u4E00-\\u9FA5]|\\u3007|[\\u3021-\\u3029]|_|\\.|-|[\\u0300-\\u0345]|[\\u0360-\\u0361]|[\\u0483-\\u0486]|[\\u0591-\\u05A1]|[\\u05A3-\\u05B9]|[\\u05BB-\\u05BD]|\\u05BF|[\\u05C1-\\u05C2]|\\u05C4|[\\u064B-\\u0652]|\\u0670|[\\u06D6-\\u06DC]|[\\u06DD-\\u06DF]|[\\u06E0-\\u06E4]|[\\u06E7-\\u06E8]|[\\u06EA-\\u06ED]|[\\u0901-\\u0903]|\\u093C|[\\u093E-\\u094C]|\\u094D|[\\u0951-\\u0954]|[\\u0962-\\u0963]|[\\u0981-\\u0983]|\\u09BC|\\u09BE|\\u09BF|[\\u09C0-\\u09C4]|[\\u09C7-\\u09C8]|[\\u09CB-\\u09CD]|\\u09D7|[\\u09E2-\\u09E3]|\\u0A02|\\u0A3C|\\u0A3E|\\u0A3F|[\\u0A40-\\u0A42]|[\\u0A47-\\u0A48]|[\\u0A4B-\\u0A4D]|[\\u0A70-\\u0A71]|[\\u0A81-\\u0A83]|\\u0ABC|[\\u0ABE-\\u0AC5]|[\\u0AC7-\\u0AC9]|[\\u0ACB-\\u0ACD]|[\\u0B01-\\u0B03]|\\u0B3C|[\\u0B3E-\\u0B43]|[\\u0B47-\\u0B48]|[\\u0B4B-\\u0B4D]|[\\u0B56-\\u0B57]|[\\u0B82-\\u0B83]|[\\u0BBE-\\u0BC2]|[\\u0BC6-\\u0BC8]|[\\u0BCA-\\u0BCD]|\\u0BD7|[\\u0C01-\\u0C03]|[\\u0C3E-\\u0C44]|[\\u0C46-\\u0C48]|[\\u0C4A-\\u0C4D]|[\\u0C55-\\u0C56]|[\\u0C82-\\u0C83]|[\\u0CBE-\\u0CC4]|[\\u0CC6-\\u0CC8]|[\\u0CCA-\\u0CCD]|[\\u0CD5-\\u0CD6]|[\\u0D02-\\u0D03]|[\\u0D3E-\\u0D43]|[\\u0D46-\\u0D48]|[\\u0D4A-\\u0D4D]|\\u0D57|\\u0E31|[\\u0E34-\\u0E3A]|[\\u0E47-\\u0E4E]|\\u0EB1|[\\u0EB4-\\u0EB9]|[\\u0EBB-\\u0EBC]|[\\u0EC8-\\u0ECD]|[\\u0F18-\\u0F19]|\\u0F35|\\u0F37|\\u0F39|\\u0F3E|\\u0F3F|[\\u0F71-\\u0F84]|[\\u0F86-\\u0F8B]|[\\u0F90-\\u0F95]|\\u0F97|[\\u0F99-\\u0FAD]|[\\u0FB1-\\u0FB7]|\\u0FB9|[\\u20D0-\\u20DC]|\\u20E1|[\\u302A-\\u302F]|\\u3099|\\u309A|\\u00B7|\\u02D0|\\u02D1|\\u0387|\\u0640|\\u0E46|\\u0EC6|\\u3005|[\\u3031-\\u3035]|[\\u309D-\\u309E]|[\\u30FC-\\u30FE])*");
    private static final int LEAD_OFFSET = 55232;
    private static final int SURROGATE_OFFSET = -56613888;
    private static final char[] LT_GT = new char[]{'<', '>'};
    private static final char[] LT_SOLIDUS = new char[]{'<', '/'};
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};
    private static final char[] SPACE = new char[]{' '};
    private static final char[] LF = new char[]{'\n'};
    private static final int BUFFER_GROW_BY = 1024;
    private static final String[] VOID_ELEMENTS = new String[]{"area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param"};
    private static final char[] OCTYPE = "octype".toCharArray();
    private static final char[] UBLIC = "ublic".toCharArray();
    private static final char[] YSTEM = "ystem".toCharArray();
    private final TokenHandler tokenHandler;
    private ErrorHandler errorHandler;
    private Reader reader;
    private char[] buf = new char[2048];
    private int pos;
    private int cstart;
    private int bufLen;
    private char prev;
    private final char[] prevFour = new char[4];
    private int prevFourPtr = 0;
    private int unreadBuffer = -1;
    private int line;
    private int col;
    private String publicId;
    private String systemId;
    private char[] strBuf = new char[64];
    private int strBufLen = 0;
    private char[] longStrBuf = new char[1024];
    private int longStrBufLen = 0;
    private char longStrBufPending = '\u0000';
    private AttributesImpl attributes;
    private final char[] bmpChar = new char[1];
    private final char[] astralChar = new char[2];
    private boolean alreadyWarnedAboutPrivateUseCharacters;
    private ContentModelFlag contentModelFlag = ContentModelFlag.PCDATA;
    private boolean escapeFlag = false;
    private String contentModelElement = "";
    private boolean endTag;
    private String tagName = null;
    private String attributeName = null;
    private boolean wantsComments = false;
    private boolean shouldAddAttributes;
    private boolean inContent;
    private boolean html4;
    private boolean nonAsciiProhibited;
    private boolean alreadyComplainedAboutNonAscii;
    private boolean metaBoundaryPassed;
    private String doctypeName;
    private String publicIdentifier;
    private String systemIdentifier;
    private XmlViolationPolicy contentSpacePolicy = XmlViolationPolicy.ALLOW;
    private XmlViolationPolicy contentNonXmlCharPolicy = XmlViolationPolicy.ALLOW;
    private XmlViolationPolicy commentPolicy = XmlViolationPolicy.ALLOW;
    private XmlViolationPolicy xmlnsPolicy = XmlViolationPolicy.ALLOW;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.ALLOW;
    private boolean swallowBom;
    private boolean html4ModeCompatibleWithXhtml1Schemata;
    private boolean mappingLangToXmlLang;
    private XmlViolationPolicy bogusXmlnsPolicy;

    public Tokenizer(TokenHandler tokenHandler) {
        this.tokenHandler = tokenHandler;
    }

    public void setCheckingNormalization(boolean enable) {
    }

    public boolean isCheckingNormalization() {
        return false;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public XmlViolationPolicy getCommentPolicy() {
        return this.commentPolicy;
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        this.commentPolicy = commentPolicy;
    }

    public XmlViolationPolicy getContentNonXmlCharPolicy() {
        return this.contentNonXmlCharPolicy;
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        this.contentNonXmlCharPolicy = contentNonXmlCharPolicy;
    }

    public XmlViolationPolicy getContentSpacePolicy() {
        return this.contentSpacePolicy;
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        this.contentSpacePolicy = contentSpacePolicy;
    }

    public void setXmlnsPolicy(XmlViolationPolicy xmlnsPolicy) {
        if (xmlnsPolicy == XmlViolationPolicy.FATAL) {
            throw new IllegalArgumentException("Can't use FATAL here.");
        }
        this.xmlnsPolicy = xmlnsPolicy;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
    }

    public void setBogusXmlnsPolicy(XmlViolationPolicy bogusXmlnsPolicy) {
        this.bogusXmlnsPolicy = bogusXmlnsPolicy;
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.html4ModeCompatibleWithXhtml1Schemata = html4ModeCompatibleWithXhtml1Schemata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenize(InputSource is) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputSource was null.");
        }
        this.swallowBom = true;
        this.systemId = is.getSystemId();
        this.publicId = is.getPublicId();
        this.reader = is.getCharacterStream();
        CharsetDecoder decoder = this.decoderFromExternalDeclaration(is.getEncoding());
        if (this.reader == null) {
            InputStream inputStream = is.getByteStream();
            if (inputStream == null) {
                throw new SAXException("Both streams in InputSource were null.");
            }
            this.reader = decoder == null ? new HtmlInputStreamReader(inputStream, this.errorHandler, this, this) : new HtmlInputStreamReader(inputStream, this.errorHandler, this, this, decoder);
        }
        this.contentModelFlag = ContentModelFlag.PCDATA;
        this.escapeFlag = false;
        this.inContent = true;
        this.pos = -1;
        this.cstart = -1;
        this.line = 1;
        this.col = 0;
        this.prev = '\u0000';
        this.bufLen = 0;
        this.nonAsciiProhibited = false;
        this.alreadyComplainedAboutNonAscii = false;
        this.html4 = false;
        this.alreadyWarnedAboutPrivateUseCharacters = false;
        this.metaBoundaryPassed = false;
        this.tokenHandler.start(this);
        this.wantsComments = this.tokenHandler.wantsComments();
        try {
            if (this.swallowBom) {
                char c = this.read();
                if (c == '\ufeff') {
                    this.col = 0;
                } else {
                    this.unread(c);
                }
            }
            this.dataState();
        }
        finally {
            this.systemIdentifier = null;
            this.publicIdentifier = null;
            this.doctypeName = null;
            this.tagName = null;
            this.attributeName = null;
            this.tokenHandler.eof();
            this.reader.close();
        }
    }

    public void setContentModelFlag(ContentModelFlag contentModelFlag, String contentModelElement) {
        this.contentModelFlag = contentModelFlag;
        this.contentModelElement = contentModelElement;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.col;
    }

    void notifyAboutMetaBoundary() {
        this.metaBoundaryPassed = true;
    }

    void turnOnAdditionalHtml4Errors() {
        this.html4 = true;
    }

    void dontSwallowBom() {
        this.swallowBom = false;
    }

    void noEncodingDeclared() {
        this.nonAsciiProhibited = true;
    }

    AttributesImpl newAttributes() {
        if (this.mappingLangToXmlLang) {
            return new XmlLangAttributesImpl();
        }
        return new AttributesImpl();
    }

    private void clearStrBuf() {
        this.strBufLen = 0;
    }

    private void appendStrBuf(char c) {
        if (this.strBufLen == this.strBuf.length) {
            char[] newBuf = new char[this.strBuf.length + 1024];
            System.arraycopy(this.strBuf, 0, newBuf, 0, this.strBuf.length);
            this.strBuf = newBuf;
        }
        this.strBuf[this.strBufLen++] = c;
    }

    private String strBufToString() {
        return new String(this.strBuf, 0, this.strBufLen);
    }

    private void emitStrBuf() throws SAXException {
        if (this.strBufLen > 0) {
            this.tokenHandler.characters(this.strBuf, 0, this.strBufLen);
        }
    }

    private boolean isNcname(String str) {
        Matcher m = NCNAME_PATTERN.matcher(str);
        return m.matches();
    }

    private void clearLongStrBuf() {
        this.longStrBufLen = 0;
        this.longStrBufPending = '\u0000';
    }

    private void appendLongStrBuf(char c) {
        if (this.longStrBufLen == this.longStrBuf.length) {
            char[] newBuf = new char[this.longStrBuf.length + 1024];
            System.arraycopy(this.longStrBuf, 0, newBuf, 0, this.longStrBuf.length);
            this.longStrBuf = newBuf;
        }
        this.longStrBuf[this.longStrBufLen++] = c;
    }

    private void appendToComment(char c) throws SAXException {
        if (this.longStrBufPending == '-' && c == '-') {
            if (this.commentPolicy == XmlViolationPolicy.FATAL) {
                this.fatal("This document is not mappable to XML 1.0 without data loss to \u201c--\u201d in a comment.");
            } else {
                this.warn("This document is not mappable to XML 1.0 without data loss to \u201c--\u201d in a comment.");
                if (this.wantsComments) {
                    if (this.commentPolicy == XmlViolationPolicy.ALLOW) {
                        this.appendLongStrBuf('-');
                    } else {
                        this.appendLongStrBuf('-');
                        this.appendLongStrBuf(' ');
                    }
                }
                this.longStrBufPending = (char)45;
            }
        } else {
            if (this.longStrBufPending != '\u0000') {
                if (this.wantsComments) {
                    this.appendLongStrBuf(this.longStrBufPending);
                }
                this.longStrBufPending = '\u0000';
            }
            if (c == '-') {
                this.longStrBufPending = (char)45;
            } else if (this.wantsComments) {
                this.appendLongStrBuf(c);
            }
        }
    }

    private void appendLongStrBuf(char[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            this.appendLongStrBuf(arr[i]);
        }
    }

    private void appendStrBufToLongStrBuf() {
        for (int i = 0; i < this.strBufLen; ++i) {
            this.appendLongStrBuf(this.strBuf[i]);
        }
    }

    private String longStrBufToString() {
        if (this.longStrBufPending != '\u0000') {
            this.appendLongStrBuf(this.longStrBufPending);
        }
        return new String(this.longStrBuf, 0, this.longStrBufLen);
    }

    private void emitComment() throws SAXException {
        if (this.wantsComments && this.longStrBufPending != '\u0000') {
            this.appendLongStrBuf(this.longStrBufPending);
        }
        this.tokenHandler.comment(this.longStrBuf, this.longStrBufLen);
    }

    private void unread(char c) {
        this.unreadBuffer = c;
    }

    private char read() throws SAXException, IOException {
        int c;
        block6: while (true) {
            if (this.unreadBuffer != -1) {
                c = this.unreadBuffer;
                this.unreadBuffer = -1;
                return (char)c;
            }
            assert (this.bufLen > -1);
            ++this.pos;
            assert (this.pos <= this.bufLen);
            ++this.col;
            if (this.pos == this.bufLen) {
                boolean charDataContinuation = false;
                if (this.cstart > -1) {
                    this.flushChars();
                    charDataContinuation = true;
                }
                this.bufLen = this.reader.read(this.buf);
                assert (this.bufLen <= this.buf.length);
                if (this.bufLen == -1) {
                    return '\u0000';
                }
                if (charDataContinuation) {
                    this.cstart = 0;
                }
                this.pos = 0;
            }
            if ((c = this.buf[this.pos]) > 127 && this.nonAsciiProhibited && !this.alreadyComplainedAboutNonAscii) {
                this.err("The character encoding of the document was not explicit but the document contains non-ASCII.");
            }
            switch (c) {
                case 10: {
                    if (this.prev == '\r') {
                        this.col = 0;
                        if (this.cstart != -1) {
                            this.flushChars();
                            this.cstart = this.pos + 1;
                        }
                        this.prev = c;
                        continue block6;
                    }
                    ++this.line;
                    this.col = 0;
                    break block6;
                }
                case 13: {
                    this.buf[this.pos] = 10;
                    c = 10;
                    ++this.line;
                    this.col = 0;
                    this.prev = (char)13;
                    if (this.contentModelFlag != ContentModelFlag.PCDATA) {
                        ++this.prevFourPtr;
                        this.prevFourPtr %= 4;
                        this.prevFour[this.prevFourPtr] = c;
                    }
                    return (char)c;
                }
                case 0: {
                    this.err("Found U+0000 in the character stream.");
                    this.buf[this.pos] = 65533;
                    c = 65533;
                    break block6;
                }
                case 11: 
                case 12: {
                    if (!this.inContent) break block6;
                    if (this.contentNonXmlCharPolicy == XmlViolationPolicy.FATAL) {
                        this.fatal("This document is not mappable to XML 1.0 without data loss due to a character that is not a legal XML 1.0 character.");
                        break block6;
                    }
                    if (this.contentNonXmlCharPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                        this.buf[this.pos] = 32;
                        c = 32;
                    }
                    this.warn("This document is not mappable to XML 1.0 without data loss due to a character that is not a legal XML 1.0 character.");
                    break block6;
                }
                default: {
                    if ((c & 0xFC00) == 56320) {
                        if ((this.prev & 0xFC00) == 55296) {
                            int intVal = (this.prev << 10) + c + -56613888;
                            if (this.isNonCharacter(intVal)) {
                                this.warn("Astral non-character.");
                            }
                            if (!this.isAstralPrivateUse(intVal)) break block6;
                            this.warnAboutPrivateUseChar();
                            break block6;
                        }
                        this.err("Found low surrogate without high surrogate.");
                        this.buf[this.pos] = 65533;
                        c = 65533;
                        break block6;
                    }
                    if (this.inContent && (c < 32 || this.isNonCharacter(c)) && c != 9) {
                        if (this.contentNonXmlCharPolicy == XmlViolationPolicy.FATAL) {
                            this.fatal("This document is not mappable to XML 1.0 without data loss due to a character that is not a legal XML 1.0 character.");
                            break block6;
                        }
                        if (this.contentNonXmlCharPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                            this.buf[this.pos] = 65533;
                            c = 65533;
                        }
                        this.warn("This document is not mappable to XML 1.0 without data loss due to a character that is not a legal XML 1.0 character.");
                        break block6;
                    }
                    if (!this.isPrivateUse((char)c)) break block6;
                    this.warnAboutPrivateUseChar();
                }
            }
            break;
        }
        this.prev = c;
        if (this.contentModelFlag != ContentModelFlag.PCDATA) {
            ++this.prevFourPtr;
            this.prevFourPtr %= 4;
            this.prevFour[this.prevFourPtr] = c;
        }
        return (char)c;
    }

    private void warnAboutPrivateUseChar() throws SAXException {
        if (!this.alreadyWarnedAboutPrivateUseCharacters) {
            this.warn("Document uses the Unicode Private Use Area(s), which should not be used in publicly exchanged documents. (Charmod C073)");
            this.alreadyWarnedAboutPrivateUseCharacters = true;
        }
    }

    private boolean isPrivateUse(char c) {
        return c >= '\ue000' && c <= '\uf8ff';
    }

    private boolean isAstralPrivateUse(int c) {
        return c >= 983040 && c <= 1048573 || c >= 0x100000 && c <= 1114109;
    }

    private boolean isNonCharacter(int c) {
        return (c & 0xFFFE) == 65534;
    }

    private void flushChars() throws SAXException, IOException {
        if (this.cstart != -1 && this.pos > this.cstart) {
            this.tokenHandler.characters(this.buf, this.cstart, this.pos - this.cstart);
        }
        this.cstart = -1;
    }

    private void fatal(String message) throws SAXException {
        SAXParseException spe = new SAXParseException(message, this);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    private void err(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        this.errorHandler.error(spe);
    }

    private void warn(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this);
        this.errorHandler.warning(spe);
    }

    private CharsetDecoder decoderFromExternalDeclaration(String encoding) throws SAXException {
        if (encoding == null) {
            return null;
        }
        if ("ISO-8859-1".equals(encoding = encoding.toUpperCase())) {
            encoding = "Windows-1252";
        }
        if ("UTF-16".equals(encoding) || "UTF-32".equals(encoding)) {
            this.swallowBom = false;
        }
        try {
            Charset cs = Charset.forName(encoding);
            String canonName = cs.name();
            if (canonName.startsWith("X-") || canonName.startsWith("x-") || canonName.startsWith("Mac")) {
                if (encoding.startsWith("X-")) {
                    this.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding. (Charmod C022)");
                } else {
                    this.err("The encoding \u201c" + encoding + "\u201d is not an IANA-registered encoding and did\u2019t start with \u201cX-\u201d. (Charmod C023)");
                }
            } else if (!canonName.equalsIgnoreCase(encoding)) {
                this.err("The encoding \u201c" + encoding + "\u201d is not the preferred name of the character encoding in use. The preferred name is \u201c" + canonName + "\u201d. (Charmod C024)");
            }
            if (EncodingInfo.isObscure(canonName)) {
                this.warn("The character encoding \u201c" + encoding + "\u201d is not widely supported. Better interoperability may be achieved by using \u201cUTF-8\u201d.");
            }
            return cs.newDecoder();
        }
        catch (IllegalCharsetNameException e) {
            this.err("Illegal character encoding name: \u201c" + encoding + "\u201d. Will sniff.");
        }
        catch (UnsupportedCharsetException e) {
            this.err("Unsupported character encoding name: \u201c" + encoding + "\u201d. Will sniff.");
            this.swallowBom = true;
        }
        return null;
    }

    private boolean currentIsVoid() {
        return Arrays.binarySearch(VOID_ELEMENTS, this.tagName) > -1;
    }

    private void dataState() throws SAXException, IOException {
        char c = '\u0000';
        while (true) {
            if ((c = this.read()) == '&' && (this.contentModelFlag == ContentModelFlag.PCDATA || this.contentModelFlag == ContentModelFlag.RCDATA && !this.escapeFlag)) {
                this.flushChars();
                this.entityDataState();
                continue;
            }
            if (!(c != '<' || this.contentModelFlag != ContentModelFlag.PCDATA && (this.escapeFlag || this.contentModelFlag != ContentModelFlag.CDATA && this.contentModelFlag != ContentModelFlag.RCDATA))) {
                this.flushChars();
                this.resetAttributes();
                this.inContent = false;
                this.tagOpenState();
                this.inContent = true;
                continue;
            }
            if (c == '\u0000') {
                this.flushChars();
                return;
            }
            if (c == '-' && !this.escapeFlag && (this.contentModelFlag == ContentModelFlag.RCDATA || this.contentModelFlag == ContentModelFlag.CDATA) && this.lastLtExclHyph()) {
                this.escapeFlag = true;
            } else if (c == '>' && this.escapeFlag && this.lastHyphHyph()) {
                this.escapeFlag = false;
            }
            if (this.cstart != -1) continue;
            this.cstart = this.pos;
        }
    }

    private boolean lastHyphHyph() {
        return this.prevFour[(this.prevFourPtr - 1 + 4) % 4] == '-' && this.prevFour[(this.prevFourPtr - 2 + 4) % 4] == '-';
    }

    private boolean lastLtExclHyph() {
        return this.prevFour[(this.prevFourPtr - 1 + 4) % 4] == '-' && this.prevFour[(this.prevFourPtr - 2 + 4) % 4] == '!' && this.prevFour[(this.prevFourPtr - 3 + 4) % 4] == '<';
    }

    private void entityDataState() throws SAXException, IOException {
        this.consumeEntity(false);
    }

    private void tagOpenState() throws SAXException, IOException {
        if (this.contentModelFlag != ContentModelFlag.PCDATA) {
            char c = this.read();
            if (c == '/') {
                this.closeTagOpenState();
                return;
            }
            this.tokenHandler.characters(LT_GT, 0, 1);
            this.unread(c);
            return;
        }
        char c = this.read();
        if (c == '!') {
            this.markupDeclarationOpenState();
            return;
        }
        if (c == '/') {
            this.closeTagOpenState();
            return;
        }
        if (c >= 'A' && c <= 'Z') {
            this.endTag = false;
            this.clearStrBuf();
            this.appendStrBuf((char)(c + 32));
            this.tagNameState();
            return;
        }
        if (c >= 'a' && c <= 'z') {
            this.endTag = false;
            this.clearStrBuf();
            this.appendStrBuf(c);
            this.tagNameState();
            return;
        }
        if (c == '>') {
            this.err("Bad character \u201c>\u201d in the tag open state.");
            this.tokenHandler.characters(LT_GT, 0, 2);
            return;
        }
        if (c == '?') {
            this.err("Bad character \u201c?\u201d in the tag open state.");
            this.clearLongStrBuf();
            this.appendLongStrBuf(c);
            this.bogusCommentState();
            return;
        }
        this.err("Bad character \u201c" + c + "\u201d in the tag open state.");
        this.tokenHandler.characters(LT_GT, 0, 1);
        this.unread(c);
    }

    private void closeTagOpenState() throws SAXException, IOException {
        if (this.contentModelFlag != ContentModelFlag.PCDATA && this.contentModelElement != null) {
            this.clearStrBuf();
            for (int i = 0; i < this.contentModelElement.length(); ++i) {
                char c;
                char e = this.contentModelElement.charAt(i);
                char folded = c = this.read();
                if (c >= 'A' && c <= 'Z') {
                    folded = (char)(folded + 32);
                }
                if (folded != e) {
                    if (i > 0 || folded >= 'a' && folded <= 'z') {
                        if (this.html4) {
                            this.err((this.contentModelFlag == ContentModelFlag.CDATA ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement + "\u201d contained the string \u201c</\u201d, but it was not the start of the end tag. (HTML4-only error)");
                        } else {
                            this.warn((this.contentModelFlag == ContentModelFlag.CDATA ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement + "\u201d contained the string \u201c</\u201d, but this did not close the element.");
                        }
                    }
                    this.tokenHandler.characters(LT_SOLIDUS, 0, 2);
                    this.emitStrBuf();
                    this.unread(c);
                    return;
                }
                this.appendStrBuf(c);
            }
            this.endTag = true;
            this.tagName = this.contentModelElement;
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    this.beforeAttributeNameState();
                    return;
                }
                case '>': {
                    this.emitCurrentTagToken();
                    return;
                }
                case '\u0000': {
                    this.err("Expected \u201c>\u201d but saw end of file instead.");
                    this.emitCurrentTagToken();
                    this.unread(c);
                    return;
                }
                case '/': {
                    this.err("Stray \u201c/\u201d in end tag.");
                    this.beforeAttributeNameState();
                    return;
                }
            }
            if (this.html4) {
                this.err((this.contentModelFlag == ContentModelFlag.CDATA ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement + "\u201d contained the string \u201c</\u201d, but it was not the start of the end tag. (HTML4-only error)");
            } else {
                this.warn((this.contentModelFlag == ContentModelFlag.CDATA ? "CDATA" : "RCDATA") + " element \u201c" + this.contentModelElement + "\u201d contained the string \u201c</\u201d, but this did not close the element.");
            }
            this.tokenHandler.characters(LT_SOLIDUS, 0, 2);
            this.emitStrBuf();
            this.cstart = this.pos;
            return;
        }
        char c = this.read();
        if (c >= 'A' && c <= 'Z') {
            this.endTag = true;
            this.clearStrBuf();
            this.appendStrBuf((char)(c + 32));
            this.tagNameState();
            return;
        }
        if (c >= 'a' && c <= 'z') {
            this.endTag = true;
            this.clearStrBuf();
            this.appendStrBuf(c);
            this.tagNameState();
            return;
        }
        if (c == '>') {
            this.err("Saw \u201c</>\u201d.");
            return;
        }
        if (c == '\u0000') {
            this.err("Saw \u201c</\u201d immediately before end of file.");
            this.tokenHandler.characters(LT_SOLIDUS, 0, 2);
            this.unread(c);
            return;
        }
        this.err("Garbage after \u201c</\u201d.");
        this.clearLongStrBuf();
        this.appendToComment(c);
        this.bogusCommentState();
    }

    private void tagNameState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    this.tagName = this.strBufToElementNameString();
                    this.beforeAttributeNameState();
                    return;
                }
                case '>': {
                    this.tagName = this.strBufToElementNameString();
                    this.emitCurrentTagToken();
                    return;
                }
                case '\u0000': {
                    this.err("End of file seen when looking for tag name");
                    this.tagName = this.strBufToElementNameString();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    return;
                }
                case '/': {
                    this.tagName = this.strBufToElementNameString();
                    this.parseErrorUnlessPermittedSlash();
                    this.beforeAttributeNameState();
                    return;
                }
            }
            if (c >= 'A' && c <= 'Z') {
                this.appendStrBuf((char)(c + 32));
                continue;
            }
            this.appendStrBuf(c);
        }
    }

    private String strBufToElementNameString() {
        return this.strBufToString().intern();
    }

    private void beforeAttributeNameState() throws SAXException, IOException {
        while (this.beforeAttributeNameStateImpl()) {
        }
    }

    private void resetAttributes() {
        this.attributes = null;
    }

    private boolean beforeAttributeNameStateImpl() throws SAXException, IOException {
        char c;
        block6: while (true) {
            c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block6;
                }
                case '>': {
                    this.emitCurrentTagToken();
                    return false;
                }
                case '/': {
                    this.parseErrorUnlessPermittedSlash();
                    continue block6;
                }
                case '\u0000': {
                    this.err("Saw end of file without the previous tag ending with \u201c>\u201c.");
                    this.emitCurrentTagToken();
                    this.unread(c);
                    return false;
                }
            }
            break;
        }
        this.clearStrBuf();
        if (c >= 'A' && c <= 'Z') {
            this.appendStrBuf((char)(c + 32));
        } else {
            this.appendStrBuf(c);
        }
        return this.attributeNameState();
    }

    private void parseErrorUnlessPermittedSlash() throws SAXException, IOException {
        if (this.endTag) {
            this.err("Stray \u201c/\u201d in an end tag.");
            return;
        }
        char c = this.read();
        if (c == '>') {
            if (!this.currentIsVoid() && !this.html4) {
                if (this.html4) {
                    this.err("Stray \u201c/\u201d in tag. The \u201c/>\u201d syntax is not permitted in HTML4.");
                } else {
                    this.err("Stray \u201c/\u201d in tag. The \u201c/>\u201d syntax is only permitted on void elements.");
                }
            } else if (this.html4) {
                this.err("Stray \u201c/\u201d in tag. The \u201c/>\u201d syntax is not permitted in HTML4. (HTML4-only error)");
            }
        } else {
            this.err("Stray \u201c/\u201d in tag.");
        }
        this.unread(c);
    }

    private void emitCurrentTagToken() throws SAXException {
        Attributes attrs;
        if (this.namePolicy != XmlViolationPolicy.ALLOW && !this.isNcname(this.tagName)) {
            if (this.namePolicy == XmlViolationPolicy.FATAL) {
                this.fatal((this.endTag ? "End" : "Start") + " tag \u201c" + this.tagName + "\u201d has a non-NCName name.");
            } else {
                this.warn((this.endTag ? "End" : "Start") + " tag \u201c" + this.tagName + "\u201d has a non-NCName name. Ignoring token.");
                return;
            }
        }
        Attributes attributes = attrs = this.attributes == null ? EmptyAttributes.EMPTY_ATTRIBUTES : this.attributes;
        if (this.endTag) {
            this.escapeFlag = false;
            this.contentModelFlag = ContentModelFlag.PCDATA;
            if (attrs.getLength() != 0) {
                this.err("End tag had attributes.");
            }
            this.tokenHandler.endTag(this.tagName, attrs);
        } else {
            this.tokenHandler.startTag(this.tagName, attrs);
        }
    }

    private boolean attributeNameState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    this.attributeNameComplete();
                    return this.afterAttributeNameState();
                }
                case '=': {
                    this.attributeNameComplete();
                    return this.beforeAttributeValueState();
                }
                case '>': {
                    this.attributeNameComplete();
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken();
                    return false;
                }
                case '/': {
                    this.parseErrorUnlessPermittedSlash();
                    this.attributeNameComplete();
                    this.addAttributeWithoutValue();
                    return true;
                }
                case '\u0000': {
                    this.err("End of file occurred in an attribute name.");
                    this.attributeNameComplete();
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    return false;
                }
            }
            if (c >= 'A' && c <= 'Z') {
                this.appendStrBuf((char)(c + 32));
                continue;
            }
            this.appendStrBuf(c);
        }
    }

    private void attributeNameComplete() throws SAXException {
        this.attributeName = this.strBufToString();
        if (this.attributes == null) {
            this.attributes = this.newAttributes();
        }
        if (this.attributes.getIndex(this.attributeName) == -1) {
            if (this.namePolicy == XmlViolationPolicy.ALLOW) {
                this.shouldAddAttributes = true;
            } else if (this.isNcname(this.attributeName)) {
                this.shouldAddAttributes = true;
            } else if (this.namePolicy == XmlViolationPolicy.FATAL) {
                this.fatal("Attribute name \u201c" + this.attributeName + "\u201d is not an NCName.");
            } else {
                this.shouldAddAttributes = false;
                this.warn("Attribute name \u201c" + this.attributeName + "\u201d is not an NCName. Ignoring the attribute.");
            }
        } else {
            this.shouldAddAttributes = false;
            this.err("Duplicate attribute \u201c" + this.attributeName + "\u201d.");
        }
    }

    private void addAttributeWithoutValue() throws SAXException {
        if (this.metaBoundaryPassed && "charset".equals(this.attributeName) && "meta".equals(this.tagName)) {
            this.err("A \u201ccharset\u201d attribute on a \u201cmeta\u201d element found after the first 512 bytes.");
        }
        if (this.shouldAddAttributes) {
            if (this.html4) {
                if (AttributeInfo.isBoolean(this.attributeName)) {
                    if (this.html4ModeCompatibleWithXhtml1Schemata) {
                        this.attributes.addAttribute(this.attributeName, this.attributeName);
                    } else {
                        this.attributes.addAttribute(this.attributeName, "");
                    }
                } else {
                    this.err("Attribute value omitted for a non-boolean attribute. (HTML4-only error.)");
                    this.attributes.addAttribute(this.attributeName, "");
                }
            } else {
                if ("src".equals(this.attributeName) || "href".equals(this.attributeName)) {
                    this.warn("Attribute \u201c" + this.attributeName + "\u201d without an explicit value seen. The attribute may be dropped by IE7.");
                }
                this.attributes.addAttribute(this.attributeName, "");
            }
        }
    }

    private void addAttributeWithValue() throws SAXException {
        if (this.metaBoundaryPassed && "meta" == this.tagName && "charset".equals(this.attributeName)) {
            this.err("A \u201ccharset\u201d attribute on a \u201cmeta\u201d element found after the first 512 bytes.");
        }
        if (this.shouldAddAttributes) {
            String value = this.longStrBufToString();
            if (!this.endTag) {
                if ("xmlns".equals(this.attributeName)) {
                    if ("html" == this.tagName && "http://www.w3.org/1999/xhtml".equals(value)) {
                        if (this.xmlnsPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                            return;
                        }
                    } else if (this.bogusXmlnsPolicy == XmlViolationPolicy.FATAL) {
                        this.fatal("Forbidden attribute \u201c" + this.attributeName + "\u201d is not mappable to namespace-aware XML 1.0.");
                    } else {
                        this.warn("Forbidden attribute \u201c" + this.attributeName + "\u201d is not mappable to namespace-aware XML 1.0.");
                        if (this.bogusXmlnsPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                            return;
                        }
                    }
                } else if (this.attributeName.startsWith("xmlns:")) {
                    if (this.bogusXmlnsPolicy == XmlViolationPolicy.FATAL) {
                        this.fatal("Forbidden attribute \u201c" + this.attributeName + "\u201d is not mappable to namespace-aware XML 1.0.");
                    } else {
                        this.warn("Forbidden attribute \u201c" + this.attributeName + "\u201d is not mappable to namespace-aware XML 1.0.");
                        if (this.bogusXmlnsPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                            return;
                        }
                    }
                }
            }
            this.attributes.addAttribute(this.attributeName, value);
        }
    }

    private boolean afterAttributeNameState() throws SAXException, IOException {
        char c;
        block7: while (true) {
            c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block7;
                }
                case '=': {
                    return this.beforeAttributeValueState();
                }
                case '>': {
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken();
                    return false;
                }
                case '/': {
                    this.addAttributeWithoutValue();
                    this.parseErrorUnlessPermittedSlash();
                    return true;
                }
                case '\u0000': {
                    this.err("Saw end of file without the previous tag ending with \u201c>\u201c.");
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    return false;
                }
            }
            break;
        }
        this.addAttributeWithoutValue();
        this.unread(c);
        return true;
    }

    private boolean beforeAttributeValueState() throws SAXException, IOException {
        char c;
        this.clearLongStrBuf();
        block8: while (true) {
            c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block8;
                }
                case '\"': {
                    return this.attributeValueDoubleQuotedState();
                }
                case '&': {
                    this.unread(c);
                    return this.attributeValueUnquotedState();
                }
                case '\'': {
                    return this.attributeValueSingleQuotedState();
                }
                case '>': {
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken();
                    return false;
                }
                case '\u0000': {
                    this.err("Saw end of file without the previous tag ending with \u201c>\u201c.");
                    this.addAttributeWithoutValue();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    return false;
                }
            }
            break;
        }
        if (!(!this.html4 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ':')) {
            this.err("Non-name character in an unquoted attribute value. (This is an HTML4-only error.)");
        }
        this.appendLongStrBuf(c);
        return this.attributeValueUnquotedState();
    }

    private boolean attributeValueDoubleQuotedState() throws SAXException, IOException {
        this.inContent = true;
        block5: while (true) {
            char c = this.read();
            switch (c) {
                case '\"': {
                    this.addAttributeWithValue();
                    this.inContent = false;
                    return true;
                }
                case '&': {
                    this.entityInAttributeValueState();
                    continue block5;
                }
                case '\u0000': {
                    this.err("End of file reached when inside a quoted attribute value.");
                    this.addAttributeWithValue();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    this.inContent = false;
                    return false;
                }
            }
            this.appendLongStrBuf(c);
        }
    }

    private boolean attributeValueSingleQuotedState() throws SAXException, IOException {
        this.inContent = true;
        block5: while (true) {
            char c = this.read();
            switch (c) {
                case '\'': {
                    this.addAttributeWithValue();
                    this.inContent = false;
                    return true;
                }
                case '&': {
                    this.entityInAttributeValueState();
                    continue block5;
                }
                case '\u0000': {
                    this.err("End of file reached when inside a quoted attribute value.");
                    this.addAttributeWithValue();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    this.inContent = false;
                    return false;
                }
            }
            this.appendLongStrBuf(c);
        }
    }

    private boolean attributeValueUnquotedState() throws SAXException, IOException {
        this.inContent = true;
        block7: while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    this.addAttributeWithValue();
                    this.inContent = false;
                    return true;
                }
                case '&': {
                    this.entityInAttributeValueState();
                    continue block7;
                }
                case '>': {
                    this.addAttributeWithValue();
                    this.emitCurrentTagToken();
                    this.inContent = false;
                    return false;
                }
                case '\u0000': {
                    this.err("Saw end of file without the previous tag ending with \u201c>\u201c.");
                    this.addAttributeWithValue();
                    this.emitCurrentTagToken();
                    this.unread(c);
                    this.inContent = false;
                    return false;
                }
                case '<': {
                    this.warn("\u201c<\u201d in an unquoted attribute value. This does not end the tag.");
                }
            }
            if (!(!this.html4 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == ':')) {
                this.err("Non-name character in an unquoted attribute value. (This is an HTML4-only error.)");
            }
            this.appendLongStrBuf(c);
        }
    }

    private void entityInAttributeValueState() throws SAXException, IOException {
        this.consumeEntity(true);
    }

    private void bogusCommentState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '>': {
                    this.emitComment();
                    return;
                }
                case '\u0000': {
                    this.emitComment();
                    this.unread(c);
                    return;
                }
            }
            this.appendToComment(c);
        }
    }

    private void markupDeclarationOpenState() throws SAXException, IOException {
        this.clearLongStrBuf();
        char c = this.read();
        switch (c) {
            case '-': {
                c = this.read();
                if (c == '-') {
                    this.commentStates();
                    return;
                }
                this.err("Bogus comment.");
                this.appendToComment('-');
                this.unread(c);
                this.bogusCommentState();
                return;
            }
            case 'D': 
            case 'd': {
                this.appendToComment(c);
                for (int i = 0; i < OCTYPE.length; ++i) {
                    char folded = c = this.read();
                    if (c >= 'A' && c <= 'Z') {
                        folded = (char)(folded + 32);
                    }
                    if (folded != OCTYPE[i]) {
                        this.err("Bogus comment.");
                        this.unread(c);
                        this.bogusCommentState();
                        return;
                    }
                    this.appendToComment(c);
                }
                this.doctypeState();
                return;
            }
        }
        this.err("Bogus comment.");
        this.unread(c);
        this.bogusCommentState();
    }

    private void commentStates() throws SAXException, IOException {
        CommentState state = CommentState.COMMENT_START_STATE;
        block30: while (true) {
            char c = this.read();
            switch (state) {
                case COMMENT_START_STATE: {
                    switch (c) {
                        case '-': {
                            state = CommentState.COMMENT_START_DASH_STATE;
                            continue block30;
                        }
                        case '>': {
                            this.err("Premature end of comment.");
                            this.emitComment();
                            return;
                        }
                        case '\u0000': {
                            this.err("End of file inside comment.");
                            this.emitComment();
                            this.unread(c);
                            return;
                        }
                    }
                    this.appendToComment(c);
                    state = CommentState.COMMENT_STATE;
                    continue block30;
                }
                case COMMENT_START_DASH_STATE: {
                    switch (c) {
                        case '-': {
                            state = CommentState.COMMENT_END_STATE;
                            continue block30;
                        }
                        case '>': {
                            this.err("Premature end of comment.");
                            this.emitComment();
                            return;
                        }
                        case '\u0000': {
                            this.err("End of file inside comment.");
                            this.emitComment();
                            this.unread(c);
                            return;
                        }
                    }
                    this.appendToComment('-');
                    this.appendToComment(c);
                    state = CommentState.COMMENT_STATE;
                    continue block30;
                }
                case COMMENT_STATE: {
                    switch (c) {
                        case '-': {
                            state = CommentState.COMMENT_END_DASH_STATE;
                            continue block30;
                        }
                        case '\u0000': {
                            this.err("End of file inside comment.");
                            this.emitComment();
                            this.unread(c);
                            return;
                        }
                    }
                    this.appendToComment(c);
                    continue block30;
                }
                case COMMENT_END_DASH_STATE: {
                    switch (c) {
                        case '-': {
                            state = CommentState.COMMENT_END_STATE;
                            continue block30;
                        }
                        case '\u0000': {
                            this.err("End of file inside comment.");
                            this.emitComment();
                            this.unread(c);
                            return;
                        }
                    }
                    this.appendToComment('-');
                    this.appendToComment(c);
                    state = CommentState.COMMENT_STATE;
                    continue block30;
                }
                case COMMENT_END_STATE: {
                    switch (c) {
                        case '>': {
                            this.emitComment();
                            return;
                        }
                        case '-': {
                            this.err("Consecutive hyphens did not terminate a comment.");
                            this.appendToComment('-');
                            continue block30;
                        }
                        case '\u0000': {
                            this.err("End of file inside comment.");
                            this.emitComment();
                            this.unread(c);
                            return;
                        }
                    }
                    this.err("Consecutive hyphens did not terminate a comment.");
                    this.appendToComment('-');
                    this.appendToComment('-');
                    this.appendToComment(c);
                    state = CommentState.COMMENT_STATE;
                    continue block30;
                }
            }
        }
    }

    private void doctypeState() throws SAXException, IOException {
        this.systemIdentifier = null;
        this.publicIdentifier = null;
        this.doctypeName = null;
        char c = this.read();
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case ' ': {
                this.beforeDoctypeNameState();
                return;
            }
        }
        this.err("Missing space before doctype name.");
        this.unread(c);
        this.beforeDoctypeNameState();
    }

    private void beforeDoctypeNameState() throws SAXException, IOException {
        char c;
        block5: while (true) {
            c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block5;
                }
                case '>': {
                    this.err("Nameless doctype.");
                    this.tokenHandler.doctype("", null, null, false);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside doctype.");
                    this.tokenHandler.doctype("", null, null, false);
                    this.unread(c);
                    return;
                }
            }
            break;
        }
        this.clearStrBuf();
        this.appendStrBuf(c);
        this.doctypeNameState();
    }

    private void doctypeNameState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    this.doctypeName = this.strBufToString();
                    this.afterDoctypeNameState();
                    return;
                }
                case '>': {
                    this.tokenHandler.doctype(this.strBufToString(), null, null, true);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside doctype.");
                    this.tokenHandler.doctype(this.strBufToString(), null, null, false);
                    this.unread(c);
                    return;
                }
            }
            this.appendStrBuf(c);
        }
    }

    private void afterDoctypeNameState() throws SAXException, IOException {
        block7: while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block7;
                }
                case '>': {
                    this.tokenHandler.doctype(this.doctypeName, null, null, true);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside doctype.");
                    this.tokenHandler.doctype(this.doctypeName, null, null, false);
                    this.unread(c);
                    return;
                }
                case 'P': 
                case 'p': {
                    for (int i = 0; i < UBLIC.length; ++i) {
                        char folded = c = this.read();
                        if (c >= 'A' && c <= 'Z') {
                            folded = (char)(folded + 32);
                        }
                        if (folded == UBLIC[i]) continue;
                        this.err("Bogus doctype.");
                        this.unread(c);
                        this.bogusDoctypeState();
                        return;
                    }
                    this.beforeDoctypePublicIdentifierState();
                    return;
                }
                case 'S': 
                case 's': {
                    for (int i = 0; i < YSTEM.length; ++i) {
                        char folded = c = this.read();
                        if (c >= 'A' && c <= 'Z') {
                            folded = (char)(folded + 32);
                        }
                        if (folded == YSTEM[i]) continue;
                        this.err("Bogus doctype.");
                        this.unread(c);
                        this.bogusDoctypeState();
                        return;
                    }
                    this.beforeDoctypeSystemIdentifierState();
                    return;
                }
            }
            break;
        }
        this.err("Bogus doctype.");
        this.bogusDoctypeState();
    }

    private void beforeDoctypePublicIdentifierState() throws SAXException, IOException {
        block7: while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block7;
                }
                case '\"': {
                    this.clearLongStrBuf();
                    this.doctypePublicIdentifierDoubleQuotedState();
                    return;
                }
                case '\'': {
                    this.clearLongStrBuf();
                    this.doctypePublicIdentifierSingleQuotedState();
                    return;
                }
                case '>': {
                    this.err("Expected a public identifier but the doctype ended.");
                    this.tokenHandler.doctype(this.doctypeName, null, null, false);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside a doctype.");
                    this.tokenHandler.doctype(this.doctypeName, null, null, false);
                    this.unread(c);
                    return;
                }
            }
            break;
        }
        this.err("Bogus doctype.");
        this.bogusDoctypeState();
    }

    private void doctypePublicIdentifierDoubleQuotedState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\"': {
                    this.publicIdentifier = this.longStrBufToString();
                    this.afterDoctypePublicIdentifierState();
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside public identifier.");
                    this.tokenHandler.doctype(this.doctypeName, this.longStrBufToString(), null, false);
                    this.unread(c);
                    return;
                }
            }
            this.appendLongStrBuf(c);
        }
    }

    private void doctypePublicIdentifierSingleQuotedState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\'': {
                    this.publicIdentifier = this.longStrBufToString();
                    this.afterDoctypePublicIdentifierState();
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside public identifier.");
                    this.tokenHandler.doctype(this.doctypeName, this.longStrBufToString(), null, false);
                    this.unread(c);
                    return;
                }
            }
            this.appendLongStrBuf(c);
        }
    }

    private void afterDoctypePublicIdentifierState() throws SAXException, IOException {
        block7: while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block7;
                }
                case '\"': {
                    this.clearLongStrBuf();
                    this.doctypeSystemIdentifierDoubleQuotedState();
                    return;
                }
                case '\'': {
                    this.clearLongStrBuf();
                    this.doctypeSystemIdentifierSingleQuotedState();
                    return;
                }
                case '>': {
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, null, true);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside doctype.");
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, null, false);
                    this.unread(c);
                    return;
                }
            }
            break;
        }
        this.err("Bogus doctype.");
        this.bogusDoctypeState();
    }

    private void beforeDoctypeSystemIdentifierState() throws SAXException, IOException {
        block7: while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block7;
                }
                case '\"': {
                    this.clearLongStrBuf();
                    this.doctypeSystemIdentifierDoubleQuotedState();
                    return;
                }
                case '\'': {
                    this.clearLongStrBuf();
                    this.doctypeSystemIdentifierSingleQuotedState();
                    return;
                }
                case '>': {
                    this.err("Expected a system identifier but the doctype ended.");
                    this.tokenHandler.doctype(this.doctypeName, null, null, false);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside a doctype.");
                    this.tokenHandler.doctype(this.doctypeName, null, null, false);
                    this.unread(c);
                    return;
                }
            }
            break;
        }
        this.err("Bogus doctype.");
        this.bogusDoctypeState();
    }

    private void doctypeSystemIdentifierDoubleQuotedState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\"': {
                    this.systemIdentifier = this.longStrBufToString();
                    this.afterDoctypeSystemIdentifierState();
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside system identifier.");
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.longStrBufToString(), false);
                    this.unread(c);
                    return;
                }
            }
            this.appendLongStrBuf(c);
        }
    }

    private void doctypeSystemIdentifierSingleQuotedState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '\'': {
                    this.systemIdentifier = this.longStrBufToString();
                    this.afterDoctypeSystemIdentifierState();
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside system identifier.");
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.longStrBufToString(), false);
                    this.unread(c);
                    return;
                }
            }
            this.appendLongStrBuf(c);
        }
    }

    private void afterDoctypeSystemIdentifierState() throws SAXException, IOException {
        block5: while (true) {
            char c = this.read();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case ' ': {
                    continue block5;
                }
                case '>': {
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.systemIdentifier, true);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside doctype.");
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.systemIdentifier, false);
                    this.unread(c);
                    return;
                }
            }
            break;
        }
        this.err("Bogus doctype.");
        this.bogusDoctypeState();
    }

    private void bogusDoctypeState() throws SAXException, IOException {
        while (true) {
            char c = this.read();
            switch (c) {
                case '>': {
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.systemIdentifier, false);
                    return;
                }
                case '\u0000': {
                    this.err("End of file inside doctype.");
                    this.tokenHandler.doctype(this.doctypeName, this.publicIdentifier, this.systemIdentifier, false);
                    this.unread(c);
                    return;
                }
            }
        }
    }

    private void consumeEntity(boolean inAttribute) throws SAXException, IOException {
        this.clearStrBuf();
        this.appendStrBuf('&');
        char c = this.read();
        switch (c) {
            case '\u0000': 
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case ' ': 
            case '&': 
            case '<': {
                if (inAttribute) {
                    this.appendStrBufToLongStrBuf();
                } else {
                    this.emitStrBuf();
                }
                this.unread(c);
                return;
            }
            case '#': {
                this.appendStrBuf('#');
                this.consumeNCR(inAttribute);
                return;
            }
        }
        this.unread(c);
        int entCol = -1;
        int lo = 0;
        int hi = Entities.NAMES.length - 1;
        int candidate = -1;
        int strBufMark = 0;
        block4: while (true) {
            ++entCol;
            c = this.read();
            while (hi != -1 && entCol != Entities.NAMES[hi].length()) {
                if (entCol > Entities.NAMES[hi].length()) break block4;
                if (c >= Entities.NAMES[hi].charAt(entCol)) break;
                --hi;
            }
            while (hi >= lo) {
                if (entCol == Entities.NAMES[lo].length()) {
                    candidate = lo++;
                    strBufMark = this.strBufLen;
                    continue;
                }
                if (entCol > Entities.NAMES[lo].length()) break block4;
                if (c > Entities.NAMES[lo].charAt(entCol)) {
                    ++lo;
                    continue;
                }
                if (hi < lo) break block4;
                this.appendStrBuf(c);
                continue block4;
            }
            break;
        }
        this.unread(c);
        if (candidate == -1) {
            this.err("Text after \u201c&\u201d did not match an entity name.");
            if (inAttribute) {
                this.appendStrBufToLongStrBuf();
            } else {
                this.emitStrBuf();
            }
            return;
        }
        if (!Entities.NAMES[candidate].endsWith(";")) {
            this.err("Entity reference was not terminated by a semicolon.");
            if (inAttribute) {
                if (strBufMark == this.strBufLen) {
                    c = this.read();
                    this.unread(c);
                } else {
                    c = this.strBuf[strBufMark];
                }
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    this.appendStrBufToLongStrBuf();
                    return;
                }
            }
        }
        char[] val = Entities.VALUES[candidate];
        this.emitOrAppend(val, inAttribute);
        if (strBufMark < this.strBufLen) {
            if (inAttribute) {
                for (int i = strBufMark; i < this.strBufLen; ++i) {
                    this.appendLongStrBuf(this.strBuf[i]);
                }
            } else {
                this.tokenHandler.characters(this.strBuf, strBufMark, this.strBufLen - strBufMark);
            }
        }
    }

    private void consumeNCR(boolean inAttribute) throws SAXException, IOException {
        int prevValue = -1;
        int value = 0;
        boolean seenDigits = false;
        boolean hex = false;
        char c = this.read();
        if (c == 'x' || c == 'X') {
            this.appendStrBuf(c);
            hex = true;
        } else {
            this.unread(c);
        }
        while (true) {
            if (value < prevValue) {
                value = 0x110000;
            }
            prevValue = value;
            c = this.read();
            if (c >= '0' && c <= '9') {
                seenDigits = true;
                value = hex ? (value *= 16) : (value *= 10);
                value += c - 48;
                continue;
            }
            if (hex && c >= 'A' && c <= 'F') {
                seenDigits = true;
                value *= 16;
                value += c - 65 + 10;
                continue;
            }
            if (!hex || c < 'a' || c > 'f') break;
            seenDigits = true;
            value *= 16;
            value += c - 97 + 10;
        }
        if (c == ';') {
            if (seenDigits) {
                this.handleNCRValue(value, inAttribute);
                return;
            }
            this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
            this.appendStrBuf(';');
            if (inAttribute) {
                this.appendStrBufToLongStrBuf();
            } else {
                this.emitStrBuf();
            }
            return;
        }
        this.unread(c);
        if (seenDigits) {
            this.err("Character reference was not terminated by a semicolon.");
            this.handleNCRValue(value, inAttribute);
            return;
        }
        this.err("No digits after \u201c" + this.strBufToString() + "\u201d.");
        if (inAttribute) {
            this.appendStrBufToLongStrBuf();
        } else {
            this.emitStrBuf();
        }
    }

    private void handleNCRValue(int value, boolean inAttribute) throws SAXException, IOException {
        if (value >= 128 && value <= 159) {
            this.err("A numeric character reference expanded to the C1 controls range.");
            char[] val = Entities.WINDOWS_1252[value - 128];
            this.emitOrAppend(val, inAttribute);
            return;
        }
        if (value == 13) {
            this.err("A numeric character reference expanded to carriage return.");
            this.emitOrAppend(LF, inAttribute);
            return;
        }
        if (value == 0) {
            this.err("Character reference expands to U+0000.");
            this.emitOrAppend(REPLACEMENT_CHARACTER, inAttribute);
            return;
        }
        if (this.contentSpacePolicy != XmlViolationPolicy.ALLOW && (value == 11 || value == 12)) {
            if (this.contentSpacePolicy == XmlViolationPolicy.ALTER_INFOSET) {
                this.emitOrAppend(SPACE, inAttribute);
            } else if (this.contentSpacePolicy == XmlViolationPolicy.FATAL) {
                this.fatal("A character reference expanded to a space character that is not legal XML 1.0 white space.");
            }
        } else {
            if ((value & 0xF800) == 55296) {
                this.err("Character reference expands to a surrogate.");
                this.emitOrAppend(REPLACEMENT_CHARACTER, inAttribute);
                return;
            }
            if (value <= 65535) {
                int c = value;
                if (c < 9 || c > 13 && c < 32 || this.isNonCharacter(c)) {
                    if (this.contentNonXmlCharPolicy != XmlViolationPolicy.FATAL) {
                        if (this.contentNonXmlCharPolicy == XmlViolationPolicy.ALTER_INFOSET) {
                            c = 65533;
                        }
                        this.warn("Character reference expanded to a character that is not a legal XML 1.0 character.");
                    } else {
                        this.fatal("Character reference expanded to a character that is not a legal XML 1.0 character.");
                    }
                }
                if (this.isPrivateUse((char)c)) {
                    this.warnAboutPrivateUseChar();
                }
                this.bmpChar[0] = c;
                this.emitOrAppend(this.bmpChar, inAttribute);
                return;
            }
            if (value <= 0x10FFFF) {
                if (this.isNonCharacter(value)) {
                    this.warn("Character reference expands to an astral non-character.");
                }
                if (this.isAstralPrivateUse(value)) {
                    this.warnAboutPrivateUseChar();
                }
                this.astralChar[0] = (char)(55232 + (value >> 10));
                this.astralChar[1] = (char)(56320 + (value & 0x3FF));
                this.emitOrAppend(this.astralChar, inAttribute);
                return;
            }
            this.err("Character reference outside the permissible Unicode range.");
            this.emitOrAppend(REPLACEMENT_CHARACTER, inAttribute);
            return;
        }
    }

    private void emitOrAppend(char[] val, boolean inAttribute) throws SAXException, IOException {
        if (inAttribute) {
            this.appendLongStrBuf(val);
        } else {
            this.tokenHandler.characters(val, 0, val.length);
        }
    }

    public boolean isMappingLangToXmlLang() {
        return this.mappingLangToXmlLang;
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.mappingLangToXmlLang = mappingLangToXmlLang;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CommentState {
        COMMENT_START_STATE,
        COMMENT_START_DASH_STATE,
        COMMENT_STATE,
        COMMENT_END_DASH_STATE,
        COMMENT_END_STATE;

    }
}

