/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.geo;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinate
implements Serializable,
Cloneable,
Comparable<Coordinate> {
    private static final long serialVersionUID = -916272885213668761L;
    private double latitude = 0.0;
    private double longitude = 0.0;

    public Coordinate() {
    }

    public Coordinate(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public Coordinate(String value) {
        Coordinate c = Coordinate.parse(value);
        this.setLatitude(c.latitude);
        this.setLongitude(c.longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        if (Double.compare(this.longitude, 90.0) > 0) {
            throw new IllegalArgumentException("Latitude > 90.0 degrees");
        }
        if (Double.compare(this.longitude, -90.0) < 0) {
            throw new IllegalArgumentException("Latitude < 90.0 degrees");
        }
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        if (Double.compare(longitude, 180.0) > 0) {
            throw new IllegalArgumentException("Longitude > 180.0 degrees");
        }
        if (Double.compare(longitude, -180.0) < 0) {
            throw new IllegalArgumentException("Longitude < 180.0 degrees");
        }
        this.longitude = longitude;
    }

    public String toString() {
        return String.valueOf(Double.toString(this.latitude)) + " " + Double.toString(this.longitude);
    }

    public Coordinate clone() {
        try {
            return (Coordinate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new Coordinate(this.latitude, this.longitude);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }

    public static Coordinate parse(String value) {
        try {
            String[] points = value.trim().split("\\s+", 2);
            double latitude = Double.parseDouble(points[0].trim());
            double longitude = Double.parseDouble(points[1].trim());
            return new Coordinate(latitude, longitude);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error parsing coordinate pair", t);
        }
    }

    @Override
    public int compareTo(Coordinate o) {
        if (o == null || this.equals(o)) {
            return 0;
        }
        int l1 = Double.compare(this.latitude, o.latitude);
        int l2 = Double.compare(this.longitude, o.longitude);
        if (l1 < 0) {
            return -1;
        }
        if (l1 == 0 && l2 < -1) {
            return -1;
        }
        if (l1 == 0 && l2 == 0) {
            return 0;
        }
        return 1;
    }
}

