/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.security;

import java.io.OutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;

public class Enc {
    public static void main(String[] args) throws Exception {
        Abdera abdera = new Abdera();
        try {
            String jce = abdera.getConfiguration().getConfigurationOption("jce.provider", "org.bouncycastle.jce.provider.BouncyCastleProvider");
            Class<?> provider = Class.forName(jce);
            Provider p = (Provider)provider.newInstance();
            Security.addProvider(p);
        }
        catch (Exception jce) {
            // empty catch block
        }
        String jceAlgorithmName = "AES";
        KeyGenerator keyGenerator = KeyGenerator.getInstance(jceAlgorithmName);
        keyGenerator.init(128);
        SecretKey key = keyGenerator.generateKey();
        AbderaSecurity absec = new AbderaSecurity(abdera);
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId("http://example.org/foo/entry");
        entry.setUpdated(new Date());
        entry.setTitle("This is an entry");
        entry.setContentAsXhtml("This <b>is</b> <i>markup</i>");
        entry.addAuthor("James");
        entry.addLink("http://www.example.org");
        Encryption enc = absec.getEncryption();
        EncryptionOptions options = enc.getDefaultEncryptionOptions();
        options.setDataEncryptionKey((Key)key);
        Document enc_doc = enc.encrypt(entry.getDocument(), options);
        enc_doc.writeTo((OutputStream)System.out);
        System.out.println("\n\n");
        Document entry_doc = enc.decrypt(enc_doc, options);
        entry_doc.writeTo((OutputStream)System.out);
    }
}

