/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.examples.appclient;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.ext.gdata.GoogleLoginAuthCredentials;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.parser.stax.util.FOMHelper;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;

public class Services {
    public static void postToBlogger() throws Exception {
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId(FOMHelper.generateUuid());
        entry.setUpdated(new Date());
        entry.addAuthor("James");
        entry.setTitle("Posting to Blogger");
        entry.setContentAsXhtml("<p>This is an example post to the new blogger beta</p>");
        AbderaClient abderaClient = new AbderaClient(abdera);
        GoogleLoginAuthCredentials creds = new GoogleLoginAuthCredentials("username", "password", "blogger");
        abderaClient.addCredentials("http://beta.blogger.com", null, "GoogleLogin", (Credentials)creds);
        RequestOptions options = abderaClient.getDefaultRequestOptions();
        options.setUseChunked(false);
        ClientResponse response = abderaClient.post("http://beta.blogger.com/feeds/7352231422284704069/posts/full", (Base)entry, options);
        if (response.getStatus() == 201) {
            System.out.println("Success!");
        } else {
            System.out.println("Failed!");
        }
    }

    public static void postToRoller() throws Exception {
        String start = "http://example.org/app";
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId(FOMHelper.generateUuid());
        entry.setUpdated(new Date());
        entry.addAuthor("James");
        entry.setTitle("Posting to Roller");
        entry.setContentAsHtml("<p>This is an example post to Roller</p>");
        AbderaClient abderaClient = new AbderaClient(abdera);
        abderaClient.addCredentials(start, null, null, (Credentials)new UsernamePasswordCredentials("username", "password"));
        Document service_doc = abderaClient.get(start).getDocument();
        Service service = (Service)service_doc.getRoot();
        Collection collection = (Collection)((Workspace)service.getWorkspaces().get(0)).getCollections().get(0);
        String uri = collection.getHref().toString();
        ClientResponse response = abderaClient.post(uri, (Base)entry);
        if (response.getStatus() == 201) {
            System.out.println("Success!");
        } else {
            System.out.println("Failed!");
        }
    }

    public static void postMediaToRoller() throws Exception {
        String start = "http://example.org/app";
        Abdera abdera = new Abdera();
        FileInputStream fis = new FileInputStream("mypodcast.mp3");
        InputStreamRequestEntity re = new InputStreamRequestEntity((InputStream)fis, "audio/mp3");
        AbderaClient abderaClient = new AbderaClient(abdera);
        abderaClient.addCredentials(start, null, null, (Credentials)new UsernamePasswordCredentials("username", "password"));
        Document service_doc = abderaClient.get(start).getDocument();
        Service service = (Service)service_doc.getRoot();
        Collection collection = (Collection)((Workspace)service.getWorkspaces().get(0)).getCollections().get(1);
        String uri = collection.getHref().toString();
        RequestOptions options = abderaClient.getDefaultRequestOptions();
        options.setHeader("Title", "mypodcast.mp3");
        ClientResponse response = abderaClient.post(uri, (RequestEntity)re, options);
        if (response.getStatus() == 201) {
            System.out.println("Success!");
        } else {
            System.out.println("Failed!");
        }
    }

    public static void postToCalendar() throws Exception {
        Abdera abdera = new Abdera();
        Factory factory = abdera.getFactory();
        Entry entry = factory.newEntry();
        entry.setId(FOMHelper.generateUuid());
        entry.setUpdated(new Date());
        entry.addAuthor("James");
        entry.setTitle("New Calendar Event");
        entry.setContentAsXhtml("<p>A new calendar event</p>");
        entry.addExtension(new QName("http://schemas.google.com/g/2005", "transparency")).setAttributeValue("value", "http://schemas.google.com/g/2005#event.opaque");
        entry.addExtension(new QName("http://schemas.google.com/g/2005", "eventStatus")).setAttributeValue("value", "http://schemas.google.com/g/2005#event.confirmed");
        entry.addExtension(new QName("http://schemas.google.com/g/2005", "where")).setAttributeValue("valueString", "Rolling Lawn Courts");
        Element el = entry.addExtension(new QName("http://schemas.google.com/g/2005", "when"));
        el.setAttributeValue("startTime", AtomDate.valueOf((Date)new Date()).toString());
        el.setAttributeValue("endTime", AtomDate.valueOf((Date)new Date()).toString());
        AbderaClient abderaClient = new AbderaClient(abdera);
        GoogleLoginAuthCredentials creds = new GoogleLoginAuthCredentials("username", "password", "cl");
        abderaClient.addCredentials("http://www.google.com/calendar", null, "GoogleLogin", (Credentials)creds);
        String uri = "http://www.google.com/calendar/feeds/default/private/full";
        RequestOptions options = abderaClient.getDefaultRequestOptions();
        options.setUseChunked(false);
        ClientResponse response = abderaClient.post(uri, (Base)entry, options);
        if (response.getStatus() == 302) {
            uri = response.getLocation().toString();
            response = abderaClient.post(uri, (Base)entry, options);
        }
        if (response.getStatus() == 201) {
            System.out.println("Success!");
        } else {
            System.out.println("Failed!");
        }
    }
}

