/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.strategy;

import java.lang.reflect.Method;
import java.util.Objects;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.annotation.InEnum;
import org.aoju.bus.validate.validators.Matcher;

public class InEnumStrategy
implements Matcher<Object, InEnum> {
    @Override
    public boolean on(Object object, InEnum annotation, Context context) {
        if (ObjectKit.isEmpty((Object)object)) {
            return false;
        }
        Class<? extends Enum> enumClass = annotation.enumClass();
        try {
            Enum[] enums;
            Method method = enumClass.getMethod(annotation.method(), new Class[0]);
            for (Enum e : enums = enumClass.getEnumConstants()) {
                Object value = ReflectKit.invokeMethod((Method)method, (Object)e);
                if (!Objects.equals(value, object)) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            throw new InternalException(e.getMessage());
        }
    }
}

