/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.rate.redis;

import org.aoju.bus.limiter.support.rate.RateLimiter;
import org.aoju.bus.limiter.support.rate.redis.RedisRatelimiterObject;
import org.aoju.bus.logger.Logger;
import org.redisson.Redisson;
import org.redisson.config.Config;

public class RedisRatelimiter
extends RateLimiter {
    private String limiterName;
    private RateLimiterRedission ratelimiterRedission;

    public RedisRatelimiter(String limiterName, Config config) {
        this.limiterName = limiterName;
        this.ratelimiterRedission = new RateLimiterRedission(config);
        Logger.info((String)"RedisRateLimiter named {} start success!", (Object[])new Object[]{limiterName});
    }

    @Override
    public boolean acquire(Object key, double rate, long capacity) {
        RedisRatelimiterObject rateLimiterObject = this.ratelimiterRedission.getRedisRatelimiterObject(key.toString());
        return rateLimiterObject.tryAcquire(1L, rate, capacity);
    }

    @Override
    public String getLimiterName() {
        return this.limiterName;
    }

    public static class RateLimiterRedission
    extends Redisson {
        public RateLimiterRedission(Config config) {
            super(config);
        }

        public RedisRatelimiterObject getRedisRatelimiterObject(String name) {
            return new RedisRatelimiterObject(this.commandExecutor, name);
        }
    }
}

