/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.lock.zookeeper;

import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.limiter.support.lock.Lock;
import org.aoju.bus.logger.Logger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZookeeperLock
extends Lock {
    private String lockName;
    private String basePath;
    private CuratorFramework client;

    public ZookeeperLock(String lockName, String basePath, CuratorFramework client) {
        this.lockName = lockName;
        this.basePath = basePath;
        this.client = client;
        if (!client.getState().equals((Object)CuratorFrameworkState.STARTED)) {
            client.start();
        }
        Logger.info((String)"zookeeper lock named {} start success!", (Object[])new Object[]{lockName});
    }

    public ZookeeperLock(String lockName, CuratorFramework client) {
        this(lockName, "/locks/", client);
    }

    @Override
    public boolean lock(Object key) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(this.basePath + key.toString());
            return true;
        }
        catch (KeeperException.NodeExistsException e) {
            Logger.info((String)"lock fail on {}", (Object[])new Object[]{key});
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void unlock(Object key) {
        try {
            this.client.delete().forPath(this.basePath + key.toString());
        }
        catch (KeeperException.NodeExistsException e) {
            throw new IllegalMonitorStateException("You do not own the lock: " + String.valueOf(key));
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public String getLimiterName() {
        return this.lockName;
    }
}

