/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.OrderStoreImpl;
import org.anyline.entity.PageNavi;
import org.anyline.jdbc.adapter.JDBCAdapter;
import org.anyline.jdbc.param.ConfigParser;
import org.anyline.jdbc.param.ConfigStore;
import org.anyline.jdbc.param.ParseResult;
import org.anyline.jdbc.prepare.Condition;
import org.anyline.jdbc.prepare.ConditionChain;
import org.anyline.jdbc.prepare.GroupStore;
import org.anyline.jdbc.prepare.RunPrepare;
import org.anyline.jdbc.prepare.Variable;
import org.anyline.jdbc.prepare.auto.init.SimpleAutoCondition;
import org.anyline.jdbc.prepare.auto.init.SimpleAutoConditionChain;
import org.anyline.jdbc.prepare.init.SimpleGroupStore;
import org.anyline.jdbc.run.Run;
import org.anyline.jdbc.run.RunValue;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRun
implements Run {
    protected static final Logger log = LoggerFactory.getLogger(BasicRun.class);
    protected StringBuilder builder = new StringBuilder();
    protected RunPrepare prepare;
    protected String catalog;
    protected String schema;
    protected String table;
    protected List<String> keys;
    protected List<RunValue> values;
    protected PageNavi pageNavi;
    protected ConditionChain conditionChain;
    protected ConfigStore configStore;
    protected OrderStore orderStore;
    protected GroupStore groupStore;
    protected String having;
    protected List<Variable> variables;
    protected boolean strict = false;
    protected boolean valid = true;
    protected List<String> insertColumns;
    protected List<String> updateColumns;
    protected JDBCAdapter adapter;
    protected String delimiterFr;
    protected String delimiterTo;
    protected static AnylineService service;

    @Override
    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void init() {
        this.delimiterFr = this.adapter.getDelimiterFr();
        this.delimiterTo = this.adapter.getDelimiterTo();
        if (null != this.configStore) {
            this.setPageNavi(this.configStore.getPageNavi());
            OrderStore orderStore = this.configStore.getOrders();
            List orders = null;
            if (null != orderStore) {
                orders = orderStore.getOrders();
            }
            if (null != orders) {
                for (Order order : orders) {
                    orderStore.order(order);
                }
            }
        }
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public String getDataSource() {
        String ds = this.table;
        if (BasicUtil.isNotEmpty((Object)ds) && BasicUtil.isNotEmpty((Object)this.schema)) {
            ds = this.schema + "." + ds;
        }
        if (BasicUtil.isEmpty((Object)ds)) {
            ds = this.schema;
        }
        return ds;
    }

    @Override
    public Run group(String group) {
        if (BasicUtil.isEmpty((Object)group)) {
            return this;
        }
        if (null == this.groupStore) {
            this.groupStore = new SimpleGroupStore();
        }
        group = group.trim().toUpperCase();
        if (!this.groupStore.getGroups().contains(group)) {
            this.groupStore.group(group);
        }
        return this;
    }

    @Override
    public Run order(String order) {
        if (null == this.orderStore) {
            this.orderStore = new OrderStoreImpl();
        }
        this.orderStore.order(order);
        return this;
    }

    @Override
    public RunPrepare getPrepare() {
        return this.prepare;
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        return this;
    }

    @Override
    public List<RunValue> getRunValues() {
        return this.values;
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (null != this.values) {
            for (RunValue value : this.values) {
                list.add(value.getValue());
            }
        }
        return list;
    }

    public void setValues(String key, List<Object> values) {
        for (Object value : values) {
            values.add(new RunValue(key, value));
        }
    }

    @Override
    public Run addValues(String key, Object obj) {
        if (null == key) {
            key = "none";
        }
        if (null != obj && obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                this.addValues(new RunValue(key, item));
            }
        } else {
            this.addValues(new RunValue(key, obj));
        }
        return this;
    }

    public Run addValues(RunValue run) {
        if (null == this.values) {
            this.values = new ArrayList<RunValue>();
        }
        this.adapter.convert(this.getCatalog(), this.getSchema(), this.getTable(), run);
        this.values.add(run);
        return this;
    }

    public Run addValues(List<RunValue> values) {
        for (RunValue value : values) {
            this.addValues(value);
        }
        return this;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.pageNavi;
    }

    @Override
    public void setPageNavi(PageNavi pageNavi) {
        this.pageNavi = pageNavi;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    @Override
    public void setConfigStore(ConfigStore configStore) {
        this.configStore = configStore;
    }

    @Override
    public OrderStore getOrderStore() {
        return this.orderStore;
    }

    @Override
    public void setOrderStore(OrderStore orderStore) {
        this.orderStore = orderStore;
    }

    @Override
    public GroupStore getGroupStore() {
        return this.groupStore;
    }

    @Override
    public void setGroupStore(GroupStore groupStore) {
        this.groupStore = groupStore;
    }

    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    public void setDelimiterFr(String delimiterFr) {
        this.delimiterFr = delimiterFr;
    }

    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    public void setDelimiterTo(String delimiterTo) {
        this.delimiterTo = delimiterTo;
    }

    public JDBCAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public Run setConditionValue(boolean required, boolean strictRequired, String prefix, String variable, Object value, RunPrepare.COMPARE_TYPE compare) {
        return this;
    }

    @Override
    public void setOrders(String[] orders) {
        if (null != orders) {
            for (String order : orders) {
                this.order(order);
            }
        }
    }

    @Override
    public String getFinalQuery() {
        String text = this.adapter.parseFinalQuery(this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return text;
    }

    @Override
    public String getTotalQuery() {
        String text = this.adapter.parseTotalQuery(this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return text;
    }

    @Override
    public String getFinalExists() {
        String text = this.adapter.parseExists(this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return text;
    }

    @Override
    public String getBaseQuery() {
        return this.builder.toString();
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    @Override
    public Run setConditionChain(ConditionChain chain) {
        this.conditionChain = chain;
        return this;
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.conditionChain;
    }

    @Override
    public Run addCondition(boolean required, boolean strictRequired, String prefix, String var, Object value, RunPrepare.COMPARE_TYPE compare) {
        SimpleAutoCondition condition = new SimpleAutoCondition(required, strictRequired, prefix, var, value, compare);
        if (null == this.conditionChain) {
            this.conditionChain = new SimpleAutoConditionChain();
        }
        if (condition.isActive()) {
            this.conditionChain.addCondition(condition);
        }
        return this;
    }

    @Override
    public Run addCondition(boolean required, String prefix, String var, Object value, RunPrepare.COMPARE_TYPE compare) {
        return this.addCondition(required, false, prefix, var, value, compare);
    }

    @Override
    public Run addCondition(Condition condition) {
        if (null != this.conditionChain) {
            this.conditionChain.addCondition(condition);
        }
        return this;
    }

    @Override
    public Condition getCondition(String name) {
        for (Condition con : this.conditionChain.getConditions()) {
            if (null == con || null == con.getId() || !con.getId().equalsIgnoreCase(name)) continue;
            return con;
        }
        return null;
    }

    @Override
    public String getFinalDelete() {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return this.builder.toString();
    }

    @Override
    public String getFinalInsert() {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return this.builder.toString();
    }

    @Override
    public String getFinalUpdate() {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return this.builder.toString();
    }

    public Run addVariable(Variable var) {
        if (null == this.variables) {
            this.variables = new ArrayList<Variable>();
        }
        this.variables.add(var);
        return this;
    }

    @Override
    public String getFinalExecute() {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.prepare.getText(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        return this.prepare.getText();
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public List<String> getInsertColumns() {
        return this.insertColumns;
    }

    @Override
    public Run setInsertColumns(List<String> insertColumns) {
        this.insertColumns = insertColumns;
        return this;
    }

    @Override
    public List<String> getUpdateColumns() {
        return this.updateColumns;
    }

    @Override
    public Run setUpdateColumns(List<String> updateColumns) {
        this.updateColumns = updateColumns;
        return this;
    }

    @Override
    public Run addConditions(String ... conditions) {
        if (null != conditions) {
            for (String condition : conditions) {
                if (null == condition) continue;
                String up = (condition = condition.trim()).toUpperCase().replaceAll("\\s+", " ").trim();
                if (up.startsWith("ORDER BY")) {
                    String[] orders;
                    String orderStr = condition.substring(up.indexOf("ORDER BY") + "ORDER BY".length()).trim();
                    for (String item : orders = orderStr.split(",")) {
                        this.order(item);
                        if (null != this.configStore) {
                            this.configStore.order(item);
                        }
                        if (null == this.orderStore) continue;
                        this.orderStore.order(item);
                    }
                    continue;
                }
                if (up.startsWith("GROUP BY")) {
                    String[] groups;
                    String groupStr = condition.substring(up.indexOf("GROUP BY") + "GROUP BY".length()).trim();
                    for (String item : groups = groupStr.split(",")) {
                        if (null == this.groupStore) {
                            this.groupStore = new SimpleGroupStore();
                        }
                        this.groupStore.group(item);
                    }
                    continue;
                }
                if (up.startsWith("HAVING")) {
                    String haveStr;
                    this.having = haveStr = condition.substring(up.indexOf("HAVING") + "HAVING".length()).trim();
                    continue;
                }
                if (condition.startsWith("${") && condition.endsWith("}")) {
                    SimpleAutoCondition con = new SimpleAutoCondition(condition.substring(2, condition.length() - 1));
                    this.addCondition(con);
                    continue;
                }
                if (condition.contains(":")) {
                    boolean isTime = false;
                    int idx = condition.indexOf(":");
                    if (condition.indexOf("'") < idx && condition.indexOf("'", idx + 1) > 0) {
                        isTime = true;
                    }
                    if (!isTime) {
                        ParseResult parser = ConfigParser.parse(condition, false);
                        List<Object> value = ConfigParser.getValues(parser);
                        this.addCondition(parser.isRequired(), parser.isStrictRequired(), parser.getPrefix(), parser.getVar(), value, parser.getCompare());
                        continue;
                    }
                }
                SimpleAutoCondition con = new SimpleAutoCondition(condition);
                this.addCondition(con);
            }
        }
        return this;
    }

    protected static boolean endWithWhere(String txt) {
        boolean result = false;
        txt = txt.toUpperCase();
        int fr = 0;
        while ((fr = txt.indexOf("WHERE")) > 0) {
            if ((txt = txt.substring(fr + 5)).indexOf("UNION") > 0) continue;
            try {
                int bSize = 0;
                if (txt.contains(")")) {
                    bSize = RegularUtil.fetch((String)txt, (String)"\\)").size();
                }
                int eSize = 0;
                if (txt.contains("(")) {
                    eSize = RegularUtil.fetch((String)txt, (String)"\\(").size();
                }
                if (bSize != eSize) continue;
                result = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String getQueryColumns() {
        List<String> cols;
        String result = "*";
        if (null != this.prepare && null != (cols = this.prepare.getFetchKeys()) && cols.size() > 0) {
            result = null;
            for (String col : cols) {
                if (null == result) {
                    result = SQLUtil.delimiter((String)col, (String)this.adapter.getDelimiterFr(), (String)this.adapter.getDelimiterTo());
                    continue;
                }
                result = result + "," + SQLUtil.delimiter((String)col, (String)this.adapter.getDelimiterFr(), (String)this.adapter.getDelimiterTo());
            }
        }
        return result;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }
}

