/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.prepare.xml.init;

import java.util.List;
import org.anyline.jdbc.adapter.JDBCAdapter;
import org.anyline.jdbc.prepare.Condition;
import org.anyline.jdbc.prepare.ConditionChain;
import org.anyline.jdbc.prepare.auto.AutoCondition;
import org.anyline.jdbc.prepare.init.SimpleConditionChain;
import org.anyline.jdbc.run.RunValue;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.RegularUtil;

public class SimpleXMLConditionChain
extends SimpleConditionChain
implements ConditionChain {
    @Override
    public String getRunText(String prefix, JDBCAdapter adapter) {
        this.initRunValue();
        StringBuilder builder = new StringBuilder();
        if (null != this.conditions) {
            for (Condition condition : this.conditions) {
                if (null == condition) continue;
                String txt = "";
                if (condition.getVariableType() == 2) {
                    builder.append("\n\t");
                    txt = condition.getRunText(prefix, adapter);
                } else if (condition.isActive()) {
                    builder.append("\n\t");
                    txt = condition.getRunText(prefix, adapter);
                    List<RunValue> values = condition.getRunValues();
                    if (BasicUtil.isEmpty((boolean)true, values)) {
                        String reg = "=\\s*\\?";
                        if (RegularUtil.match((String)txt, (String)reg)) {
                            txt = txt.replaceAll(reg, " IS NULL ");
                        }
                    } else {
                        this.addRunValue(values);
                    }
                }
                if (BasicUtil.isNotEmpty((Object)txt) && condition instanceof AutoCondition) {
                    txt = condition.getJoin() + txt;
                }
                if (!condition.isActive()) continue;
                builder.append(txt);
            }
        }
        return builder.toString();
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public void setValue(String name, Object value) {
        if (null != this.conditions) {
            for (Condition con : this.conditions) {
                if (null == con || !con.getId().equalsIgnoreCase(name)) continue;
                con.setValue(name, value);
                break;
            }
        }
    }
}

