/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.prepare.auto.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.anyline.jdbc.adapter.JDBCAdapter;
import org.anyline.jdbc.param.Config;
import org.anyline.jdbc.prepare.Condition;
import org.anyline.jdbc.prepare.RunPrepare;
import org.anyline.jdbc.prepare.auto.AutoCondition;
import org.anyline.jdbc.prepare.init.SimpleCondition;
import org.anyline.jdbc.run.RunValue;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;

public class SimpleAutoCondition
extends SimpleCondition
implements AutoCondition {
    private String table;
    private String column;
    private Object values;
    private Object orValues;
    private RunPrepare.COMPARE_TYPE compare = RunPrepare.COMPARE_TYPE.EQUAL;
    private RunPrepare.COMPARE_TYPE orCompare = RunPrepare.COMPARE_TYPE.EQUAL;

    public SimpleAutoCondition(Config config) {
        this.setJoin(config.getJoin());
        this.setTable(config.getPrefix());
        this.setColumn(config.getVariable());
        this.setValues(config.getValues());
        this.setOrValues(config.getOrValues());
        this.setCompare(config.getCompare());
        this.setRequired(config.isRequire());
        this.setStrictRequired(config.isStrictRequired());
        this.setVariableType(0);
        if (config.isRequire()) {
            this.setActive(true);
        }
    }

    public SimpleAutoCondition(boolean required, boolean strictRequired, String prefix, String var, Object values, RunPrepare.COMPARE_TYPE compare) {
        this.setRequired(required);
        this.setStrictRequired(strictRequired);
        this.setTable(prefix);
        this.setColumn(var);
        this.setValues(values);
        this.setCompare(compare);
        this.setVariableType(0);
        if (BasicUtil.isNotEmpty((boolean)true, (Object)values) || required) {
            this.setActive(true);
        }
    }

    public SimpleAutoCondition(String text) {
        this.text = text;
        this.active = true;
        this.setVariableType(2);
    }

    @Override
    public String getRunText(String prefix, JDBCAdapter adapter) {
        this.runValues = new ArrayList();
        String text = "";
        if (this.variableType == 2) {
            text = this.text;
        } else {
            String txt = "";
            if (BasicUtil.isNotEmpty((boolean)true, (Object)this.values) || this.isRequired()) {
                txt = this.getRunText(prefix, adapter, this.values, this.compare);
                if (BasicUtil.isNotEmpty((Object)txt)) {
                    text = txt;
                }
                if (BasicUtil.isNotEmpty((boolean)true, (Object)this.orValues) && BasicUtil.isNotEmpty((Object)(txt = this.getRunText(prefix, adapter, this.orValues, this.orCompare)))) {
                    text = BasicUtil.isEmpty((Object)text) ? txt : "(" + text + " OR " + txt + ")";
                }
            }
        }
        return text;
    }

    public String getRunText(String prefix, JDBCAdapter adapter, Object val, RunPrepare.COMPARE_TYPE compare) {
        StringBuilder builder = new StringBuilder();
        String delimiterFr = adapter.getDelimiterFr();
        String delimiterTo = adapter.getDelimiterTo();
        if (!this.column.contains(".")) {
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                SQLUtil.delimiter((StringBuilder)builder, (String)prefix, (String)delimiterFr, (String)delimiterTo).append(".");
            } else if (BasicUtil.isNotEmpty((Object)this.table)) {
                SQLUtil.delimiter((StringBuilder)builder, (String)this.table, (String)delimiterFr, (String)delimiterTo).append(".");
            }
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)this.column, (String)delimiterFr, (String)delimiterTo);
        int compareCode = compare.getCode();
        if (compare == RunPrepare.COMPARE_TYPE.EQUAL) {
            Object v = this.getValue(val);
            if (null == v || "NULL".equals(v.toString())) {
                builder.append(" IS NULL");
                if ("NULL".equals(this.getValue())) {
                    this.variableType = 2;
                }
            } else {
                builder.append(compare.getSql());
            }
        } else if (compare == RunPrepare.COMPARE_TYPE.GREAT) {
            builder.append(compare.getSql());
        } else if (compare == RunPrepare.COMPARE_TYPE.GREAT_EQUAL) {
            builder.append(compare.getSql());
        } else if (compare == RunPrepare.COMPARE_TYPE.LESS) {
            builder.append(compare.getSql());
        } else if (compare == RunPrepare.COMPARE_TYPE.NOT_EQUAL) {
            builder.append(compare.getSql());
        } else if (compare == RunPrepare.COMPARE_TYPE.LESS_EQUAL) {
            builder.append(compare.getSql());
        } else if (compare == RunPrepare.COMPARE_TYPE.BETWEEN) {
            builder.append(compare.getSql());
        } else if (compare == RunPrepare.COMPARE_TYPE.IN || compare == RunPrepare.COMPARE_TYPE.NOT_IN) {
            adapter.buildConditionIn(builder, compare, val);
        } else if (compareCode >= 50 && compareCode <= 52) {
            adapter.buildConditionLike(builder, compare);
        }
        if (compare == RunPrepare.COMPARE_TYPE.IN || compare == RunPrepare.COMPARE_TYPE.NOT_IN || compare == RunPrepare.COMPARE_TYPE.BETWEEN) {
            List<Object> list = this.getValues(val);
            if (null != list) {
                for (Object obj : list) {
                    this.runValues.add(new RunValue(this.column, obj));
                }
            }
        } else {
            Object value = this.getValue(val);
            if (null != value && !"NULL".equals(value) || compare != RunPrepare.COMPARE_TYPE.EQUAL) {
                this.runValues.add(new RunValue(this.column, value));
            }
        }
        return builder.toString();
    }

    public Object getValue(Object src) {
        Object value = null;
        if (null != src) {
            if (src instanceof List) {
                if (((List)src).size() > 0) {
                    value = ((List)src).get(0);
                }
            } else {
                value = src;
            }
        }
        return value;
    }

    public List<Object> getValues(Object src) {
        List<Object> values = new ArrayList<Object>();
        if (null != src) {
            if (src instanceof List) {
                values = (List)src;
            } else {
                values.add(src);
            }
        }
        return values;
    }

    @Override
    public Object getValue() {
        return this.getValue(this.values);
    }

    @Override
    public List<Object> getValues() {
        return this.getValues(this.values);
    }

    public Object getOrValue() {
        return this.getValue(this.orValues);
    }

    public List<Object> getOrValues() {
        return this.getValues(this.orValues);
    }

    @Override
    public String getId() {
        return this.column;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public void setValues(Object values) {
        this.values = values;
    }

    public void setOrValues(Object values) {
        this.orValues = values;
    }

    @Override
    public RunPrepare.COMPARE_TYPE getCompare() {
        return this.compare;
    }

    @Override
    public AutoCondition setCompare(RunPrepare.COMPARE_TYPE compare) {
        this.compare = compare;
        return this;
    }

    public RunPrepare.COMPARE_TYPE getOrCompare() {
        return this.orCompare;
    }

    @Override
    public AutoCondition setOrCompare(RunPrepare.COMPARE_TYPE orCompare) {
        this.orCompare = orCompare;
        return this;
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("join", this.getJoin());
        map.put("column", this.column);
        map.put("compare", this.compare.getName());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }
}

