/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.prepare;

import org.anyline.jdbc.prepare.RunPrepare;
import org.anyline.jdbc.prepare.Variable;
import org.anyline.jdbc.prepare.init.SimpleVariable;
import org.anyline.util.BasicUtil;

public class SyntaxHelper {
    public static Variable buildVariable(int signType, String all, String prefix, String fullKey, String afterChar) {
        int varType = -1;
        RunPrepare.COMPARE_TYPE compare = RunPrepare.COMPARE_TYPE.EQUAL;
        if (null == afterChar) {
            afterChar = "";
        }
        SimpleVariable var = new SimpleVariable();
        String key = null;
        if (signType == 1) {
            key = fullKey.replace(":", "");
        } else if (signType == 2) {
            key = fullKey.replace("${", "").replace("}", "");
        }
        if (fullKey.startsWith("$") || fullKey.startsWith("::")) {
            varType = 3;
        } else if ("'".equals(afterChar)) {
            varType = 2;
        } else if (prefix.endsWith("%") || afterChar.startsWith("%")) {
            varType = 1;
            if (prefix.endsWith("%") && afterChar.startsWith("%")) {
                compare = RunPrepare.COMPARE_TYPE.LIKE;
            } else if (prefix.endsWith("%")) {
                compare = RunPrepare.COMPARE_TYPE.LIKE_PREFIX;
            } else if (afterChar.startsWith("%")) {
                compare = RunPrepare.COMPARE_TYPE.LIKE_SUBFIX;
            }
        } else {
            varType = 1;
            if (prefix.equalsIgnoreCase("IN") || prefix.equalsIgnoreCase("IN(")) {
                compare = RunPrepare.COMPARE_TYPE.IN;
            }
        }
        var.setSignType(signType);
        var.setKey(key);
        var.setType(varType);
        var.setCompare(compare);
        return var;
    }

    public static RunPrepare.COMPARE_TYPE parseCompare(int code) {
        for (RunPrepare.COMPARE_TYPE type : RunPrepare.COMPARE_TYPE.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }

    public static RunPrepare.COMPARE_TYPE parseCompare(String code) {
        if (BasicUtil.isEmpty((Object)code)) {
            return null;
        }
        for (RunPrepare.COMPARE_TYPE type : RunPrepare.COMPARE_TYPE.values()) {
            if (!code.equals(type.getCode() + "")) continue;
            return type;
        }
        return null;
    }
}

