/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.param.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.anyline.entity.Order;
import org.anyline.entity.OrderImpl;
import org.anyline.entity.OrderStore;
import org.anyline.entity.OrderStoreImpl;
import org.anyline.entity.PageNavi;
import org.anyline.entity.PageNaviImpl;
import org.anyline.jdbc.param.Config;
import org.anyline.jdbc.param.ConfigChain;
import org.anyline.jdbc.param.ConfigStore;
import org.anyline.jdbc.param.init.SimpleConfig;
import org.anyline.jdbc.param.init.SimpleConfigChain;
import org.anyline.jdbc.prepare.Group;
import org.anyline.jdbc.prepare.GroupStore;
import org.anyline.jdbc.prepare.RunPrepare;
import org.anyline.jdbc.prepare.init.SimpleGroup;
import org.anyline.jdbc.prepare.init.SimpleGroupStore;
import org.anyline.util.BasicUtil;
import org.anyline.util.DESUtil;

public class SimpleConfigStore
implements ConfigStore {
    private static final long serialVersionUID = -2098827041540802313L;
    protected ConfigChain chain;
    protected PageNavi navi;
    protected OrderStore orders;
    protected GroupStore groups;

    @Override
    public String toString() {
        String str = "";
        if (null != this.chain) {
            str = str + this.chain.toString();
        }
        if (null != this.navi) {
            str = str + "." + this.navi.getFirstRow() + "." + this.navi.getLastRow() + "." + this.navi.getCurPage();
        }
        if (null != this.orders) {
            str = str + "." + this.orders.getRunText("");
        }
        if (null != this.groups) {
            str = str + "." + this.groups.getRunText("");
        }
        return str;
    }

    @Override
    public Config parseConfig(String config) {
        if (null == config) {
            return null;
        }
        SimpleConfig conf = null;
        conf = config.indexOf("|") != -1 ? new SimpleConfigChain(config) : new SimpleConfig(config);
        return conf;
    }

    @Override
    public ConfigStore setPageNavi(PageNavi navi) {
        this.navi = navi;
        return this;
    }

    @Override
    public ConfigStore copyPageNavi(PageNavi navi) {
        if (null == this.navi) {
            this.navi = navi;
        } else {
            this.navi.setBaseLink(navi.getBaseLink());
            this.navi.setCalType(navi.getCalType());
            this.navi.setCurPage(navi.getCurPage());
            this.navi.setDisplayPageFirst(navi.getDisplayPageFirst());
            this.navi.setDisplayPageLast(navi.getDisplayPageLast());
            this.navi.setFirstRow(navi.getFirstRow());
            this.navi.setLastRow(navi.getLastRow());
            this.navi.setPageRows(navi.getPageRows());
            this.navi.setTotalPage(navi.getTotalPage());
            this.navi.setTotalRow(navi.getTotalRow());
        }
        return this;
    }

    public SimpleConfigStore(String ... configs) {
        configs = BasicUtil.compressionSpace((String[])configs);
        this.chain = new SimpleConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    public SimpleConfigStore(int fr, int to) {
        this.chain = new SimpleConfigChain();
        PageNaviImpl navi = new PageNaviImpl();
        navi.setFirstRow(fr);
        navi.setLastRow(to);
        navi.setCalType(1);
        navi.setTotalRow(to - fr + 1);
        this.setPageNavi((PageNavi)navi);
    }

    public SimpleConfigStore(List<String> configs) {
        configs = BasicUtil.compressionSpace(configs);
        this.chain = new SimpleConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    @Override
    public ConfigStore addConditions(String var, Object ... values) {
        return this.addCondition(RunPrepare.COMPARE_TYPE.IN, var, (Object)values);
    }

    @Override
    public ConfigStore addCondition(String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition((String)null, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore addCondition(String text) {
        SimpleConfig conf = new SimpleConfig();
        conf.setText(text);
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore addCondition(String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(RunPrepare.COMPARE_TYPE.EQUAL, prefix, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore addCondition(RunPrepare.COMPARE_TYPE compare, String var, Object value) {
        return this.addCondition(compare, var, value, false, false);
    }

    @Override
    public ConfigStore addCondition(RunPrepare.COMPARE_TYPE compare, String id, String var, Object value) {
        return this.addCondition(compare, id, var, value, false, false);
    }

    @Override
    public ConfigStore addCondition(String id, String var, Object value) {
        return this.addCondition(id, var, value, false, false);
    }

    @Override
    public ConfigStore addCondition(RunPrepare.COMPARE_TYPE compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        Config conf = null;
        boolean require = false;
        boolean strictRequired = false;
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1, var.length());
        }
        if (overCondition) {
            conf = this.chain.getConfig(prefix, var, compare);
        }
        if (null != var) {
            if (var.startsWith("++")) {
                strictRequired = true;
                var = var.substring(2);
            } else if (var.startsWith("+")) {
                require = true;
                var = var.substring(1);
            }
        }
        if (null == conf) {
            conf = new SimpleConfig();
            conf.setJoin(" AND ");
            conf.setCompare(compare);
            this.chain.addConfig(conf);
        }
        conf.setPrefix(prefix);
        conf.setVariable(var);
        conf.setRequire(require);
        conf.setStrictRequired(strictRequired);
        if (overValue) {
            conf.setValue(value);
        } else {
            conf.addValue(value);
        }
        return this;
    }

    @Override
    public ConfigStore addCondition(RunPrepare.COMPARE_TYPE compare, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(compare, null, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore addCondition(Config conf) {
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore addCondition(String var, Object value) {
        return this.addCondition(var, value, false, false);
    }

    @Override
    public ConfigStore and(String var, Object value) {
        return this.addCondition(var, value, false, false);
    }

    @Override
    public ConfigStore and(RunPrepare.COMPARE_TYPE compare, String var, Object value) {
        return this.addCondition(compare, var, value, false, false);
    }

    @Override
    public ConfigStore or(String var, Object value) {
        return this.or(RunPrepare.COMPARE_TYPE.EQUAL, var, value);
    }

    @Override
    public ConfigStore or(RunPrepare.COMPARE_TYPE compare, String var, Object value) {
        List<Config> configs = this.chain.getConfigs();
        if (configs.size() == 0) {
            this.and(compare, var, value);
        } else {
            SimpleConfigChain orChain = new SimpleConfigChain();
            Config last = configs.get(configs.size() - 1);
            configs.remove(last);
            if (last instanceof ConfigChain) {
                ConfigChain lastChain = (ConfigChain)last;
                List<Config> lastItems = lastChain.getConfigs();
                for (Config lastItem : lastItems) {
                    orChain.addConfig(lastItem);
                }
            } else {
                orChain.addConfig(last);
            }
            SimpleConfig conf = new SimpleConfig();
            conf.setJoin(" OR ");
            conf.setCompare(compare);
            conf.setVariable(var);
            conf.setValue(value);
            orChain.addConfig(conf);
            this.chain.addConfig(orChain);
        }
        return this;
    }

    @Override
    public ConfigStore conditions(String var, Object value) {
        return this.addConditions(var, value);
    }

    @Override
    public ConfigStore condition(String var, Object value) {
        return this.addCondition(var, value);
    }

    @Override
    public ConfigStore condition(String id, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(id, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore condition(String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore condition(RunPrepare.COMPARE_TYPE compare, String var, Object value) {
        return this.addCondition(compare, var, value);
    }

    @Override
    public ConfigStore condition(RunPrepare.COMPARE_TYPE compare, String var, Object value, boolean overCondition, boolean overValue) {
        return this.addCondition(compare, var, value, overCondition, overValue);
    }

    @Override
    public ConfigStore condition(String id, String var, Object value) {
        return this.addCondition(id, var, value);
    }

    @Override
    public ConfigStore condition(Config config) {
        return this.addCondition(config);
    }

    @Override
    public ConfigStore ors(String var, Object value) {
        return this.ors(RunPrepare.COMPARE_TYPE.EQUAL, var, value);
    }

    @Override
    public ConfigStore ors(RunPrepare.COMPARE_TYPE compare, String var, Object value) {
        SimpleConfigChain newChain = new SimpleConfigChain();
        newChain.addConfig(this.chain);
        SimpleConfig conf = new SimpleConfig();
        conf.setJoin(" OR ");
        conf.setCompare(compare);
        conf.setVariable(var);
        conf.setValue(value);
        newChain.addConfig(conf);
        this.chain = newChain;
        return this;
    }

    protected void setNaviParam() {
        if (null == this.chain || null == this.navi) {
            return;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            String key = config.getKey();
            List<Object> values = new ArrayList();
            List<Object> srcValues = config.getValues();
            if (config.isKeyEncrypt()) {
                key = DESUtil.encryptParamKey((String)key);
            }
            if (config.isValueEncrypt() && null != srcValues) {
                for (Object value : srcValues) {
                    if (null == value) continue;
                    value = DESUtil.encryptParamValue((String)value.toString());
                    values.add(value);
                }
            } else {
                values = srcValues;
            }
            this.navi.addParam(key, values);
        }
    }

    @Override
    public ConfigStore addParam(String key, String value) {
        if (null != this.navi) {
            this.navi.addParam(key, (Object)value);
        }
        return this;
    }

    @Override
    public ConfigChain getConfigChain() {
        return this.chain;
    }

    @Override
    public ConfigStore order(Order order) {
        if (null == this.orders) {
            this.orders = new OrderStoreImpl();
        }
        this.orders.order(order);
        if (null != this.navi) {
            this.navi.order(order.getColumn(), order.getType().getCode());
        }
        return this;
    }

    @Override
    public ConfigStore order(String column, String type) {
        return this.order((Order)new OrderImpl(column, type));
    }

    @Override
    public ConfigStore order(String order) {
        return this.order((Order)new OrderImpl(order));
    }

    @Override
    public OrderStore getOrders() {
        return this.orders;
    }

    @Override
    public ConfigStore setOrders(OrderStore orders) {
        this.orders = orders;
        return this;
    }

    @Override
    public ConfigStore group(Group group) {
        if (null == this.groups) {
            this.groups = new SimpleGroupStore();
        }
        this.groups.group(group);
        return this;
    }

    @Override
    public ConfigStore group(String group) {
        return this.group(new SimpleGroup(group));
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public ConfigStore setGroups(GroupStore groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.navi;
    }

    @Override
    public Config getConfig(String var) {
        return this.chain.getConfig(null, var);
    }

    @Override
    public ConfigStore removeConfig(String var) {
        Config config = this.getConfig(var);
        return this.removeConfig(config);
    }

    @Override
    public ConfigStore removeConfig(Config config) {
        this.chain.removeConfig(config);
        return this;
    }

    @Override
    public List<Object> getConfigValues(String var) {
        Config config = this.chain.getConfig(null, var);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var);
        if (null != config && null != (values = config.getValues()) && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Config getConfig(String var, RunPrepare.COMPARE_TYPE compare) {
        return this.chain.getConfig(null, var, compare);
    }

    @Override
    public ConfigStore removeConfig(String var, RunPrepare.COMPARE_TYPE compare) {
        Config config = this.getConfig(var, compare);
        return this.removeConfig(config);
    }

    @Override
    public List<Object> getConfigValues(String var, RunPrepare.COMPARE_TYPE compare) {
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var, RunPrepare.COMPARE_TYPE compare) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config && null != (values = config.getValues()) && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public ConfigStore fetch(String ... keys) {
        SimpleConfigStore result = new SimpleConfigStore(new String[0]);
        result.setOrders(this.getOrders());
        result.setGroups(this.getGroups());
        result.setPageNavi(this.getPageNavi());
        SimpleConfigChain chain = new SimpleConfigChain();
        List<Config> configs = this.getConfigChain().getConfigs();
        for (Config config : configs) {
            if (null == config || !BasicUtil.contains((Object[])keys, (Object)config.getPrefix())) continue;
            chain.addConfig((Config)config.clone());
        }
        result.chain = chain;
        return result;
    }

    @Override
    public ConfigStore setTotalLazy(long ms) {
        if (null != this.navi) {
            this.navi.setLazy(ms);
        }
        return this;
    }

    public ConfigStore clone() {
        SimpleConfigStore store = new SimpleConfigStore(new String[0]);
        return store;
    }

    @Override
    public ConfigStore setValue(Map<String, Object> values) {
        if (null == this.chain || null == values) {
            return this;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            config.setValue(values);
        }
        this.setNaviParam();
        return this;
    }
}

