/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.adapter;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.anyline.dao.PrimaryCreater;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.jdbc.adapter.JDBCAdapter;
import org.anyline.jdbc.ds.DataSourceHolder;
import org.anyline.jdbc.entity.Column;
import org.anyline.jdbc.entity.Constraint;
import org.anyline.jdbc.entity.Index;
import org.anyline.jdbc.entity.MasterTable;
import org.anyline.jdbc.entity.PartitionTable;
import org.anyline.jdbc.entity.Table;
import org.anyline.jdbc.entity.Tag;
import org.anyline.jdbc.param.ConfigStore;
import org.anyline.jdbc.prepare.RunPrepare;
import org.anyline.jdbc.prepare.auto.TablePrepare;
import org.anyline.jdbc.prepare.auto.TextPrepare;
import org.anyline.jdbc.prepare.auto.init.SimpleTablePrepare;
import org.anyline.jdbc.prepare.xml.XMLPrepare;
import org.anyline.jdbc.run.BasicRun;
import org.anyline.jdbc.run.Run;
import org.anyline.jdbc.run.RunValue;
import org.anyline.jdbc.run.TableRun;
import org.anyline.jdbc.run.TextRun;
import org.anyline.jdbc.run.XMLRun;
import org.anyline.service.AnylineService;
import org.anyline.util.AdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public abstract class SimpleJDBCAdapter
implements JDBCAdapter {
    protected static final Logger log = LoggerFactory.getLogger(SimpleJDBCAdapter.class);
    @Autowired(required=false)
    protected PrimaryCreater primaryCreater;
    @Autowired(required=false)
    protected JdbcTemplate jdbc;
    @Autowired(required=false)
    @Qualifier(value="anyline.service")
    protected AnylineService service;
    public String delimiterFr = "";
    public String delimiterTo = "";

    @Override
    public JDBCAdapter.DB_TYPE type() {
        return null;
    }

    @Override
    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    @Override
    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    public void setDelimiter(String delimiter) {
        if (BasicUtil.isNotEmpty((Object)delimiter)) {
            if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 1) {
                this.delimiterFr = delimiter;
                this.delimiterTo = delimiter;
            } else {
                this.delimiterFr = delimiter.substring(0, 1);
                this.delimiterTo = delimiter.substring(1, 2);
            }
        }
    }

    @Override
    public void setJdbc(JdbcTemplate jdbc) {
        this.jdbc = jdbc;
    }

    @Override
    public Run buildInsertRun(String dest, Object obj, boolean checkPrimary, List<String> columns) {
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceHolder.parseDataSource(dest, obj);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (list.size() > 0) {
                return this.createInsertRunFromCollection(dest, list, checkPrimary, columns);
            }
            return null;
        }
        return this.createInsertRunFromEntity(dest, obj, checkPrimary, columns);
    }

    @Override
    public void createInserts(Run run, String dest, DataSet set, List<String> keys) {
    }

    @Override
    public void createInserts(Run run, String dest, Collection list, List<String> keys) {
    }

    @Override
    public List<String> confirmInsertColumns(String dest, Object obj, List<String> columns) {
        List<String> keys = null;
        if (null == obj) {
            return new ArrayList<String>();
        }
        boolean each = true;
        ArrayList<String> mastKeys = new ArrayList<String>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        if (null != columns && columns.size() > 0) {
            each = false;
            keys = new ArrayList<String>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    mastKeys.add(column);
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                keys.add(column);
            }
        }
        if (each) {
            boolean isInsertNullColumn = false;
            boolean isInsertEmptyColumn = false;
            DataRow row = null;
            if (obj instanceof DataRow) {
                row = (DataRow)obj;
                mastKeys.addAll(row.getUpdateColumns());
                ignores.addAll(row.getIgnoreUpdateColumns());
                keys = row.keys();
                isInsertNullColumn = row.isInsertNullColumn();
                isInsertEmptyColumn = row.isInsertEmptyColumn();
            } else {
                isInsertNullColumn = ConfigTable.IS_INSERT_NULL_COLUMN;
                isInsertEmptyColumn = ConfigTable.IS_INSERT_EMPTY_COLUMN;
                if (AdapterProxy.hasAdapter()) {
                    keys = AdapterProxy.columns(obj.getClass());
                } else {
                    keys = new ArrayList();
                    List fields = ClassUtil.getFields(obj.getClass());
                    for (Field field : fields) {
                        Class<?> clazz = field.getType();
                        if (clazz != String.class && clazz != java.util.Date.class && !ClassUtil.isPrimitiveClass(clazz)) continue;
                        keys.add(field.getName());
                    }
                }
            }
            BeanUtil.removeAll(ignores, columns);
            BeanUtil.removeAll(keys, ignores);
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (mastKeys.contains(key)) continue;
                Object value = null;
                value = null != row ? row.get(key) : (AdapterProxy.hasAdapter() ? BeanUtil.getFieldValue((Object)obj, (Field)AdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key));
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isInsertNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isInsertEmptyColumn) continue;
                keys.remove(i);
            }
        }
        keys = this.checkMetadata(dest, keys);
        keys = BeanUtil.distinct(keys);
        return keys;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.put(row.getPrimaryKey(), value);
        } else if (AdapterProxy.hasAdapter()) {
            String key = AdapterProxy.primaryKey(obj.getClass());
            Field field = AdapterProxy.field(obj.getClass(), (String)key);
            BeanUtil.setFieldValue((Object)obj, (Field)field, (Object)value);
        }
    }

    protected Run createInsertRunFromEntity(String dest, Object obj, boolean checkPrimary, List<String> columns) {
        return null;
    }

    protected Run createInsertRunFromCollection(String dest, Collection list, boolean checkPrimary, List<String> columns) {
        return null;
    }

    @Override
    public String generatedKey() {
        return null;
    }

    @Override
    public Run buildUpdateRun(String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceHolder.parseDataSource(null, obj);
        }
        if (obj instanceof DataRow) {
            return this.buildUpdateRunFromDataRow(dest, (DataRow)obj, configs, checkPrimary, columns);
        }
        return this.buildUpdateRunFromObject(dest, obj, configs, checkPrimary, columns);
    }

    protected Run buildUpdateRunFromObject(String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return null;
    }

    protected Run buildUpdateRunFromDataRow(String dest, DataRow row, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        return null;
    }

    public List<String> checkMetadata(String table, List<String> columns) {
        if (!ConfigTable.IS_AUTO_CHECK_METADATA || null == this.service) {
            return columns;
        }
        ArrayList<String> list = new ArrayList<String>();
        List metadatas = this.service.columns(table);
        metadatas = BeanUtil.toUpperCase(metadatas);
        for (String item : columns) {
            if (!metadatas.contains(item.toUpperCase())) continue;
            list.add(item);
        }
        return list;
    }

    protected List<String> confirmUpdateColumns(String dest, DataRow row, ConfigStore configs, List<String> columns) {
        ArrayList<String> keys = null;
        if (null == row) {
            return new ArrayList<String>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        List masters = BeanUtil.copy((Collection)row.getUpdateColumns());
        List ignores = BeanUtil.copy((Collection)row.getIgnoreUpdateColumns());
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll((List)ignores, columns);
        if (null != columns && columns.size() > 0) {
            each = false;
            keys = new ArrayList();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1, column.length());
                    masters.add(column);
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1, column.length());
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1, column.length());
                    factKeys.add(column);
                    each = true;
                }
                keys.add(column);
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            keys = masters;
        }
        if (each) {
            keys = row.keys();
            for (String k : masters) {
                if (keys.contains(k)) continue;
                keys.add(k);
            }
            boolean isUpdateNullColumn = row.isUpdateNullColumn();
            boolean isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            BeanUtil.removeAll(keys, (List)ignores);
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (masters.contains(key)) continue;
                Object value = row.get(key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                keys.remove(i);
            }
        }
        keys.removeAll(ignores);
        keys = this.checkMetadata(dest, keys);
        keys = BeanUtil.distinct(keys);
        return keys;
    }

    @Override
    public Run buildQueryRun(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof TablePrepare) {
            run = new TableRun(this, prepare.getTable());
        } else if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setStrict(prepare.isStrict());
            run.setAdapter(this);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addConditions(conditions);
            run.init();
            this.buildQueryRunContent(run);
        }
        return run;
    }

    @Override
    public void buildQueryRunContent(Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.buildQueryRunContent(r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.buildQueryRunContent(r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.buildQueryRunContent(r);
            }
        }
    }

    protected void buildQueryRunContent(XMLRun run) {
    }

    protected void buildQueryRunContent(TextRun run) {
    }

    protected void buildQueryRunContent(TableRun run) {
    }

    @Override
    public List<Map<String, Object>> process(List<Map<String, Object>> list) {
        return list;
    }

    @Override
    public Run buildExecuteRunSQL(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setAdapter(this);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addConditions(conditions);
            run.init();
        }
        return run;
    }

    @Override
    public String parseExists(Run run) {
        return null;
    }

    @Override
    public String parseTotalQuery(Run run) {
        return null;
    }

    @Override
    public Run buildDeleteRunSQL(String table, String key, Object values) {
        return this.createDeleteRunSQLFromTable(table, key, values);
    }

    @Override
    public Run buildDeleteRunSQL(String dest, Object obj, String ... columns) {
        if (null == obj) {
            return null;
        }
        Run run = null;
        if (null == dest) {
            dest = DataSourceHolder.parseDataSource(dest, obj);
        }
        if (null == dest) {
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (AdapterProxy.hasAdapter()) {
                dest = AdapterProxy.table(entity.getClass());
            }
        }
        if (obj instanceof ConfigStore) {
            run = new TableRun(this, dest);
            SimpleTablePrepare prepare = new SimpleTablePrepare();
            prepare.setDataSource(dest);
            run.setPrepare(prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addConditions(columns);
            run.init();
            this.buildDeleteRunContent(run);
        } else {
            run = this.createDeleteRunSQLFromEntity(dest, obj, columns);
        }
        return run;
    }

    @Override
    public Run buildDeleteRunContent(Run run) {
        if (null != run && run instanceof TableRun) {
            TableRun r = (TableRun)run;
            return this.buildDeleteRunContent(r);
        }
        return run;
    }

    protected Run buildDeleteRunContent(TableRun run) {
        return null;
    }

    protected Run createDeleteRunSQLFromTable(String table, String key, Object values) {
        return null;
    }

    protected Run createDeleteRunSQLFromEntity(String dest, Object obj, String ... columns) {
        return null;
    }

    @Override
    public List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryTableRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Table> tables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, DataSet set)"), (int)37));
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, Table> tables(boolean create, String catalog, String schema, LinkedHashMap<String, Table> tables, ResultSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String tableName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            Table table = tables.get(tableName.toUpperCase());
            if (null == table) {
                if (!create) continue;
                table = new Table();
                tables.put(tableName.toUpperCase(), table);
            }
            table.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
            table.setName(tableName);
            table.setType(this.string(keys, "TABLE_TYPE", set));
            table.setComment(this.string(keys, "REMARKS", set));
            table.setTypeCat(this.string(keys, "TYPE_CAT", set));
            table.setTypeName(this.string(keys, "TYPE_NAME", set));
            table.setSelfReferencingColumn(this.string(keys, "SELF_REFERENCING_COL_NAME", set));
            table.setRefGeneration(this.string(keys, "REF_GENERATION", set));
            tables.put(tableName.toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryMasterTableRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, ResultSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String tableName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            MasterTable table = tables.get(tableName.toUpperCase());
            if (null == table) {
                if (!create) continue;
                table = new MasterTable(tableName);
                tables.put(tableName.toUpperCase(), table);
            }
            table.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
            table.setType(this.string(keys, "TABLE_TYPE", set));
            table.setComment(this.string(keys, "REMARKS", set));
            table.setTypeCat(this.string(keys, "TYPE_CAT", set));
            table.setTypeName(this.string(keys, "TYPE_NAME", set));
            table.setSelfReferencingColumn(this.string(keys, "SELF_REFERENCING_COL_NAME", set));
            table.setRefGeneration(this.string(keys, "REF_GENERATION", set));
            tables.put(tableName.toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, MasterTable> mtables(int index, boolean create, String catalog, String schema, LinkedHashMap<String, MasterTable> tables, DataSet set)"), (int)37));
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryPartitionTableRunSQL(String catalog, String schema, String pattern, String types)"), (int)37));
        return null;
    }

    @Override
    public List<String> buildQueryPartitionTableRunSQL(MasterTable master) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryPartitionTableRunSQL(MasterTable master)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> ptables(int index, boolean create, MasterTable table, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set)"), (int)37));
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public LinkedHashMap<String, PartitionTable> ptables(boolean create, String catalog, MasterTable master, String schema, LinkedHashMap<String, PartitionTable> tables, ResultSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String tableName = this.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = this.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            PartitionTable table = tables.get(tableName.toUpperCase());
            if (null == table) {
                if (!create) continue;
                table = new PartitionTable(tableName);
                tables.put(tableName.toUpperCase(), table);
            }
            table.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), catalog}));
            table.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), schema}));
            table.setType(this.string(keys, "TABLE_TYPE", set));
            table.setComment(this.string(keys, "REMARKS", set));
            table.setTypeCat(this.string(keys, "TYPE_CAT", set));
            table.setTypeName(this.string(keys, "TYPE_NAME", set));
            table.setSelfReferencingColumn(this.string(keys, "SELF_REFERENCING_COL_NAME", set));
            table.setRefGeneration(this.string(keys, "REF_GENERATION", set));
            tables.put(tableName.toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public List<String> buildQueryColumnRunSQL(Table table, boolean metadata) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryColumnRunSQL(Table table, boolean metadata)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Column> columns(int index, boolean create, Table table, LinkedHashMap<String, Column> columns, DataSet set)"), (int)37));
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        return columns;
    }

    @Override
    public LinkedHashMap<String, Column> columns(boolean create, Table table, LinkedHashMap<String, Column> columns, SqlRowSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        SqlRowSetMetaData rsm = set.getMetaData();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            Column column;
            String name = rsm.getColumnName(i);
            if (BasicUtil.isEmpty((Object)name) || null != (column = columns.get(name.toUpperCase())) || !create) continue;
            column = this.column(column, rsm, i);
            columns.put(column.getName().toUpperCase(), column);
        }
        return columns;
    }

    @Override
    public LinkedHashMap<String, Column> columns(boolean create, Table table, LinkedHashMap<String, Column> columns, ResultSet set) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        while (set.next()) {
            String remark;
            String name = set.getString("COLUMN_NAME");
            if (null == name) continue;
            Column column = columns.get(name.toUpperCase());
            if (null == column) {
                if (!create) continue;
                column = new Column(name);
                columns.put(name.toUpperCase(), column);
            }
            if ("TAG".equals(remark = this.string(keys, "REMARKS", set, column.getComment()))) {
                column = new Tag();
            }
            column.setName(name);
            column.setComment(remark);
            column.setCatalog(this.string(keys, "TABLE_CAT", set, table.getCatalog()));
            column.setSchema(this.string(keys, "TABLE_SCHEM", set, table.getSchema()));
            column.setTableName(this.string(keys, "TABLE_NAME", set, table.getName()));
            column.setType(this.integer(keys, "DATA_TYPE", set, column.getType()));
            column.setType(this.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
            column.setTypeName(this.string(keys, "TYPE_NAME", set, column.getTypeName()));
            column.setPrecision(this.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
            column.setScale(this.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
            column.setNullable(this.bool(keys, "NULLABLE", set, column.isNullable()));
            column.setDefaultValue(this.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
            column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
            column.setAutoIncrement(this.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
            this.column(column, set);
        }
        return columns;
    }

    protected Column column(Column column, SqlRowSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
        }
        try {
            column.setCatalog((String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)}));
            column.setSchema((String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)}));
            column.setClassName(rsm.getColumnClassName(index));
            column.setCaseSensitive(rsm.isCaseSensitive(index));
            column.setCurrency(rsm.isCurrency(index));
            column.setComment(rsm.getColumnLabel(index));
            column.setName(rsm.getColumnName(index));
            column.setPrecision(rsm.getPrecision(index));
            column.setScale(rsm.getScale(index));
            column.setDisplaySize(rsm.getColumnDisplaySize(index));
            column.setSigned(rsm.isSigned(index));
            column.setTableName(rsm.getTableName(index));
            column.setType(rsm.getColumnType(index));
            column.setTypeName(rsm.getColumnTypeName(index));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return column;
    }

    protected Column column(Column column, ResultSet rs) {
        if (null == column) {
            column = new Column();
        }
        try {
            Map<String, Integer> keys = this.keys(rs);
            column.setScale(BasicUtil.parseInt((Object)this.string(keys, "DECIMAL_DIGITS", rs), null));
            column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            column.setAutoIncrement(BasicUtil.parseBoolean((Object)this.string(keys, "IS_AUTOINCREMENT", rs), (Boolean)false));
            column.setGenerated(BasicUtil.parseBoolean((Object)this.string(keys, "IS_GENERATEDCOLUMN", rs), (Boolean)false));
            column.setComment(this.string(keys, "REMARKS", rs));
            column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            if (BasicUtil.isEmpty((Object)column.getDefaultValue())) {
                column.setDefaultValue(this.string(keys, "COLUMN_DEF", rs));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return column;
    }

    protected Map<String, Integer> keys(ResultSet set) throws Exception {
        ResultSetMetaData rsmd = set.getMetaData();
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        if (null != rsmd) {
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                keys.put(rsmd.getColumnName(i).toUpperCase(), i);
            }
        }
        return keys;
    }

    @Override
    public List<String> buildQueryTagRunSQL(Table table, boolean metadata) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryTagRunSQL(Table table, boolean metadata)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Tag> tags(int index, boolean create, Table table, LinkedHashMap<String, Tag> tags, DataSet set)"), (int)37));
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, SqlRowSet set)"), (int)37));
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, ResultSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Tag> tags(boolean create, Table table, LinkedHashMap<String, Tag> tags, ResultSet set)"), (int)37));
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public List<String> buildQueryIndexRunSQL(Table table, boolean metadata) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryIndexRunSQL(Table table, boolean metadata)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Index> indexs(int index, boolean create, Table table, LinkedHashMap<String, Index> indexs, DataSet set)"), (int)37));
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, SqlRowSet set)"), (int)37));
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public LinkedHashMap<String, Index> indexs(boolean create, Table table, LinkedHashMap<String, Index> indexs, ResultSet set) throws Exception {
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        Map<String, Integer> keys = this.keys(set);
        LinkedHashMap<String, Column> columns = null;
        while (set.next()) {
            String name = this.string(keys, "INDEX_NAME", set);
            if (null == name) continue;
            Index index = indexs.get(name.toUpperCase());
            if (null == index) {
                if (!create) continue;
                index = new Index();
                indexs.put(name.toUpperCase(), index);
                index.setName(this.string(keys, "INDEX_NAME", set));
                index.setType(this.integer(keys, "TYPE", set, null));
                index.setUnique(this.bool(keys, "NON_UNIQUE", set, false) == false);
                index.setCatalog((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_CAT", set), table.getCatalog()}));
                index.setSchema((String)BasicUtil.evl((Object[])new String[]{this.string(keys, "TABLE_SCHEM", set), table.getSchema()}));
                index.setTable(this.string(keys, "TABLE_NAME", set));
                indexs.put(name, index);
                columns = new LinkedHashMap();
                index.setColumns(columns);
            } else {
                columns = index.getColumns();
            }
            String columnName = this.string(keys, "COLUMN_NAME", set);
            Column col = table.getColumn(columnName.toUpperCase());
            Column column = null;
            if (null != col) {
                column = (Column)col.clone();
            } else {
                column = new Column();
                column.setName(columnName);
            }
            String order = this.string(keys, "ASC_OR_DESC", set);
            order = null != order && order.startsWith("D") ? "DESC" : "ASC";
            column.setOrder(order);
            column.setPosition(this.integer(keys, "ORDINAL_POSITION", set, null));
            columns.put(column.getName().toUpperCase(), column);
        }
        return indexs;
    }

    @Override
    public List<String> buildQueryConstraintRunSQL(Table table, boolean metadata) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildQueryConstraintRunSQL(Table table, boolean metadata)"), (int)37));
        return null;
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(int constraint, boolean create, Table table, LinkedHashMap<String, Constraint> constraints, DataSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint> constraints(int constraint, boolean create,  Table table, LinkedHashMap<String, Constraint> constraints, DataSet set)"), (int)37));
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, SqlRowSet set)"), (int)37));
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint> constraints(boolean create, Table table, LinkedHashMap<String, Constraint> constraints, ResultSet set)"), (int)37));
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public String buildCreateRunSQL(Table table) throws Exception {
        Collection<Column> columns;
        StringBuilder builder = new StringBuilder();
        table.setCreater(this);
        builder.append("CREATE ").append(table.getKeyword()).append(" ");
        this.checkTableExists(builder, false);
        this.name(builder, table);
        LinkedHashMap<String, Column> columMap = table.getColumns();
        if (null != columMap && null != (columns = columMap.values()) && columns.size() > 0) {
            builder.append("(\n");
            int idx = 0;
            for (Column column : columns) {
                builder.append("\t");
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.define(builder, column).append("\n");
                ++idx;
            }
            builder.append("\t");
            this.primary(builder, table);
            builder.append(")");
        }
        this.comment(builder, table);
        return builder.toString();
    }

    @Override
    public String buildAlterRunSQL(Table table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAlterRunSQL(Table table)"), (int)37));
        return null;
    }

    @Override
    public String buildRenameRunSQL(Table table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildRenameRunSQL(Table table)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeCommentRunSQL(Table table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeCommentRunSQL(Table table)"), (int)37));
        return null;
    }

    @Override
    public String buildDropRunSQL(Table table) throws Exception {
        table.setCreater(this);
        StringBuilder builder = new StringBuilder();
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        builder.append("DROP ").append(table.getKeyword()).append(" ");
        this.checkTableExists(builder, true);
        this.name(builder, table);
        return builder.toString();
    }

    @Override
    public StringBuilder checkTableExists(StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    @Override
    public StringBuilder primary(StringBuilder builder, Table table) {
        List<Column> pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            int idx = 0;
            for (Column pk : pks) {
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                ++idx;
            }
            builder.append(")");
        }
        return builder;
    }

    @Override
    public StringBuilder comment(StringBuilder builder, Table table) {
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT'").append(comment).append("'");
        }
        return builder;
    }

    @Override
    public StringBuilder name(StringBuilder builder, Table table) {
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String name = table.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder;
    }

    @Override
    public String buildCreateRunSQL(MasterTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildCreateRunSQL(MasterTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildAlterRunSQL(MasterTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAlterRunSQL(MasterTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildDropRunSQL(MasterTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildDropRunSQL(MasterTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildRenameRunSQL(MasterTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildRenameRunSQL(MasterTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeCommentRunSQL(MasterTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeCommentRunSQL(MasterTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildCreateRunSQL(PartitionTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildCreateRunSQL(PartitionTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildAlterRunSQL(PartitionTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAlterRunSQL(PartitionTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildDropRunSQL(PartitionTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildDropRunSQL(PartitionTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildRenameRunSQL(PartitionTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildRenameRunSQL(PartitionTable table)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeCommentRunSQL(PartitionTable table) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeCommentRunSQL(PartitionTable table)"), (int)37));
        return null;
    }

    @Override
    public String alterColumnKeyword() {
        return "ALTER";
    }

    @Override
    public String buildAddRunSQL(Column column) throws Exception {
        column.setCreater(this);
        StringBuilder builder = new StringBuilder();
        Table table = column.getTable();
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" ADD ").append(column.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, column);
        return builder.toString();
    }

    @Override
    public List<String> buildAlterRunSQL(Column column) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        Column update = column.getUpdate();
        if (null != update) {
            String sql;
            String ucomment;
            String comment;
            String sql2;
            int unullable;
            int nullable;
            String sql3;
            Object udef;
            Object def;
            List<String> list;
            String sql4;
            column.setCreater(this);
            update.setCreater(this);
            String name = column.getName();
            String uname = update.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)uname) && !uname.endsWith("_TMP_UPDATE_TYPE") && null != (sql4 = this.buildRenameRunSQL(column))) {
                sqls.add(sql4);
            }
            column.setName(uname);
            String type = this.type2type(column.getTypeName());
            String utype = this.type2type(update.getTypeName());
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype) && null != (list = this.buildChangeTypeRunSQL(column))) {
                sqls.addAll(list);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(def = column.getDefaultValue()), (Object)(udef = update.getDefaultValue())) && null != (sql3 = this.buildChangeDefaultRunSQL(column))) {
                sqls.add(sql3);
            }
            if ((nullable = column.isNullable()) != (unullable = update.isNullable()) && null != (sql2 = this.buildChangeNullableRunSQL(column))) {
                sqls.add(sql2);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = column.getComment()), (Object)(ucomment = update.getComment())) && null != (sql = this.buildChangeCommentRunSQL(column))) {
                sqls.add(sql);
            }
        }
        return sqls;
    }

    @Override
    public String buildDropRunSQL(Column column) throws Exception {
        if (column instanceof Tag) {
            Tag tag = (Tag)column;
            return this.buildDropRunSQL(tag);
        }
        column.setCreater(this);
        StringBuilder builder = new StringBuilder();
        Table table = column.getTable();
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" DROP ").append(column.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    @Override
    public String buildRenameRunSQL(Column column) throws Exception {
        column.setCreater(this);
        StringBuilder builder = new StringBuilder();
        Table table = column.getTable();
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" RENAME ").append(column.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    @Override
    public List<String> buildChangeTypeRunSQL(Column column) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildChangeTypeRunSQL(Column column)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeDefaultRunSQL(Column column) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeDefaultRunSQL(Column column)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeNullableRunSQL(Column column) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeNullableRunSQL(Column column)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeCommentRunSQL(Column column) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeCommentRunSQL(Column column)"), (int)37));
        return null;
    }

    @Override
    public StringBuilder define(StringBuilder builder, Column column) {
        this.type(builder, column);
        this.charset(builder, column);
        this.defaultValue(builder, column);
        this.increment(builder, column);
        this.nullable(builder, column);
        this.onupdate(builder, column);
        this.comment(builder, column);
        this.position(builder, column);
        return builder;
    }

    @Override
    public StringBuilder type(StringBuilder builder, Column column) {
        builder.append(this.type2type(column.getTypeName()));
        Integer precision = column.getPrecision();
        Integer scale = column.getScale();
        if (null != precision) {
            if (precision > 0) {
                builder.append("(").append(precision);
                if (null != scale && scale > 0) {
                    builder.append(",").append(scale);
                }
                builder.append(")");
            } else if (precision == -1) {
                builder.append("(max)");
            }
        }
        return builder;
    }

    @Override
    public StringBuilder nullable(StringBuilder builder, Column column) {
        int nullable;
        if (column.isNullable() == 0 && (nullable = column.isNullable()) != -1) {
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(StringBuilder builder, Column column) {
        String charset = column.getCharset();
        if (BasicUtil.isNotEmpty((Object)charset)) {
            builder.append(" CHARACTER SET ").append(charset);
            String collate = column.getCollate();
            if (BasicUtil.isNotEmpty((Object)collate)) {
                builder.append(" COLLATE ").append(collate);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder defaultValue(StringBuilder builder, Column column) {
        Object def = column.getDefaultValue();
        if (null != def) {
            builder.append(" DEFAULT ");
            boolean isCharColumn = this.isCharColumn(column);
            if (def instanceof JDBCAdapter.SQL_BUILD_IN_VALUE) {
                String value = this.buildInValue((JDBCAdapter.SQL_BUILD_IN_VALUE)((Object)def));
                if (null != value) {
                    builder.append(value);
                }
            } else {
                this.format(builder, def);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder increment(StringBuilder builder, Column column) {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder increment(StringBuilder builder, Column column)"), (int)37));
        return builder;
    }

    @Override
    public StringBuilder onupdate(StringBuilder builder, Column column) {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder onupdate(StringBuilder builder, Column column)"), (int)37));
        return builder;
    }

    @Override
    public StringBuilder position(StringBuilder builder, Column column) {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder position(StringBuilder builder, Column column)"), (int)37));
        return builder;
    }

    @Override
    public StringBuilder comment(StringBuilder builder, Column column) {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder comment(StringBuilder builder, Column column)"), (int)37));
        return builder;
    }

    @Override
    public StringBuilder checkColumnExists(StringBuilder builder, boolean exists) {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 checkColumnExists(StringBuilder builder, boolean exists)"), (int)37));
        return builder;
    }

    @Override
    public String buildAddRunSQL(Tag tag) throws Exception {
        tag.setCreater(this);
        StringBuilder builder = new StringBuilder();
        Table table = tag.getTable();
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" ADD TAG ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(builder, tag);
        return builder.toString();
    }

    @Override
    public List<String> buildAlterRunSQL(Tag tag) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        Tag update = tag.getUpdate();
        if (null != update) {
            String sql;
            String ucomment;
            String comment;
            String sql2;
            int unullable;
            int nullable;
            String sql3;
            Object udef;
            Object def;
            List<String> list;
            String sql4;
            tag.setCreater(this);
            update.setCreater(this);
            String name = tag.getName();
            String uname = update.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)uname) && !uname.endsWith("_TMP_UPDATE_TYPE") && null != (sql4 = this.buildRenameRunSQL(tag))) {
                sqls.add(sql4);
            }
            tag.setName(uname);
            String type = this.type2type(tag.getTypeName());
            String utype = this.type2type(update.getTypeName());
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype) && null != (list = this.buildChangeTypeRunSQL(tag))) {
                sqls.addAll(list);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(def = tag.getDefaultValue()), (Object)(udef = update.getDefaultValue())) && null != (sql3 = this.buildChangeDefaultRunSQL(tag))) {
                sqls.add(sql3);
            }
            if ((nullable = tag.isNullable()) != (unullable = update.isNullable()) && null != (sql2 = this.buildChangeNullableRunSQL(tag))) {
                sqls.add(sql2);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = tag.getComment()), (Object)(ucomment = update.getComment())) && null != (sql = this.buildChangeCommentRunSQL(tag))) {
                sqls.add(sql);
            }
        }
        return sqls;
    }

    @Override
    public String buildDropRunSQL(Tag tag) throws Exception {
        tag.setCreater(this);
        StringBuilder builder = new StringBuilder();
        Table table = tag.getTable();
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" DROP ").append(tag.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    @Override
    public String buildRenameRunSQL(Tag tag) throws Exception {
        tag.setCreater(this);
        StringBuilder builder = new StringBuilder();
        Table table = tag.getTable();
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(builder, table);
        builder.append(" RENAME ").append(tag.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder.toString();
    }

    @Override
    public String buildChangeDefaultRunSQL(Tag tag) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeDefaultRunSQL(Tag tag)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeNullableRunSQL(Tag tag) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeNullableRunSQL(Tag tag)"), (int)37));
        return null;
    }

    @Override
    public String buildChangeCommentRunSQL(Tag tag) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildChangeCommentRunSQL(Tag tag)"), (int)37));
        return null;
    }

    @Override
    public List<String> buildChangeTypeRunSQL(Tag tag) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildChangeTypeRunSQL(Tag tag)"), (int)37));
        return null;
    }

    @Override
    public StringBuilder checkTagExists(StringBuilder builder, boolean exists) {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder checkTagExists(StringBuilder builder, boolean exists)"), (int)37));
        return builder;
    }

    @Override
    public String buildAddRunSQL(Index index) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAddRunSQL(Index index)"), (int)37));
        return null;
    }

    @Override
    public List<String> buildAlterRunSQL(Index index) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAddRunSQL(Index index)"), (int)37));
        return null;
    }

    @Override
    public String buildDropRunSQL(Index index) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAddRunSQL(Index index)"), (int)37));
        return null;
    }

    @Override
    public String buildRenameRunSQL(Index index) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAddRunSQL(Index index)"), (int)37));
        return null;
    }

    @Override
    public String buildAddRunSQL(Constraint constraint) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildAddRunSQL(Constraint constraint)"), (int)37));
        return null;
    }

    @Override
    public List<String> buildAlterRunSQL(Constraint constraint) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> buildAlterRunSQL(Constraint constraint)"), (int)37));
        return null;
    }

    @Override
    public String buildDropRunSQL(Constraint constraint) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildDropRunSQL(Constraint constraint)"), (int)37));
        return null;
    }

    @Override
    public String buildRenameRunSQL(Constraint constraint) throws Exception {
        log.warn(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String buildRenameRunSQL(Constraint constraint)"), (int)37));
        return null;
    }

    @Override
    public boolean isBooleanColumn(Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("boolean") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).equals("bit") || type.equals("bool"));
    }

    @Override
    public boolean isNumberColumn(Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("int") || clazz.contains("integer") || clazz.contains("long") || clazz.contains("decimal") || clazz.contains("float") || clazz.contains("double") || clazz.contains("timestamp") || clazz.contains("short") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).contains("int") || type.contains("float") || type.contains("double") || type.contains("short") || type.contains("long") || type.contains("decimal") || type.contains("numeric") || type.contains("timestamp"));
    }

    @Override
    public boolean isCharColumn(Column column) {
        return !this.isNumberColumn(column) && !this.isBooleanColumn(column);
    }

    @Override
    public String buildInValue(JDBCAdapter.SQL_BUILD_IN_VALUE value) {
        return null;
    }

    @Override
    public String type2type(String type) {
        return type;
    }

    @Override
    public String type2class(String type) {
        return type;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set, String def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return value.toString();
        }
        return def;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.string(keys, key, set, null);
    }

    protected Integer integer(Map<String, Integer> keys, String key, ResultSet set, Integer def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseInt((Object)value, (Integer)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, Boolean def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseBoolean((Object)value, (Boolean)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, int def) throws Exception {
        Boolean defaultValue = null;
        if (def == 0) {
            defaultValue = false;
        } else if (def == 1) {
            defaultValue = true;
        }
        return this.bool(keys, key, set, defaultValue);
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set, Object def) throws Exception {
        Integer index = keys.get(key);
        if (null != index) {
            return set.getObject(index);
        }
        return def;
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.value(keys, key, set, null);
    }

    @Override
    public void value(StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (AdapterProxy.hasAdapter()) {
            Field field = AdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key);
        }
        this.format(builder, value);
    }

    @Override
    public void format(StringBuilder builder, Object value) {
        if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
            builder.append("null");
        } else if (value instanceof JDBCAdapter.SQL_BUILD_IN_VALUE) {
            builder.append(this.buildInValue((JDBCAdapter.SQL_BUILD_IN_VALUE)((Object)value)));
        } else if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith("${") && str.endsWith("}")) {
                str = str.substring(2, str.length() - 1);
            } else if (!str.startsWith("'") || !str.endsWith("'")) {
                str = "'" + str.replace("'", "''") + "'";
            }
            builder.append(str);
        } else if (value instanceof Timestamp) {
            builder.append("'").append(value.toString()).append("'");
        } else if (value instanceof Date) {
            builder.append("'").append(value.toString()).append("'");
        } else if (value instanceof LocalDate) {
            builder.append("'").append(value.toString()).append("'");
        } else if (value instanceof LocalTime) {
            builder.append("'").append(value.toString()).append("'");
        } else if (value instanceof LocalDateTime) {
            builder.append("'").append(value.toString()).append("'");
        } else if (value instanceof java.util.Date) {
            builder.append("'").append(DateUtil.format((java.util.Date)((java.util.Date)value), (String)"yyyy-MM-dd HH:mm:ss")).append("'");
        } else if (value instanceof Number || value instanceof Boolean) {
            builder.append(value.toString());
        } else {
            builder.append(value.toString());
        }
    }

    @Override
    public String getPrimaryKey(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryKey();
        }
        return null;
    }

    @Override
    public Object getPrimaryValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryValue();
        }
        return null;
    }

    public String parseTable(String table) {
        if (null == table) {
            return table;
        }
        table = table.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), "");
        if ((table = DataSourceHolder.parseDataSource(table, null)).contains(".")) {
            String[] tmps = table.split("\\.");
            table = SQLUtil.delimiter((String)tmps[0], (String)this.getDelimiterFr(), (String)this.getDelimiterTo()) + "." + SQLUtil.delimiter((String)tmps[1], (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        } else {
            table = SQLUtil.delimiter((String)table, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        return table;
    }

    @Override
    public boolean convert(String catalog, String schema, String table, RunValue run) {
        boolean result = false;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap<String, Column> columns = this.service.metadata().columns(catalog, schema, table);
            result = this.convert(columns, run);
        }
        return result;
    }

    @Override
    public boolean convert(Map<String, Column> columns, RunValue value) {
        boolean result = false;
        if (null != columns && null != value) {
            Column meta = columns.get(value.getKey().toUpperCase());
            result = this.convert(meta, value);
        }
        return result;
    }

    @Override
    public boolean convert(Column column, RunValue run) {
        if (null == column) {
            return false;
        }
        if (null == run) {
            return true;
        }
        Object value = run.getValue();
        if (null == value) {
            return true;
        }
        try {
            String clazz = column.getClassName();
            String typeName = column.getTypeName().toUpperCase();
            if (null != typeName) {
                if (typeName.equals("UUID")) {
                    if (!(value instanceof UUID)) {
                        run.setValue(UUID.fromString(value.toString()));
                    }
                    return true;
                }
                if (typeName.contains("CHAR") || typeName.contains("TEXT")) {
                    if (!(value instanceof String)) {
                        if (value instanceof java.util.Date) {
                            run.setValue(DateUtil.format((java.util.Date)((java.util.Date)value)));
                        } else {
                            run.setValue(value.toString());
                        }
                    }
                    return true;
                }
                if (typeName.equals("BIT")) {
                    if ("0".equals(value.toString()) || "false".equalsIgnoreCase(value.toString())) {
                        run.setValue("0");
                    } else {
                        run.setValue("1");
                    }
                    return true;
                }
                if (typeName.equals("DATETIME")) {
                    if (!(value instanceof Timestamp) && !(value instanceof java.util.Date)) {
                        java.util.Date date = DateUtil.parse((Object)value);
                        if (null != date) {
                            run.setValue(new Timestamp(date.getTime()));
                        } else {
                            run.setValue(null);
                        }
                    }
                    return true;
                }
                if (typeName.equals("DATE")) {
                    if (!(value instanceof Date)) {
                        java.util.Date date = DateUtil.parse((Object)value);
                        if (null != date) {
                            run.setValue(new Date(date.getTime()));
                        } else {
                            run.setValue(null);
                        }
                    }
                    return true;
                }
                if (typeName.equals("TIME")) {
                    if (!(value instanceof Time)) {
                        java.util.Date date = DateUtil.parse((Object)value);
                        if (null != date) {
                            run.setValue(new Time(date.getTime()));
                        } else {
                            run.setValue(null);
                        }
                    }
                    return true;
                }
            }
            if (null != clazz) {
                if (clazz.contains("Integer")) {
                    if (!(value instanceof Integer)) {
                        run.setValue(BasicUtil.parseInt((Object)value, null));
                    }
                    return true;
                }
                if (clazz.contains("Long")) {
                    if (!(value instanceof Long)) {
                        run.setValue(BasicUtil.parseLong((Object)value, null));
                    }
                    return true;
                }
                if (clazz.contains("Double")) {
                    if (!(value instanceof Double)) {
                        run.setValue(BasicUtil.parseDouble((Object)value, null));
                    }
                    return true;
                }
                if (clazz.contains("Float")) {
                    if (!(value instanceof Float)) {
                        run.setValue(BasicUtil.parseFloat((Object)value, null));
                    }
                    return true;
                }
                if (clazz.contains("BigDecimal")) {
                    if (!(value instanceof BigDecimal)) {
                        run.setValue(BasicUtil.parseDecimal((Object)value, null));
                    }
                    return true;
                }
                if (clazz.contains("java.sql.Timestamp")) {
                    if (!(value instanceof Timestamp)) {
                        java.util.Date date = DateUtil.parse((Object)value);
                        if (null != date) {
                            run.setValue(new Timestamp(date.getTime()));
                        } else {
                            run.setValue(null);
                        }
                    }
                    return true;
                }
                if (clazz.equals("java.sql.Time")) {
                    if (!(value instanceof Time)) {
                        java.util.Date date = DateUtil.parse((Object)value);
                        if (null != date) {
                            run.setValue(new Time(date.getTime()));
                        } else {
                            run.setValue(null);
                        }
                    }
                    return true;
                }
                if (clazz.contains("java.sql.Date")) {
                    if (!(value instanceof Date)) {
                        java.util.Date date = DateUtil.parse((Object)value);
                        if (null != date) {
                            run.setValue(new Date(date.getTime()));
                        } else {
                            run.setValue(null);
                        }
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

