/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.cache;

import java.util.Hashtable;
import java.util.List;
import org.anyline.entity.DataRow;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.jdbc.param.Config;
import org.anyline.jdbc.param.ConfigChain;
import org.anyline.jdbc.param.ConfigStore;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.MD5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtil {
    private static final Logger log = LoggerFactory.getLogger(CacheUtil.class);
    private static Hashtable<String, Long> reflushFlag = new Hashtable();

    public static boolean start(String key, int sec) {
        boolean result = false;
        Long fr = reflushFlag.get(key);
        long age = -1L;
        if (null == fr) {
            result = true;
        } else {
            age = (System.currentTimeMillis() - fr) / 1000L;
            if (age > (long)sec) {
                result = true;
            }
        }
        if (result) {
            reflushFlag.put(key, System.currentTimeMillis());
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[\u9891\u7387\u63a7\u5236\u653e\u884c][key:{}][\u95f4\u9694:{}/{}]", new Object[]{key, age, sec});
            }
        } else if (ConfigTable.isDebug() && log.isWarnEnabled()) {
            log.warn("[\u9891\u7387\u63a7\u5236\u62e6\u622a][key:{}][\u95f4\u9694:{}/{}]", new Object[]{key, age, sec});
        }
        return result;
    }

    public static boolean start(String key) {
        int period = ConfigTable.getInt((String)key, (int)120);
        return CacheUtil.start(key, period);
    }

    public static void stop(String key, int sec) {
        Long fr = reflushFlag.get(key);
        if (null == fr) {
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[\u9891\u7387\u63a7\u5236\u8fd8\u539f\u5b8c\u6210 \u6709\u53ef\u80fdkey\u62fc\u5199\u6709\u8bef][key:{}]", (Object)key);
            }
            return;
        }
        long age = (System.currentTimeMillis() - fr) / 1000L;
        if (age > (long)sec) {
            reflushFlag.remove(key);
        }
        if (ConfigTable.isDebug() && log.isWarnEnabled()) {
            log.warn("[\u9891\u7387\u63a7\u5236\u8fd8\u539f\u5b8c\u6210][key:{}][\u95f4\u9694:{}/{}]", new Object[]{key, age, sec});
        }
    }

    public static void stop(String key) {
        int period = ConfigTable.getInt((String)key, (int)120);
        CacheUtil.stop(key, period);
    }

    public static boolean isRun(String key) {
        return null != reflushFlag.get(key);
    }

    public static long getRunTime(String key) {
        long result = -1L;
        Long fr = reflushFlag.get(key);
        if (null != fr) {
            return System.currentTimeMillis() - fr;
        }
        return result;
    }

    public static String crateCachePrimaryKey(String table, DataRow row) {
        String key = table;
        List pks = row.getPrimaryKeys();
        if (BasicUtil.isNotEmpty((Object)pks) && null != row) {
            for (String pk : pks) {
                String value = row.getString(pk);
                key = key + "|" + pk + "=" + value;
            }
        }
        return key;
    }

    public static String createCacheElementKey(boolean page, boolean order, String src, ConfigStore store, String ... conditions) {
        conditions = BasicUtil.compressionSpace((String[])conditions);
        String result = src + "|";
        if (null != store) {
            OrderStore orders;
            List<Config> configs;
            ConfigChain chain = store.getConfigChain();
            if (null != chain && null != (configs = chain.getConfigs())) {
                for (Config config : configs) {
                    List<Object> values = config.getValues();
                    if (null == values) continue;
                    result = result + config.toString() + "|";
                }
            }
            PageNavi navi = store.getPageNavi();
            if (page && null != navi) {
                result = result + "page=" + navi.getCurPage() + "|first=" + navi.getFirstRow() + "|last=" + navi.getLastRow() + "|";
            }
            if (order && null != (orders = store.getOrders())) {
                result = result + orders.getRunText("").toUpperCase() + "|";
            }
        }
        if (null != conditions) {
            for (String condition : conditions) {
                if (!BasicUtil.isNotEmpty((Object)condition)) continue;
                if (condition.trim().toUpperCase().startsWith("ORDER")) {
                    if (!order) continue;
                    result = result + condition.toUpperCase() + "|";
                    continue;
                }
                result = result + condition + "|";
            }
        }
        if (ConfigTable.isDebug() && log.isWarnEnabled()) {
            log.warn("[create cache key][key:{}]", (Object)result);
        }
        return MD5Util.crypto((String)result);
    }
}

