/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.run.AbstractRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class TextRun
extends AbstractRun
implements Run {
    protected boolean supportSqlVarPlaceholderRegexExt = true;

    public TextRun() {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orders = new DefaultOrderStore();
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        this.setText(prepare.getText());
        return this;
    }

    @Override
    public void init() {
        List<Condition> conditions;
        super.init();
        if (null != this.conditionChain && null != (conditions = this.conditionChain.getConditions())) {
            for (Condition condition : conditions) {
                if (null == condition || !(condition instanceof AutoCondition)) continue;
                AutoCondition auto = (AutoCondition)condition;
                List<Variable> vars = this.getVariables(auto.getId());
                if (!vars.isEmpty()) {
                    auto.setVariableSlave(true);
                    for (Variable var : vars) {
                        var.setValue(false, auto.getValues());
                    }
                    continue;
                }
                this.setConditionValue(auto.getSwt(), auto.getCompare(), auto.getId(), null, auto.getValues());
            }
        }
        if (null != this.configs) {
            List<Object> vars;
            List<Config> confs = this.configs.getConfigChain().getConfigs();
            for (Config config : confs) {
                boolean overCondition = config.isOverCondition();
                boolean overValue = config.isOverValue();
                List<Object> values = config.getValues();
                Compare compare = config.getCompare();
                String varKey = config.getVariable();
                List<Variable> vars2 = this.getVariables(varKey);
                boolean isUse = false;
                if (overCondition) {
                    List<Condition> cons = this.getConditions(varKey);
                    Iterator iterator = cons.iterator();
                    while (iterator.hasNext()) {
                        boolean isConVarSetValue;
                        Condition con = (Condition)iterator.next();
                        if (null == con) continue;
                        boolean bl = isConVarSetValue = con.isSetValue() || con.isSetValue(varKey);
                        if (isConVarSetValue && !overValue) continue;
                        isUse = true;
                        con.setVariableSlave(true);
                        this.setConditionValue(config.getSwt(), config.getCompare(), varKey, varKey, values);
                    }
                }
                for (Variable var : vars2) {
                    if (!overValue && var.isSetValue()) continue;
                    isUse = true;
                    var.setValue(false, values);
                }
                if (compare == Compare.NONE || isUse) continue;
                this.conditionChain.addCondition(config.createAutoCondition(this.conditionChain));
            }
            LinkedHashMap<String, Config> params = this.configs.params();
            for (String key : params.keySet()) {
                Config conf = params.get(key);
                vars = this.getVariables(key);
                boolean overCondition = conf.isOverCondition();
                boolean overValue = conf.isOverValue();
                List<Object> values = conf.getValues();
                for (Variable var : vars) {
                    if (!overValue && var.isSetValue()) continue;
                    var.setValue(false, values);
                }
                if (!overCondition) continue;
                List<Condition> cons = this.getConditions(key);
                for (Condition con : cons) {
                    boolean isConVarSetValue;
                    if (null == con) continue;
                    boolean bl = isConVarSetValue = con.isSetValue() || con.isSetValue(key);
                    if (isConVarSetValue && !overValue) continue;
                    con.setVariableSlave(true);
                    this.setConditionValue(conf.getSwt(), conf.getCompare(), key, key, values);
                }
            }
            List<Object> list = this.configs.values();
            if (null != list) {
                int i = 0;
                int len = list.size();
                vars = this.variables;
                if (null == vars) {
                    vars = new ArrayList();
                }
                if (vars.isEmpty()) {
                    vars = this.conditionChain.getVariables();
                }
                for (Variable var : vars) {
                    if (i >= len) break;
                    var.setValue(list.get(i));
                    ++i;
                }
            }
            this.add(this.configs.getOrders());
            PageNavi navi = this.configs.getPageNavi();
            if (navi != null) {
                this.pageNavi = navi;
            }
        }
    }

    @Override
    public boolean checkValid() {
        if (!this.valid) {
            return false;
        }
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
        if (null != this.configs && !this.configs.isValid()) {
            this.valid = false;
        }
        return this.valid;
    }

    public void appendGroup(DataRuntime runtime, Boolean placeholder, Boolean unicode) {
        String txt;
        if (null != this.configs) {
            if (null == this.groups) {
                this.groups = this.configs.getGroups();
            }
            if (this.having.isEmptyCondition()) {
                this.having = this.configs.having();
            }
        }
        if (null != this.groups) {
            this.builder.append("\n").append(this.groups.getRunText(this.delimiterFr + this.delimiterTo));
        }
        if (null != this.having && BasicUtil.isNotEmpty((Object)(txt = SQLUtil.trim((String)this.having.getRunText(runtime, false, unicode))))) {
            this.builder.append("\nHAVING ").append(txt);
        }
    }

    public void appendCondition(Boolean placeholder, Boolean unicode) {
        if (null == this.conditionChain) {
            return;
        }
        List<Condition> cons = this.conditionChain.getConditions();
        if (null == cons || cons.isEmpty()) {
            return;
        }
        String txt = this.builder.toString();
        String condition = this.conditionChain.getRunText(null, this.runtime, placeholder, (Boolean)false);
        boolean where = TextRun.endWithWhere(txt);
        if (BasicUtil.isNotEmpty((Object)condition)) {
            this.emptyCondition = false;
            if (!where) {
                this.builder.append("\nWHERE ");
                condition = SQLUtil.trim((String)condition);
            }
            this.builder.append(condition);
        }
        if (where) {
            this.emptyCondition = false;
        }
        this.addValues(this.conditionChain.getRunValues());
    }

    public void setConfigs(ConfigStore configs) {
        this.configs = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String condition, String variable, Object value) {
        if (!this.variables.isEmpty() && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    public TextRun addValues(String key, Object obj) {
        if (null == obj) {
            return this;
        }
        if (null == this.values) {
            this.values = new ArrayList();
        }
        if (null != obj && obj instanceof RunValue) {
            throw new RuntimeException("run value");
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                this.addValues(key, item);
            }
        } else {
            this.addValues(new RunValue(key, obj));
        }
        return this;
    }

    @Override
    public Run add(OrderStore orders) {
        this.orders.add(orders);
        return this;
    }

    @Override
    public Run add(Order order) {
        this.orders.add(order);
        return this;
    }

    public Run addCondition(String condition, String variable, Object value) {
        if (!this.variables.isEmpty() && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    public Run addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value) {
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, prefix, var, value);
        if (null == this.conditionChain) {
            this.conditionChain = new DefaultAutoConditionChain();
        }
        this.conditionChain.addCondition(condition);
        return this;
    }

    @Override
    public Variable getVariable(String key) {
        if (null == key) {
            return null;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            return var;
        }
        return null;
    }

    public List<Variable> getVariables(String key) {
        ArrayList<Variable> list = new ArrayList<Variable>();
        if (null == key) {
            return list;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            list.add(var);
        }
        for (Condition condition : this.conditionChain.getConditions()) {
            Variable var = condition.getVariable(key);
            if (null == var) continue;
            list.add(var);
        }
        return list;
    }

    public boolean supportSqlVarPlaceholderRegexExt() {
        return this.supportSqlVarPlaceholderRegexExt;
    }

    public void supportSqlVarPlaceholderRegexExt(boolean supportSqlVarPlaceholderRegexExt) {
        this.supportSqlVarPlaceholderRegexExt = supportSqlVarPlaceholderRegexExt;
    }
}

