/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoPrepare;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.init.AbstractRunPrepare;
import org.anyline.entity.Compare;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;

public abstract class DefaultAutoPrepare
extends AbstractRunPrepare
implements AutoPrepare {
    protected String datasoruce;
    protected Catalog catalog;
    protected Schema schema;
    protected Table table;
    protected String alias;

    public DefaultAutoPrepare() {
        this.chain = new DefaultAutoConditionChain();
    }

    @Override
    public RunPrepare init() {
        return this;
    }

    @Override
    public RunPrepare setDest(String table) {
        if (null == table) {
            return this;
        }
        this.table = new Table(table);
        this.parseTable(this.table);
        return this;
    }

    @Override
    public RunPrepare setDest(Table table) {
        if (null == table) {
            return this;
        }
        this.table = table;
        this.parseTable(this.table);
        return this;
    }

    @Override
    public RunPrepare addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String column, Object value) {
        if (null == this.chain) {
            this.chain = new DefaultAutoConditionChain();
        }
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, null, column, value);
        this.chain.addCondition(condition);
        return this;
    }

    @Override
    public RunPrepare addCondition(String condition) {
        if (BasicUtil.isEmpty((Object)condition)) {
            return this;
        }
        if (condition.contains(":")) {
            ParseResult parser = ConfigParser.parse(condition, false);
            List<Object> value = ConfigParser.getValues(parser);
            this.addCondition(parser.getSwt(), parser.getCompare(), parser.getVar(), value);
        } else {
            DefaultAutoCondition con = new DefaultAutoCondition(condition);
            this.chain.addCondition(con);
        }
        return this;
    }

    @Override
    public RunPrepare addColumn(String columns) {
        if (BasicUtil.isEmpty((Object)columns)) {
            return this;
        }
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        if (columns.contains(",")) {
            this.parseMultiColumns(false, columns);
        } else if (columns.startsWith("!")) {
            this.excludeColumn(columns.substring(1));
        } else {
            this.columns.put(columns.toUpperCase(), new Column(columns));
        }
        return this;
    }

    @Override
    public RunPrepare addColumn(Column column) {
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName().toUpperCase(), column);
        return this;
    }

    @Override
    public RunPrepare excludeColumn(String columns) {
        if (BasicUtil.isEmpty((Object)columns)) {
            return this;
        }
        if (null == this.excludes) {
            this.excludes = new ArrayList();
        }
        if (columns.contains(",")) {
            this.parseMultiColumns(true, columns);
        } else if (!this.excludes.contains(columns)) {
            this.excludes.add(columns);
        }
        return this;
    }

    protected void parseMultiColumns(boolean exclude, String src) {
        ArrayList<String> cols = new ArrayList<String>();
        while (src.contains("${")) {
            src = src.trim();
            int fr = src.indexOf("${");
            String tmp = "";
            if (0 == fr) {
                tmp = src.substring(0, src.indexOf("}") + 1);
                src = src.substring(src.indexOf("}") + 1);
            } else {
                tmp = src.substring(0, fr);
                src = src.substring(fr);
            }
            cols.add(tmp);
        }
        cols.add(src);
        for (String c : cols) {
            String[] cs;
            if (c.contains("${")) {
                if (exclude) {
                    this.excludeColumn(c);
                    continue;
                }
                this.addColumn(c);
                continue;
            }
            for (String item : cs = c.split(",")) {
                if ((item = item.trim()).length() <= 0) continue;
                this.addColumn(item);
            }
        }
    }

    public void parseTable(Table table) {
        if (null != table) {
            String[] tmps;
            String alias;
            String catalog = null;
            String schema = null;
            String name = table.getName();
            if (BasicUtil.isEmpty((Object)name)) {
                name = table.getText();
            }
            if (BasicUtil.isNotEmpty((Object)(alias = table.getAlias()))) {
                this.setAlias(alias);
            }
            this.groups = table.groups();
            List list = table.having();
            if (null != list) {
                for (String item : list) {
                    this.having.and(item);
                }
            }
            this.aggregations = table.aggregations();
            if (BasicUtil.isNotEmpty((Object)table.getAlias())) {
                this.alias = table.getAlias();
            }
            if (name.startsWith("<")) {
                this.datasoruce = name.substring(1, name.indexOf(">"));
                name = name.substring(name.indexOf(">") + 1);
            }
            String tag = " as ";
            String lower = name.toLowerCase();
            int tagIdx = lower.lastIndexOf(tag);
            if (tagIdx > 0 && !name.substring(tagIdx + tag.length()).contains(")")) {
                alias = name.substring(tagIdx + tag.length()).trim();
                name = name.substring(0, tagIdx).trim();
            }
            if (name.contains("(")) {
                String colStr = name.substring(name.indexOf("(") + 1, name.lastIndexOf(")")).trim();
                if (colStr.toLowerCase().startsWith("distinct")) {
                    this.distinct = "distinct";
                    colStr = colStr.substring(9).trim();
                }
                this.parseColumn(colStr);
                name = name.substring(0, name.indexOf("("));
            }
            if (null != name && name.contains(".")) {
                String[] tbs = name.split("\\.");
                if (tbs.length == 2) {
                    schema = tbs[0];
                    name = tbs[1];
                } else if (tbs.length == 3) {
                    catalog = tbs[0];
                    schema = tbs[1];
                    name = tbs[2];
                }
            }
            if (name.contains(" ") && !(tmps = name.split(" "))[0].contains("(")) {
                name = tmps[0];
                alias = tmps[1];
            }
            if (null != catalog) {
                table.setCatalog(catalog);
                this.catalog = new Catalog(catalog);
            }
            if (null != schema) {
                table.setSchema(schema);
                this.schema = new Schema(schema);
            }
            if (BasicUtil.isNotEmpty((Object)alias)) {
                table.setAlias(alias);
            }
            if (BasicUtil.isNotEmpty((Object)name)) {
                table.setName(name);
            }
        }
    }

    private void parseColumn(String sql) {
        if (BasicUtil.isEmpty((Object)sql)) {
            return;
        }
        if (sql.contains("${")) {
            while (sql.contains("${")) {
                String pre = (sql = sql.trim()).substring(0, sql.indexOf("${"));
                if (BasicUtil.isNotEmpty((Object)pre)) {
                    String[] pres;
                    for (String item : pres = pre.split(",")) {
                        item = item.trim();
                        this.addColumn(item);
                    }
                }
                int fr = sql.indexOf("${");
                int to = sql.indexOf("}");
                String col = sql.substring(fr + 2, to).trim();
                this.addColumn(col);
                sql = sql.substring(sql.indexOf("}") + 1).trim();
            }
        } else {
            String[] cols;
            for (String item : cols = sql.split(",")) {
                item = item.trim();
                this.addColumn(item);
            }
        }
    }

    @Override
    public String getDest() {
        String dest = null;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.getTableName();
        if (BasicUtil.isNotEmpty((Object)catalogName)) {
            dest = catalogName;
        }
        if (BasicUtil.isNotEmpty((Object)schemaName)) {
            dest = null == dest ? schemaName : dest + "." + schemaName;
        }
        if (BasicUtil.isNotEmpty((Object)tableName)) {
            dest = null == dest ? tableName : dest + "." + tableName;
        }
        return dest;
    }

    @Override
    public RunPrepare setCatalog(Catalog catalog) {
        this.catalog = catalog;
        return this;
    }

    @Override
    public RunPrepare setCatalog(String catalog) {
        this.catalog = BasicUtil.isNotEmpty((Object)catalog) ? new Catalog(catalog) : null;
        return this;
    }

    @Override
    public RunPrepare setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public String getCatalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        return null;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getSchemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        return null;
    }

    @Override
    public RunPrepare setSchema(String schema) {
        this.schema = BasicUtil.isNotEmpty((Object)schema) ? new Schema(schema) : null;
        return this;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public String getTableName() {
        if (null != this.table) {
            return this.table.getName();
        }
        return null;
    }

    @Override
    public RunPrepare setTable(String table) {
        if (BasicUtil.isNotEmpty((Object)table)) {
            this.table = new Table(table);
            this.parseTable(this.table);
        } else {
            this.table = null;
        }
        return this;
    }

    @Override
    public RunPrepare setTable(Table table) {
        this.table = table;
        this.parseTable(this.table);
        return this;
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.chain;
    }

    @Override
    public void createRunText(StringBuilder builder) {
    }

    @Override
    public String getDistinct() {
        return this.distinct;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List<Variable> getSQLVariables() {
        return null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public RunPrepare setAlias(String alias) {
        this.alias = alias;
        return this;
    }
}

