/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.init.AbstractConditionChain;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class DefaultAutoConditionChain
extends AbstractConditionChain
implements ConditionChain {
    private static String TAB = "\t";
    private static String BR = "\n";

    public DefaultAutoConditionChain() {
    }

    public DefaultAutoConditionChain(ConfigChain chain) {
        if (null == chain) {
            return;
        }
        for (Config config : chain.getConfigs()) {
            if (config instanceof ConfigChain) {
                this.conditions.add(new DefaultAutoConditionChain((ConfigChain)config).setJoin(config.getJoin()));
                continue;
            }
            this.conditions.add(new DefaultAutoCondition(config).setJoin(config.getJoin()));
        }
        this.integrality(chain.integrality());
    }

    private void tab(int lvl, boolean br, StringBuilder builder) {
        if (br) {
            builder.append(BR);
        }
        for (int i = 0; i < lvl; ++i) {
            builder.append(TAB);
        }
    }

    @Override
    public String getRunText(int lvl, String prefix, DataRuntime runtime, Boolean placeholder, Boolean unicode) {
        this.runValues = new ArrayList();
        int size = this.conditions.size();
        int active = 0;
        if (size == 0) {
            return "";
        }
        StringBuilder subBuilder = new StringBuilder();
        String txt = "";
        for (int i = 0; i < size; ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (null == condition || condition.isVariableSlave() || BasicUtil.isEmpty((Object)(txt = condition.getRunText(lvl + 1, prefix, runtime, placeholder, unicode)))) continue;
            ++active;
            List<RunValue> values = condition.getRunValues();
            if (condition.getVariableType() != 2 && BasicUtil.isEmpty((boolean)true, values) && !condition.isActive() && condition.getSwt() != Compare.EMPTY_VALUE_SWITCH.NULL && condition.getSwt() != Compare.EMPTY_VALUE_SWITCH.SRC) continue;
            txt = SQLUtil.trim((String)txt);
            if (this.joinSize > 0) {
                if (txt.startsWith("(")) {
                    this.tab(lvl + 1, true, subBuilder);
                }
                subBuilder.append(condition.getJoinText());
            }
            if (subBuilder.length() > 0 && !txt.startsWith(" ") && !txt.startsWith("(")) {
                subBuilder.append(" ");
            }
            subBuilder.append(txt);
            this.addRunValue(values);
            ++this.joinSize;
        }
        if (this.joinSize > 0) {
            StringBuilder builder = new StringBuilder();
            if (!this.hasContainer() || this.getContainerJoinSize() > 0) {
                builder.append("\n").append((Object)this.join).append(" ");
            } else {
                builder.append("\n\t");
            }
            String sub = SQLUtil.trim((String)subBuilder.toString());
            if (this.integrality && active > 1) {
                builder.append("(");
            }
            builder.append(sub);
            if (this.integrality && active > 1) {
                builder.append(")");
            }
            builder.append("\n\t");
            return builder.toString().replaceAll("(\n\\s*\n+)", "\n");
        }
        return "";
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    private int getContainerJoinSize() {
        if (this.hasContainer()) {
            return this.getContainer().getJoinSize();
        }
        return 0;
    }

    public String toString() {
        int size = this.conditions.size();
        String txt = "[";
        for (int i = 0; i < size; ++i) {
            txt = i == 0 ? txt + ((Condition)this.conditions.get(i)).toString() : txt + "," + ((Condition)this.conditions.get(i)).toString();
        }
        txt = txt + "]";
        return txt;
    }
}

