/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.entity;

import java.io.Serializable;
import java.util.List;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.entity.DataRow;
import org.anyline.entity.OriginRow;

public class Join
implements Serializable {
    private TYPE type = TYPE.INNER;
    private ConfigStore conditions = new DefaultConfigStore(new String[0]);

    public ConfigStore getConditions() {
        return this.conditions;
    }

    public void setConditions(ConfigStore configs) {
        this.conditions = configs;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public Join addConditions(String ... conditions) {
        for (String condition : conditions) {
            this.conditions.and(condition);
        }
        return this;
    }

    public Join addConditions(List<String> conditions) {
        for (String condition : conditions) {
            this.conditions.and(condition);
        }
        return this;
    }

    public Join setConditions(String ... conditions) {
        this.conditions = new DefaultConfigStore(new String[0]);
        for (String condition : conditions) {
            this.conditions.and(condition);
        }
        return this;
    }

    public Join setConditions(List<String> conditions) {
        this.conditions = new DefaultConfigStore(new String[0]);
        for (String condition : conditions) {
            this.conditions.and(condition);
        }
        return this;
    }

    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        if (empty || null != this.type) {
            row.put("type", (Object)this.type.getCode());
        }
        row.put("conditions", (Object)this.conditions.getConfigChain().map(empty));
        return row;
    }

    public DataRow map() {
        return this.map(false);
    }

    public String json(boolean empty) {
        return this.map(empty).json();
    }

    public String json() {
        return this.json(false);
    }

    public static enum TYPE {
        INNER{

            @Override
            public String getCode() {
                return "INNER JOIN";
            }

            @Override
            public String getName() {
                return "\u5185\u8fde\u63a5";
            }
        }
        ,
        LEFT{

            @Override
            public String getCode() {
                return "LEFT JOIN";
            }

            @Override
            public String getName() {
                return "\u5de6\u8fde\u63a5";
            }
        }
        ,
        RIGHT{

            @Override
            public String getCode() {
                return "RIGHT JOIN";
            }

            @Override
            public String getName() {
                return "\u53f3\u8fde\u63a5";
            }
        }
        ,
        FULL{

            @Override
            public String getCode() {
                return "FULL JOIN";
            }

            @Override
            public String getName() {
                return "\u5168\u8fde\u63a5";
            }
        };


        public abstract String getName();

        public abstract String getCode();
    }
}

