/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.entity.Join;
import org.anyline.data.jdbc.adapter.init.AbstractJDBCAdapter;
import org.anyline.data.jdbc.adapter.init.alias.OracleGenusTypeMetadataAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.VirtualTablePrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.VariableValue;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.NotSupportException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.refer.MetadataReferHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.SQLUtil;

public abstract class OracleGenusAdapter
extends AbstractJDBCAdapter {
    private static Map<Type, String> types = new HashMap<Type, String>();

    public OracleGenusAdapter() {
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.CHAR, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TEXT, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BOOLEAN, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BYTES, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 0, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.BLOB, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INT, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.FLOAT, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", 1, 0, 0));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATE, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIME, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.DATETIME, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", 1, 1, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.TIMESTAMP, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", 1, 1, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.INTERVAL, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", 1, 2, 2));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.COLLECTION, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.GEOMETRY, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 1, 1, 1));
        MetadataReferHolder.reg((DatabaseType)this.type(), (TypeMetadata.CATEGORY)TypeMetadata.CATEGORY.OTHER, (TypeMetadata.Refer)new TypeMetadata.Refer("DATA_LENGTH", null, null, 1, 1, 1));
        for (OracleGenusTypeMetadataAlias alias : OracleGenusTypeMetadataAlias.values()) {
            this.reg(alias);
            this.alias(alias.name(), alias.standard());
        }
    }

    @Override
    public boolean supportCatalog() {
        return false;
    }

    @Override
    public boolean supportSchema() {
        return super.supportSchema();
    }

    @Override
    public String name(Type type) {
        return types.get(type);
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.insert(runtime, random, batch, dest, data, configs, columns);
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildInsertRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        if (null == set || set.isEmpty()) {
            return;
        }
        this.checkName(runtime, null, dest);
        StringBuilder builder = run.getBuilder();
        DataRow first = set.getRow(0);
        HashMap<String, Sequence> sequens = new HashMap<String, Sequence>();
        for (Column column : columns.values()) {
            String key = column.getName();
            String value = first.getStringNvl(key, new String[0]);
            if (null == value) continue;
            if (value instanceof String) {
                String str = value;
                if (!str.toUpperCase().contains(".NEXTVAL")) continue;
                if (BasicUtil.checkEl((String)str)) {
                    str = str.substring(2, str.length() - 1);
                }
                sequens.put(key, new Sequence(str));
                continue;
            }
            if (!(value instanceof Sequence)) continue;
            Sequence sequence = (Sequence)value;
            if (sequence.isFetchValueBeforeInsert()) {
                this.createPrimaryValue(runtime, (Collection)set, sequence);
                continue;
            }
            sequens.put(key, sequence);
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        LinkedHashMap pks = null;
        if (null != generator) {
            pks = first.getPrimaryColumns();
            columns.putAll(pks);
        }
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        String select = this.insertsSelect(runtime, run, dest, set, configs, columns, sequens, generator, (LinkedHashMap<String, Column>)pks);
        if (null == override) {
            builder.append("INSERT INTO ");
            this.name(runtime, builder, (Metadata)dest).append(" (");
            builder.append(this.concat("", ", ", Column.names(columns)));
            builder.append(") \n");
            builder.append(select);
        } else {
            this.merge(runtime, builder, dest, configs, select, columns, pks);
        }
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        if (null == list || list.isEmpty()) {
            return;
        }
        int batch = run.getBatch();
        StringBuilder builder = run.getBuilder();
        if (null == builder) {
            builder = new StringBuilder();
            run.setBuilder(builder);
        }
        this.checkName(runtime, null, dest);
        if (list instanceof DataSet) {
            DataSet set = (DataSet)list;
            this.fillInsertContent(runtime, run, dest, set, configs, placeholder, unicode, columns);
            return;
        }
        Object first = list.iterator().next();
        HashMap<String, Sequence> sequens = new HashMap<String, Sequence>();
        for (Column column : columns.values()) {
            String key = column.getName();
            Object value = BeanUtil.getFieldValue(first, (String)key, (boolean)true);
            if (null == value) continue;
            if (value instanceof String) {
                String str = (String)value;
                if (!str.toUpperCase().contains(".NEXTVAL")) continue;
                if (BasicUtil.checkEl((String)str)) {
                    str = str.substring(2, str.length() - 1);
                }
                sequens.put(key, new Sequence(str));
                continue;
            }
            if (!(value instanceof Sequence)) continue;
            Sequence sequence = (Sequence)value;
            if (sequence.isFetchValueBeforeInsert()) {
                this.createPrimaryValue(runtime, list, sequence);
                continue;
            }
            sequens.put(key, sequence);
        }
        PrimaryGenerator generator = this.checkPrimaryGenerator(this.type(), dest.getName());
        LinkedHashMap pks = null;
        if (null != generator) {
            pks = EntityAdapterProxy.primaryKeys(first.getClass());
            columns.putAll(pks);
        }
        String head = this.insertHead(configs);
        String select = this.insertsSelect(runtime, run, dest, list, configs, columns, sequens, generator, (LinkedHashMap<String, Column>)pks);
        Boolean override = null;
        if (null != configs) {
            override = configs.override();
        }
        if (null == override) {
            builder.append(head);
            this.name(runtime, builder, (Metadata)dest).append(" (");
            boolean start = true;
            for (Column column : columns.values()) {
                if (!start) {
                    builder.append(", ");
                }
                start = false;
                String key = column.getName();
                this.delimiter(builder, key);
            }
            builder.append(") \n");
            builder.append(select);
        } else {
            this.merge(runtime, builder, dest, configs, select, columns, pks);
        }
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        return super.confirmInsertColumns(runtime, dest, obj, configs, columns, batch);
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    @Override
    protected void setPrimaryValue(Object obj, Object value) {
        super.setPrimaryValue(obj, value);
    }

    @Override
    protected Run createInsertRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRun(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.createInsertRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    @Override
    public String generatedKey() {
        return super.generatedKey();
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        long cnt = 0L;
        if (data instanceof Collection) {
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            configs.supportKeyHolder(false);
            cnt = super.insert(runtime, random, data, configs, run, (String[])pks);
        } else {
            String pk = this.getPrimaryKey(data);
            pks = null != pk ? new String[]{pk} : null;
            cnt = super.insert(runtime, random, data, configs, run, (String[])pks);
        }
        return cnt;
    }

    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.update(runtime, random, batch, dest, data, configs, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return super.buildUpdateRun(runtime, batch, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromEntity(runtime, dest, obj, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromDataRow(runtime, dest, row, configs, placeholder, unicode, columns);
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return super.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, placeholder, unicode, columns);
    }

    public Run buildUpdateRun(DataRuntime runtime, RunPrepare prepare, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        Run run = this.initQueryRun(runtime, prepare);
        run.addCondition(conditions);
        if (run.checkValid()) {
            this.fillUpdateContent(runtime, (TableRun)run, data, configs, placeholder, unicode);
        }
        return run;
    }

    public void fillUpdateContent(DataRuntime runtime, TableRun run, StringBuilder builder, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        TablePrepare prepare = (TablePrepare)run.getPrepare();
        builder.append("UPDATE ");
        this.name(runtime, builder, (Metadata)prepare.getTable());
        String alias = prepare.getAlias();
        String masterName = prepare.getTableName();
        if (BasicUtil.isNotEmpty((Object)alias)) {
            builder.append(this.tableAliasGuidd());
            this.delimiter(builder, alias);
            masterName = alias;
        }
        builder.append(" SET ").append("\n").append("(");
        List keys = data.keys();
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            if (!key.contains(".")) {
                builder.append(masterName).append(".");
            }
            builder.append(key);
        }
        builder.append(") = ( SELECT ");
        first = true;
        for (String key : keys) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            Object value = data.get(key);
            if (value instanceof VariableValue) {
                VariableValue var = (VariableValue)value;
                this.delimiter(builder, var.value());
                continue;
            }
            builder.append("?");
            RunValue rv = new RunValue();
            rv.setValue(value);
            run.addValue(rv);
        }
        RunPrepare master = null;
        StringBuilder sub = new StringBuilder();
        List joins = prepare.getJoins();
        if (null != joins && !joins.isEmpty()) {
            master = (RunPrepare)joins.get(0);
            joins.remove(master);
            sub.append("\nFROM ");
            this.fillMasterTableContent(runtime, sub, run, master);
            if (joins.isEmpty()) {
                sub.append("\n");
            }
            for (RunPrepare join : joins) {
                this.fillJoinTableContent(runtime, sub, run, join);
            }
        }
        if (null != master) {
            Join join = master.getJoin();
            if (master instanceof VirtualTablePrepare) {
                join = ((VirtualTablePrepare)master).getPrepare().getJoin();
            }
            if (null != join) {
                String on = join.getConditions().getRunText(runtime, Boolean.valueOf(false));
                sub.append("WHERE ").append(SQLUtil.trim((String)on));
            }
        }
        builder.append(BasicUtil.tab((String)sub.toString(), (int)1));
        builder.append("\n)");
        this.init(runtime, (Run)run, configs, new String[0]);
        run.appendCondition(builder, (DriverAdapter)this, true, placeholder, unicode);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, row, configs, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return super.confirmUpdateColumns(runtime, dest, obj, configs, columns);
    }

    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return super.update(runtime, random, dest, data, configs, run);
    }

    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return super.save(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveCollection(DataRuntime runtime, String random, Table dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        return super.saveCollection(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected long saveObject(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return super.saveObject(runtime, random, dest, data, configs, columns);
    }

    @Override
    protected Boolean checkOverride(Object obj, ConfigStore configs) {
        return super.checkOverride(obj, configs);
    }

    @Override
    protected Boolean checkOverrideSync(Object obj, ConfigStore configs) {
        return super.checkOverrideSync(obj, configs);
    }

    @Override
    protected Map<String, Object> checkPv(Object obj) {
        return super.checkPv(obj);
    }

    @Override
    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        return super.isMultipleValue(runtime, run, key);
    }

    @Override
    protected boolean isMultipleValue(Column column) {
        return super.isMultipleValue(column);
    }

    @Override
    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, Table table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return super.checkMetadata(runtime, table, configs, columns);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.querys(runtime, random, prepare, configs, conditions);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        return super.querys(runtime, random, procedure, navi);
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return super.selects(runtime, random, prepare, clazz, configs, conditions);
    }

    @Override
    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, clazz, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.maps(runtime, random, prepare, configs, conditions);
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildQueryRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String key = "CURRVAL";
        if (next) {
            key = "NEXTVAL";
        }
        if (null != names && names.length > 0) {
            builder.append("SELECT ");
            boolean first = true;
            for (String name : names) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                this.delimiter(builder, name);
                builder.append(".").append(key).append(" AS ");
                this.delimiter(builder, name);
            }
            String dummy = this.dummy();
            if (BasicUtil.isNotEmpty((Object)dummy)) {
                builder.append(" FROM ").append(dummy);
            }
        }
        return runs;
    }

    @Override
    public Run fillQueryContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, XMLRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected Run fillQueryContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        return super.fillQueryContent(runtime, run, placeholder, unicode);
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return super.pageOffsetNext(runtime, run);
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        return super.createConditionLike(runtime, builder, compare, value, placeholder, unicode);
    }

    @Override
    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        return super.createConditionFindInSet(runtime, builder, column, compare, value, placeholder, unicode);
    }

    @Override
    public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        return super.createConditionIn(runtime, builder, compare, value, placeholder, unicode);
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, Table table, ConfigStore configs, Run run) {
        return super.select(runtime, random, system, table, configs, run);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.maps(runtime, random, configs, run);
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.map(runtime, random, configs, run);
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        return super.sequence(runtime, random, next, names);
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        return super.process(runtime, list);
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.count(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        return super.mergeFinalTotal(runtime, run);
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        return super.count(runtime, random, run);
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.exists(runtime, random, prepare, configs, conditions);
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        String sql = "SELECT 1 AS IS_EXISTS FROM DUAL WHERE  EXISTS(" + run.getBuilder().toString() + ")";
        sql = this.compressCondition(runtime, sql);
        return sql;
    }

    public Run buildQueryLengthRun(DataRuntime runtime, String cn, ConfigStore configs) {
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT LENGTHB('").append(cn).append("') AS CNT FROM DUAL");
        return run;
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return super.execute(runtime, random, prepare, configs, conditions);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, RunPrepare prepare, Collection<Object> values) {
        return super.execute(runtime, random, batch, configs, prepare, values);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        return super.execute(runtime, random, procedure);
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... conditions) {
        return super.buildExecuteRun(runtime, prepare, configs, placeholder, unicode, conditions);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        super.fillExecuteContent(runtime, run);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TextRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    protected void fillExecuteContent(DataRuntime runtime, TableRun run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        super.fillExecuteContent(runtime, run, placeholder, unicode);
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.execute(runtime, random, configs, run);
    }

    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String key, Collection<T> values) {
        return super.deletes(runtime, random, batch, table, configs, key, values);
    }

    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        return super.delete(runtime, random, dest, configs, obj, columns);
    }

    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return super.delete(runtime, random, table, configs, conditions);
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        return super.truncate(runtime, random, table);
    }

    @Override
    public List<Run> buildDeleteRun(DataRuntime runtime, Table dest, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRun(runtime, dest, configs, obj, placeholder, unicode, columns);
    }

    public List<Run> buildDeleteRun(DataRuntime runtime, int batch, String table, ConfigStore configs, Boolean placeholder, Boolean unicode, String key, Object values) {
        return super.buildDeleteRun(runtime, batch, table, configs, placeholder, unicode, key, values);
    }

    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return super.buildTruncateRun(runtime, table);
    }

    @Override
    public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, Boolean placeholder, Boolean unicode, String column, Object values) {
        return super.buildDeleteRunFromTable(runtime, batch, table, configs, placeholder, unicode, column, values);
    }

    @Override
    public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return super.buildDeleteRunFromEntity(runtime, table, configs, obj, placeholder, unicode, columns);
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run, Boolean placeholder, Boolean unicode) {
        super.fillDeleteRunContent(runtime, run, placeholder, unicode);
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        return super.delete(runtime, random, configs, run);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, Database query) {
        return super.databases(runtime, random, greedy, query);
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, Database query) {
        return super.databases(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, Database query) throws Exception {
        String name = query.getName();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT USERNAME DATABASE_NAME, CASE WHEN (USERNAME = USER) THEN 1 ELSE 0 END IS_CURRENT FROM SYS.ALL_USERS");
        return runs;
    }

    @Override
    public MetadataFieldRefer initDatabaseFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Database.class);
        refer.map("NAME", "DATABASE_NAME");
        return refer;
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, int index, boolean create, List<T> previous, Database query, DataSet set) throws Exception {
        return super.databases(runtime, index, create, previous, query, set);
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, Database meta, DataSet set) throws Exception {
        return super.database(runtime, index, create, meta, set);
    }

    @Override
    public Database database(DataRuntime runtime, boolean create, Database meta) throws Exception {
        return super.database(runtime, create, meta);
    }

    @Override
    public String product(DataRuntime runtime, int index, boolean create, String product, DataSet set) {
        return super.product(runtime, index, create, product, set);
    }

    @Override
    public String product(DataRuntime runtime, boolean create, String product) {
        return super.product(runtime, create, product);
    }

    @Override
    public String version(DataRuntime runtime, int index, boolean create, String version, DataSet set) {
        return super.version(runtime, index, create, version, set);
    }

    @Override
    public String version(DataRuntime runtime, boolean create, String version) {
        return super.version(runtime, create, version);
    }

    public <T extends Database> T init(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Database> T detail(DataRuntime runtime, int index, T meta, Database query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, Catalog query) {
        return super.catalogs(runtime, random, query);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, Catalog query) {
        return super.catalogs(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, Catalog query) throws Exception {
        return super.buildQueryCatalogsRun(runtime, greedy, query);
    }

    @Override
    public MetadataFieldRefer initCatalogFieldRefer() {
        return super.initCatalogFieldRefer();
    }

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog query, DataSet set) throws Exception {
        return super.catalogs(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, boolean create, List<T> previous) throws Exception {
        return super.catalogs(runtime, create, previous);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, Catalog meta, DataSet set) throws Exception {
        return super.catalog(runtime, index, create, meta, set);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, boolean create, Catalog meta) throws Exception {
        return super.catalog(runtime, create, meta);
    }

    public <T extends Catalog> T init(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Catalog> T detail(DataRuntime runtime, int index, T meta, Catalog query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        Schema schema = this.schema(runtime, random);
        if (null != schema) {
            return new Database(schema.getName());
        }
        return super.database(runtime, random);
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        return super.product(runtime, random);
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        return super.version(runtime, random);
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Schema query) {
        return super.schemas(runtime, random, query);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Schema query) {
        return super.schemas(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryProductRun(DataRuntime runtime) throws Exception {
        return super.buildQueryProductRun(runtime);
    }

    @Override
    public List<Run> buildQueryVersionRun(DataRuntime runtime) throws Exception {
        return super.buildQueryVersionRun(runtime);
    }

    @Override
    public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Schema query) throws Exception {
        return super.buildQuerySchemasRun(runtime, greedy, query);
    }

    @Override
    public MetadataFieldRefer initSchemaFieldRefer() {
        return super.initSchemaFieldRefer();
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, int index, boolean create, List<T> previous, Schema query, DataSet set) throws Exception {
        return super.schemas(runtime, index, create, previous, query, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, Schema meta, DataSet set) throws Exception {
        return super.schema(runtime, index, create, meta, set);
    }

    @Override
    public Schema schema(DataRuntime runtime, boolean create, Schema meta) throws Exception {
        return super.schema(runtime, create, meta);
    }

    public <T extends Schema> T init(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return (T)super.init(runtime, index, meta, query, row);
    }

    public <T extends Schema> T detail(DataRuntime runtime, int index, T meta, Schema query, DataRow row) {
        return (T)super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Table query, ConfigStore configs) {
        super.tableMap(runtime, random, greedy, query, configs);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Table query, int types, int struct, ConfigStore configs) {
        return super.tables(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Table query, int types, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime, configs);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.OWNER AS TABLE_SCHEMA, M.OBJECT_NAME AS TABLE_NAME, M.OBJECT_TYPE AS TABLE_TYPE, M.CREATED AS CREATE_TIME, M.LAST_DDL_TIME AS UPDATE_TIME, M.TEMPORARY AS IS_TEMPORARY, F.COMMENTS, M.STATUS\n");
        builder.append("FROM ALL_OBJECTS M LEFT JOIN ALL_TAB_COMMENTS F \n");
        builder.append("ON M.OBJECT_NAME = F.TABLE_NAME  AND M.OWNER = F.OWNER AND M.object_type = F.TABLE_TYPE \n");
        configs.and("M.OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "M.OBJECT_NAME", (Object)query.getName());
        List tps = this.names(Table.types((int)types));
        if (tps.isEmpty()) {
            tps.add("TABLE");
            tps.add("VIEW");
        }
        configs.in("M.OBJECT_TYPE", (Object)tps);
        return runs;
    }

    @Override
    public MetadataFieldRefer initTableFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Table.class);
        refer.map("NAME", "TABLE_NAME");
        refer.map("TYPE", "TABLE_TYPE");
        refer.map("SCHEMA", "TABLE_SCHEMA");
        refer.map("COMMENT", "COMMENTS");
        refer.map("CREATE_TIME", "CREATE_TIME");
        refer.map("UPDATE_TIME", "UPDATE_TIME");
        return refer;
    }

    @Override
    public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Table query, int types) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM ALL_TAB_COMMENTS M");
        configs.and("M.OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "M.TABLE_NAME", (Object)query.getName());
        return runs;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.tables(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.tables(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table query, int types) throws Exception {
        return super.tables(runtime, create, previous, query, types);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        return super.tables(runtime, create, previous, query, types);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> previous, Table query, DataSet set) throws Exception {
        return super.comments(runtime, index, create, previous, query, set);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        return super.ddl(runtime, random, table, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Table table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, View query, int types, int struct, ConfigStore configs) {
        return super.views(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, View query, int types, ConfigStore configs) throws Exception {
        return this.buildQueryTablesRun(runtime, greedy, (Table)query, types, configs);
    }

    @Override
    public MetadataFieldRefer initViewFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(View.class);
        refer.map("NAME", "VIEW_NAME,TABLE_NAME,NAME,TABNAME");
        refer.map("CATALOG", "VIEW_CATALOG,TABLE_CATALOG");
        refer.map("SCHEMA", "VIEW_SCHEMA,TABLE_SCHEMA,TABSCHEMA,SCHEMA_NAME");
        refer.map("DEFINITION", "DEFINITION_SQL");
        refer.map("COMMENT", "COMMENTS");
        return refer;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, View query, DataSet set) throws Exception {
        Catalog catalog = query.getCatalog();
        Schema schema = query.getSchema();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            String schemaName = row.getString("TABLE_SCHEMA");
            View view = (View)previous.get(name.toUpperCase());
            if (null == view) {
                view = new View();
            }
            view.setCatalog(catalog);
            view.setSchema(schemaName);
            view.setName(name);
            view.setComment(row.getString("COMMENTS"));
            view.setDefinition(row.getString("DEFINITION_SQL"));
            previous.put(name.toUpperCase(), view);
        }
        return previous;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, View query, int types) throws Exception {
        return super.views(runtime, create, previous, query, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        return super.ddl(runtime, random, view, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, View view) throws Exception {
        return super.buildQueryDdlRun(runtime, view);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, view, ddls, set);
    }

    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, MasterTable query, int types, int struct, ConfigStore configs) {
        return super.masters(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, MasterTable query, int types, ConfigStore configs) throws Exception {
        return super.buildQueryMasterTablesRun(runtime, greedy, query, types, configs);
    }

    @Override
    public MetadataFieldRefer initMasterTableFieldRefer() {
        return super.initMasterTableFieldRefer();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, MasterTable query, DataSet set) throws Exception {
        return super.masters(runtime, index, create, previous, query, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, MasterTable query, int types) throws Exception {
        return super.masters(runtime, create, previous, query, types);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable meta, boolean init) {
        return super.ddl(runtime, random, meta, init);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, PartitionTable query) {
        return super.partitions(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, PartitionTable query, int types) throws Exception {
        return super.buildQueryPartitionTablesRun(runtime, greedy, query, types);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, int total, int index, boolean create, LinkedHashMap<String, T> previous, PartitionTable query, DataSet set) throws Exception {
        return super.partitions(runtime, total, index, create, previous, query, set);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, PartitionTable query) throws Exception {
        return super.partitions(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        return super.ddl(runtime, random, table);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return super.buildQueryDdlRun(runtime, table);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, table, ddls, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, Column query, boolean primary, ConfigStore configs) {
        return super.columns(runtime, random, greedy, table, query, primary, configs);
    }

    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Column query, ConfigStore configs) {
        return super.columns(runtime, random, greedy, query, configs);
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Column query, ConfigStore configs) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (!metadata) {
            Run run = this.buildQueryColumnsBody(runtime, configs);
            runs.add(run);
            configs.and("M.OWNER", (Object)query.getSchemaName());
            configs.and(Compare.LIKE_SIMPLE, "M.TABLE_NAME", (Object)query.getTableName());
            run.setOrders(new String[]{"M.OWNER", "M.TABLE_NAME", "M.COLUMN_ID"});
            run.setPageNavi(configs.getPageNavi());
        }
        return runs;
    }

    @Override
    public List<Run> buildQueryColumnsRun(DataRuntime runtime, boolean metadata, Collection<? extends Table> tables, Column query, ConfigStore configs) throws Exception {
        String schema = query.getSchemaName();
        ArrayList<Run> runs = new ArrayList<Run>();
        Run run = this.buildQueryColumnsBody(runtime, configs);
        runs.add(run);
        configs.and("M.OWNER", (Object)schema);
        configs.in("M.TABLE_NAME", (Object)Table.names(tables));
        run.setOrders(new String[]{"M.OWNER", "M.TABLE_NAME", "M.COLUMN_ID"});
        return runs;
    }

    protected Run buildQueryColumnsBody(DataRuntime runtime, ConfigStore configs) {
        SimpleRun run = new SimpleRun(runtime, configs);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*, F.COMMENTS AS COLUMN_COMMENT , FP.CONSTRAINT_TYPE\nFROM ALL_TAB_COLUMNS M \nLEFT JOIN ALL_COL_COMMENTS F ON M.TABLE_NAME = F.TABLE_NAME AND M.COLUMN_NAME = F.COLUMN_NAME AND M.OWNER = F.OWNER\nLEFT JOIN (\n\tSELECT P.*, PC.COLUMN_NAME FROM USER_CONSTRAINTS P, USER_CONS_COLUMNS PC \n\tWHERE P.CONSTRAINT_NAME = PC.CONSTRAINT_NAME  AND P.CONSTRAINT_TYPE = 'P'\n)   FP ON M.OWNER = FP.OWNER AND M.TABLE_NAME = FP.TABLE_NAME AND M.COLUMN_NAME = FP.COLUMN_NAME");
        return run;
    }

    @Override
    public MetadataFieldRefer initColumnFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Column.class);
        refer.map("NAME", "COLUMN_NAME");
        refer.map("CATALOG", "");
        refer.map("SCHEMA", "OWNER");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("NULLABLE", "NULLABLE");
        refer.map("CHARSET", "");
        refer.map("COLLATE", "");
        refer.map("TYPE", "DATA_TYPE");
        refer.map("POSITION", "COLUMN_ID");
        refer.map("COMMENT", "COLUMN_COMMENT");
        refer.map("DEFAULT_VALUE", "DATA_DEFAULT");
        refer.map("PRIMARY_CHECK", "IS_PRIMARY");
        refer.map("PRIMARY_CHECK_VALUE", "P");
        return refer;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Table table, Column query, DataSet set) throws Exception {
        set.removeColumn(new String[]{"CHARACTER_SET_NAME"});
        return super.columns(runtime, index, create, previous, table, query, set);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, List<T> previous, Column query, DataSet set) throws Exception {
        return super.columns(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Column query) throws Exception {
        return super.columns(runtime, create, previous, query);
    }

    @Override
    public <T extends Column> T init(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Column> T detail(DataRuntime runtime, int index, T meta, Column query, DataRow row) {
        return super.detail(runtime, index, meta, query, row);
    }

    public TypeMetadata.Refer dataTypeMetadataRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.dataTypeMetadataRefer(runtime, meta);
    }

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table, Tag query) {
        return super.tags(runtime, random, greedy, table, query);
    }

    @Override
    public List<Run> buildQueryTagsRun(DataRuntime runtime, boolean greedy, Tag query) throws Exception {
        return super.buildQueryTagsRun(runtime, greedy, query);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Tag query, DataSet set) throws Exception {
        return super.tags(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Tag query) throws Exception {
        return super.tags(runtime, create, previous, query);
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, PrimaryKey query) {
        return super.primary(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy, PrimaryKey query) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT COL.* FROM USER_CONSTRAINTS CON, USER_CONS_COLUMNS COL\n");
        builder.append("WHERE CON.CONSTRAINT_NAME = COL.CONSTRAINT_NAME\n");
        builder.append("AND CON.CONSTRAINT_TYPE = 'P'\n");
        configs.and(Compare.LIKE_SIMPLE, "COL.TABLE_NAME", (Object)query.getTableName());
        configs.and("COL.OWNER", (Object)query.getSchemaName());
        return runs;
    }

    @Override
    public MetadataFieldRefer initPrimaryKeyFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(PrimaryKey.class);
        refer.map("NAME", "CONSTRAINT_NAME");
        refer.map("CATALOG", (String)null);
        refer.map("SCHEMA", "OWNER");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("COLUMN", "COLUMN_NAME");
        refer.map("POSITION", "POSITION");
        refer.map("ORDER", (String)null);
        return refer;
    }

    @Override
    public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T primary, PrimaryKey query, DataSet set) throws Exception {
        return super.init(runtime, index, primary, query, set);
    }

    @Override
    public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T primary, PrimaryKey query, DataSet set) throws Exception {
        return super.detail(runtime, index, primary, query, set);
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, PrimaryKey query) throws Exception {
        return super.primary(runtime, query);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, ForeignKey query) {
        return super.foreigns(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy, ForeignKey query) throws Exception {
        Table table = query.getTable();
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT UC.CONSTRAINT_NAME, UC.TABLE_NAME, KCU.COLUMN_NAME, UC.R_CONSTRAINT_NAME, RC.TABLE_NAME AS REFERENCED_TABLE_NAME, RCC.COLUMN_NAME AS REFERENCED_COLUMN_NAME, RCC.POSITION AS ORDINAL_POSITION\n");
        builder.append("FROM USER_CONSTRAINTS UC \n");
        builder.append("JOIN USER_CONS_COLUMNS KCU ON UC.CONSTRAINT_NAME = KCU.CONSTRAINT_NAME \n");
        builder.append("JOIN USER_CONSTRAINTS RC ON UC.R_CONSTRAINT_NAME = RC.CONSTRAINT_NAME \n");
        builder.append("JOIN USER_CONS_COLUMNS RCC ON RC.CONSTRAINT_NAME = RCC.CONSTRAINT_NAME AND KCU.POSITION = RCC.POSITION");
        configs.and("UC.OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "UC.TABLE_NAME", (Object)query.getTableName());
        return runs;
    }

    public MetadataFieldRefer initForeignKeyFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(ForeignKey.class);
        refer.map("NAME", "CONSTRAINT_NAME");
        refer.map("CATALOG", "");
        refer.map("SCHEMA", "REFERENCED_SCHEMA_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("COLUMN", "COLUMN_NAME");
        refer.map("COLUMN_POSITION", "ORDINAL_POSITION");
        refer.map("REFERENCE_CATALOG", "REFERENCED_CATALOG_NAME");
        refer.map("REFERENCE_SCHEMA", "REFERENCED_SCHEMA_NAME");
        refer.map("REFERENCE_TABLE", "REFERENCED_TABLE_NAME");
        refer.map("REFERENCE_COLUMN", "REFERENCED_COLUMN_NAME");
        return refer;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, LinkedHashMap<String, T> previous, ForeignKey query, DataSet set) throws Exception {
        return super.foreigns(runtime, index, previous, query, set);
    }

    @Override
    public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, ForeignKey query, DataRow row) throws Exception {
        return super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Index query) {
        return super.indexes(runtime, random, greedy, query);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Index query) {
        return super.indexes(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Index query) {
        Table table = query.getTable();
        String name = query.getName();
        ArrayList<Run> runs = new ArrayList<Run>();
        Run run = this.buildQueryIndexBody(runtime);
        runs.add(run);
        ConfigStore configs = run.getConfigs();
        configs.and("M.INDEX_OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "M.TABLE_NAME", (Object)query.getTableName());
        configs.and(Compare.LIKE_SIMPLE, "M.INDEX_NAME", (Object)query.getName());
        return runs;
    }

    @Override
    public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Collection<? extends Table> tables) {
        ArrayList<Run> runs = new ArrayList<Run>();
        Run run = this.buildQueryIndexBody(runtime);
        runs.add(run);
        ConfigStore configs = run.getConfigs();
        Table table = null;
        if (null != tables && !tables.isEmpty()) {
            table = tables.iterator().next();
            configs.and("M.INDEX_OWNER", (Object)table.getSchemaName());
        }
        configs.in("M.TABLE_NAME", (Object)Table.names(tables));
        return runs;
    }

    protected Run buildQueryIndexBody(DataRuntime runtime) {
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT M.*, F.COLUMN_EXPRESSION FROM ALL_IND_COLUMNS M\n");
        builder.append("LEFT JOIN ALL_IND_EXPRESSIONS F\n");
        builder.append("ON M.INDEX_OWNER = F.INDEX_OWNER AND M.INDEX_NAME = F.INDEX_NAME AND M.COLUMN_POSITION = F.COLUMN_POSITION\n");
        return run;
    }

    @Override
    public MetadataFieldRefer initIndexFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Index.class);
        refer.map("NAME", "INDEX_NAME");
        refer.map("TABLE", "TABLE_NAME");
        refer.map("SCHEMA", "INDEX_OWNER");
        refer.map("CATALOG", "");
        refer.map("COLUMN", "COLUMN_EXPRESSION,COLUMN_NAME");
        refer.map("ORDER", "DESCEND");
        refer.map("POSITION", "COLUMN_POSITION");
        return refer;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Index query, DataSet set) throws Exception {
        return super.indexes(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, List<T> previous, Index query, DataSet set) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        return previous;
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Index query) throws Exception {
        return super.indexes(runtime, create, previous, query);
    }

    @Override
    public <T extends Index> T init(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        return super.init(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Index query, DataRow row) throws Exception {
        return super.detail(runtime, index, meta, query, row);
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Constraint query) {
        return super.constraints(runtime, random, greedy, query);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        return super.constraints(runtime, random, table, column, pattern);
    }

    @Override
    public List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Constraint query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM USER_CONSTRAINTS");
        configs.and("OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getTableName());
        return runs;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, List<T> previous, Constraint query, DataSet set) throws Exception {
        return super.constraints(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Constraint query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String chk;
            String name = row.getString("CONSTRAINT_NAME");
            if (null == name) continue;
            Constraint constraint = (Constraint)previous.get(name.toUpperCase());
            if (null == constraint && create) {
                constraint = new Constraint();
                previous.put(name.toUpperCase(), constraint);
            }
            String schema = row.getString("OWNER");
            constraint.setSchema(schema);
            if (null == table) {
                table = new Table(null, schema, row.getString("TABLE_NAME"));
            }
            constraint.setTable(table);
            constraint.setName(name);
            String type = row.getString("CONSTRAINT_TYPE");
            if ("P".equalsIgnoreCase(type)) {
                constraint.setType(Constraint.TYPE.PRIMARY_KEY);
                continue;
            }
            if ("R".equalsIgnoreCase(type)) {
                constraint.setType(Constraint.TYPE.FOREIGN_KEY);
                continue;
            }
            if (!"C".equalsIgnoreCase(type) || null == (chk = row.getString("SEARCH_CONDITION")) || !chk.contains("IS NOT NULL")) continue;
            constraint.setType(Constraint.TYPE.NOT_NULL);
        }
        return previous;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Trigger query) {
        return super.triggers(runtime, random, greedy, query);
    }

    @Override
    public List<Run> buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Trigger query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        List events = query.getEvents();
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM USER_TRIGGERS");
        configs.and("TABLE_OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "TABLE_NAME", (Object)query.getTableName());
        configs.in("TRIGGERING_EVENT", (Object)events);
        return runs;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Trigger query, DataSet set) throws Exception {
        Table table = query.getTable();
        if (null == previous) {
            previous = new LinkedHashMap();
        }
        for (DataRow row : set) {
            String name = row.getString("TRIGGER_NAME");
            Trigger trigger = (Trigger)previous.get(name.toUpperCase());
            if (null == trigger) {
                trigger = new Trigger();
            }
            trigger.setName(name);
            Table tab = new Table(row.getString("TABLE_NAME"));
            tab.setSchema(row.getString("TABLE_OWNER"));
            trigger.setTable(tab);
            try {
                boolean each = false;
                String des = row.getStringNvl("DESCRIPTION", new String[0]).toUpperCase();
                if (des.contains("ROW")) {
                    each = true;
                }
                trigger.setEach(each);
                String[] tmps = des.split(" ");
                trigger.setTime(Trigger.TIME.valueOf((String)tmps[1]));
                trigger.addEvent(new Trigger.EVENT[]{Trigger.EVENT.valueOf((String)tmps[2])});
            }
            catch (Exception e) {
                log.error("\u5c01\u88c5trigger \u5f02\u5e38:", (Throwable)e);
            }
            trigger.setDefinition(row.getString("TRIGGER_BODY"));
            previous.put(name.toUpperCase(), trigger);
        }
        return previous;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Procedure query) {
        return super.procedures(runtime, random, greedy, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Procedure query) {
        return super.procedures(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Procedure query) {
        return super.buildQueryProceduresRun(runtime, greedy, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Procedure query, DataSet set) throws Exception {
        return super.procedures(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Procedure query) throws Exception {
        return super.procedures(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        return super.ddl(runtime, random, procedure);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return super.buildQueryDdlRun(runtime, procedure);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, procedure, ddls, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Function query) {
        return super.functions(runtime, random, greedy, query);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Function query) {
        return super.functions(runtime, random, query);
    }

    @Override
    public List<Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Function query) {
        return super.buildQueryFunctionsRun(runtime, greedy, query);
    }

    @Override
    public MetadataFieldRefer initFunctionFieldRefer() {
        return super.initFunctionFieldRefer();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Function query, DataSet set) throws Exception {
        return super.functions(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> previous, Function query) throws Exception {
        return super.functions(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, function, ddls, set);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Sequence query) {
        return super.sequences(runtime, random, greedy, query);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Sequence query) {
        return super.sequences(runtime, random, query);
    }

    @Override
    public List<Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Sequence query) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        ConfigStore configs = run.getConfigs();
        builder.append("SELECT * FROM all_sequences");
        configs.and("SEQUENCE_OWNER", (Object)query.getSchemaName());
        configs.and(Compare.LIKE_SIMPLE, "SEQUENCE_NAME", (Object)query.getName());
        return runs;
    }

    public MetadataFieldRefer initSequenceFieldRefer() {
        MetadataFieldRefer refer = new MetadataFieldRefer(Sequence.class);
        refer.map("NAME", "SEQUENCE_NAME");
        refer.map("SCHEMA", "SEQUENCE_OWNER");
        refer.map("LAST", "LAST_NUMBER");
        refer.map("MIN", "MIN_VALUE");
        refer.map("MAX", "MAX_VALUE");
        refer.map("INCREMENT", "INCREMENT_BY");
        refer.map("CACHE", "CACHE_SIZE");
        refer.map("CYCLE_CHECK", "CYCLE_FLAG");
        return refer;
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, int index, boolean create, List<T> previous, Sequence query, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Sequence query, DataSet set) throws Exception {
        return super.sequences(runtime, index, create, previous, query, set);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, boolean create, List<T> previous, Sequence query) throws Exception {
        return super.sequences(runtime, create, previous, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence meta) {
        return super.ddl(runtime, random, meta);
    }

    @Override
    public List<Run> buildQueryDdlRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildQueryDdlRun(runtime, meta);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Sequence sequence, List<String> ddls, DataSet set) {
        return super.ddl(runtime, index, sequence, ddls, set);
    }

    @Override
    public <T extends Metadata> T search(List<T> metas, Catalog catalog, Schema schema, String name) {
        return super.search(metas, catalog, schema, name);
    }

    @Override
    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        return super.schema(schemas, catalog, name);
    }

    @Override
    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        return super.catalog(catalogs, name);
    }

    @Override
    public <T extends Database> T database(List<T> databases, String name) {
        return super.database(databases, name);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Metadata meta, ACTION.DDL action, Run run) {
        return super.execute(runtime, random, meta, action, run);
    }

    public boolean create(DataRuntime runtime, Catalog meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Catalog meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Catalog meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Catalog origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Catalog meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return super.buildChangeCommentRun(runtime, catalog);
    }

    public List<Run> buildAddCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return super.buildAddCommentRun(runtime, catalog);
    }

    public StringBuilder checkCatalogExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkCatalogExists(runtime, builder, exists);
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.engine(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Catalog meta) {
        return super.property(runtime, builder, meta);
    }

    public boolean create(DataRuntime runtime, Schema meta) throws Exception {
        return super.create(runtime, meta);
    }

    public boolean alter(DataRuntime runtime, Schema meta) throws Exception {
        return super.alter(runtime, meta);
    }

    public boolean drop(DataRuntime runtime, Schema meta) throws Exception {
        return super.drop(runtime, meta);
    }

    public boolean rename(DataRuntime runtime, Schema origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    public List<Run> buildCreateRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    public List<Run> buildAlterRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    public List<Run> buildRenameRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    public List<Run> buildDropRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    public List<Run> buildAppendCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Schema meta) throws Exception {
        return super.buildAppendColumnCommentRun(runtime, meta);
    }

    public List<Run> buildChangeCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return super.buildChangeCommentRun(runtime, schema);
    }

    public List<Run> buildAddCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return super.buildAddCommentRun(runtime, schema);
    }

    public StringBuilder checkSchemaExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkSchemaExists(runtime, builder, exists);
    }

    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.engine(runtime, builder, meta);
    }

    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.charset(runtime, builder, meta);
    }

    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.comment(runtime, builder, meta);
    }

    public StringBuilder property(DataRuntime runtime, StringBuilder builder, Schema meta) {
        return super.property(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE ").append(this.keyword((Metadata)meta)).append(" ");
        this.checkTableExists(runtime, builder, false);
        this.name(runtime, builder, (Metadata)meta);
        this.body(runtime, builder, meta);
        this.partitionBy(runtime, builder, meta);
        this.partitionFor(runtime, builder, meta);
        this.inherit(runtime, builder, meta);
        this.engine(runtime, builder, meta);
        this.charset(runtime, builder, meta);
        this.keys(runtime, builder, meta);
        this.distribution(runtime, builder, meta);
        this.materialize(runtime, builder, meta);
        this.property(runtime, builder, meta);
        this.option(runtime, builder, meta);
        this.comment(runtime, builder, meta);
        runs.addAll(this.buildAppendCommentRun(runtime, meta));
        runs.addAll(this.buildAppendColumnCommentRun(runtime, meta));
        runs.addAll(this.buildAppendPrimaryRun(runtime, meta));
        runs.addAll(this.buildAppendIndexRun(runtime, meta));
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns) throws Exception {
        return super.buildAlterRun(runtime, meta, columns);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta);
        builder.append(" RENAME TO ");
        Table update = new Table(meta.getUpdate().getName());
        this.name(runtime, builder, (Metadata)update);
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (BasicUtil.isNotEmpty((Object)meta.getComment())) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append(" COMMENT ON TABLE ");
            this.name(runtime, builder, (Metadata)meta);
            builder.append("  IS '").append(meta.getComment()).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendColumnCommentRun(DataRuntime runtime, Table meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        LinkedHashMap columns = meta.getColumns();
        for (Column column : columns.values()) {
            String comment = column.getComment();
            if (!BasicUtil.isNotEmpty((Object)comment)) continue;
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(runtime, builder, (Metadata)meta).append(".");
            Column update = (Column)column.getUpdate();
            String name = null;
            name = null != update ? update.getName() : column.getName();
            this.delimiter(builder, name);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        return this.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return builder;
    }

    @Override
    public void checkPrimary(DataRuntime runtime, Table table) {
        super.checkPrimary(runtime, table);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        PrimaryKey primary = meta.getPrimaryKey();
        LinkedHashMap pks = null;
        String name = null;
        if (null != primary) {
            pks = primary.getColumns();
            name = primary.getName();
        } else {
            pks = meta.primarys();
        }
        if (!pks.isEmpty()) {
            if (BasicUtil.isEmpty((Object)name)) {
                name = "PK_" + meta.getName();
            }
            builder.append(",CONSTRAINT ");
            this.delimiter(builder, name);
            builder.append(" PRIMARY KEY (");
            boolean first = true;
            Column.sort((LinkedHashMap)primary.getPositions(), (LinkedHashMap)pks);
            for (Column pk : pks.values()) {
                if (!first) {
                    builder.append(", ");
                }
                this.delimiter(builder, pk.getName());
                String order = pk.getOrder();
                if (null != order) {
                    builder.append(" ").append(order);
                }
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    @Override
    public StringBuilder engine(DataRuntime runtime, StringBuilder builder, Table meta) {
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        return super.charset(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionBy(runtime, builder, meta);
    }

    @Override
    public StringBuilder partitionFor(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        Table.Partition partition = meta.getPartition();
        if (null == partition) {
            return builder;
        }
        Table.Partition.TYPE type = partition.getType();
        if (null == type) {
            return builder;
        }
        if (type == Table.Partition.TYPE.HASH) {
            builder.append(" PARTITIONS ").append(partition.getModulus());
            return builder;
        }
        List slices = partition.getSlices();
        if (null != slices && !slices.isEmpty()) {
            builder.append("(\n");
            boolean sfirst = true;
            for (Table.Partition.Slice slice : slices) {
                builder.append("\n\t");
                if (!sfirst) {
                    builder.append(", ");
                }
                sfirst = false;
                Object max = slice.getMax();
                List values = slice.getValues();
                LinkedHashMap less = slice.getLess();
                int interval = slice.getInterval();
                String unit = slice.getUnit();
                if (type == Table.Partition.TYPE.RANGE) {
                    LinkedHashMap columns = partition.getColumns();
                    builder.append("PARTITION ").append(slice.getName()).append(" VALUES LESS THAN ");
                    builder.append("(");
                    boolean lfirst = true;
                    for (Column column : columns.values()) {
                        if (!lfirst) {
                            builder.append(", ");
                        }
                        lfirst = false;
                        Object v = less.get(column.getName().toUpperCase());
                        builder.append(this.write(runtime, null, v, false, false));
                    }
                    builder.append(")");
                    continue;
                }
                if (type != Table.Partition.TYPE.LIST) continue;
                builder.append("PARTITION ").append(slice.getName()).append(" VALUES (");
                boolean vfirst = true;
                for (Object value : values) {
                    if (!vfirst) {
                        builder.append(", ");
                    }
                    vfirst = false;
                    Object write = this.write(runtime, null, value, false, false);
                    builder.append(write);
                }
                builder.append(")");
            }
            builder.append("\n)");
        }
        return builder;
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        return super.partitionOf(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public StringBuilder buildCreateRunHead(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        return super.buildCreateRunHead(runtime, builder, meta);
    }

    @Override
    public StringBuilder buildCreateRunOption(DataRuntime runtime, StringBuilder builder, View meta) throws Exception {
        return super.buildCreateRunOption(runtime, builder, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkViewExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAppendCommentRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        return super.buildChangeCommentRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        builder.append(" ADD ");
        this.delimiter(builder, meta.getName()).append(" ");
        this.define(runtime, builder, meta, ACTION.DDL.COLUMN_ADD);
        runs.addAll(this.buildAppendCommentRun(runtime, meta, slice));
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            Table table = meta.getTable(true);
            builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
            this.name(runtime, builder, (Metadata)table);
        } else {
            run.slice(slice);
        }
        builder.append(" RENAME COLUMN ");
        this.delimiter(builder, meta.getName());
        builder.append(" TO ");
        this.delimiter(builder, ((Column)meta.getUpdate()).getName());
        meta.setName(((Column)meta.getUpdate()).getName());
        return runs;
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = (Column)meta.getUpdate();
        String name = meta.getName();
        String type = meta.getTypeName();
        String uname = update.getName();
        TypeMetadata update_metadata = update.getTypeMetadata();
        TypeMetadata column_metadata = meta.getTypeMetadata();
        if (uname.endsWith(ConfigTable.ALTER_COLUMN_TYPE_SUFFIX)) {
            runs.addAll(this.buildDropRun(runtime, update, slice));
        } else if (null != update_metadata && !update_metadata.equals(column_metadata)) {
            String tmp_name = meta.getName() + ConfigTable.ALTER_COLUMN_TYPE_SUFFIX;
            update.setName(tmp_name);
            runs.addAll(this.buildRenameRun(runtime, meta, slice));
            update.setName(uname);
            runs.addAll(this.buildAddRun(runtime, update, slice));
            long size = this.count(runtime, null, (RunPrepare)new DefaultTablePrepare(meta.getTable(true)), null, new String[0]);
            if (size > 0L) {
                StringBuilder builder = new StringBuilder();
                builder.append("UPDATE ");
                this.name(runtime, builder, (Metadata)meta.getTable(true));
                builder.append(" SET ");
                this.delimiter(builder, uname);
                builder.append(" = ");
                this.delimiter(builder, tmp_name);
                runs.add((Run)new SimpleRun(runtime, builder));
            }
            meta.setName(tmp_name);
            List<Run> drop = this.buildDropRun(runtime, meta, slice);
            runs.addAll(drop);
            meta.setName(name);
            update.setName(name);
            meta.setNullable(Boolean.valueOf(update.isNullable()));
        } else {
            SimpleRun run = new SimpleRun(runtime);
            StringBuilder builder = run.getBuilder();
            if (!this.slice(slice)) {
                Table table = meta.getTable(true);
                builder.append("ALTER ").append(this.keyword((Metadata)table)).append(" ");
                this.name(runtime, builder, (Metadata)table);
            } else {
                run.slice(slice);
            }
            builder.append(" MODIFY(");
            this.delimiter(builder, meta.getName()).append(" ");
            this.type(runtime, builder, (Column)meta.getUpdate());
            builder.append(")");
            runs.add((Run)run);
        }
        return runs;
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.addColumnGuide(runtime, builder, meta);
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.dropColumnGuide(runtime, builder, meta);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Object def = null;
        def = null != meta.getUpdate() ? ((Column)meta.getUpdate()).getDefaultValue() : meta.getDefaultValue();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, (Metadata)meta.getTable(true)).append(" MODIFY ");
        this.delimiter(builder, meta.getName());
        if (null != def) {
            this.defaultValue(runtime, builder, meta);
        } else {
            builder.append(" DEFAULT NULL");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Boolean nullable = meta.getNullable();
        Boolean uNullable = ((Column)meta.getUpdate()).getNullable();
        if (nullable != null && uNullable != null) {
            if (nullable == uNullable) {
                return runs;
            }
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true)).append(" MODIFY ");
            this.delimiter(builder, meta.getName());
            if (!uNullable.booleanValue()) {
                builder.append(" NOT ");
            }
            builder.append(" NULL");
            meta.setNullable(uNullable);
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        String comment = null;
        comment = null != meta.getUpdate() ? ((Column)meta.getUpdate()).getComment() : meta.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            SimpleRun run = new SimpleRun(runtime);
            runs.add((Run)run);
            StringBuilder builder = run.getBuilder();
            builder.append("COMMENT ON COLUMN ");
            this.name(runtime, builder, (Metadata)meta.getTable(true)).append(".");
            Column update = (Column)meta.getUpdate();
            String name = null;
            name = null != update ? update.getName() : meta.getName();
            this.delimiter(builder, name);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return this.buildChangeCommentRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        return super.buildDropAutoIncrement(runtime, meta, slice);
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.define(runtime, builder, meta, action);
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkColumnExists(runtime, builder, exists);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, int ignoreLength, int ignorePrecision, int ignoreScale, int maxLength, int maxPrecision, int maxScale) {
        return super.type(runtime, builder, meta, type, ignoreLength, ignorePrecision, ignoreScale, maxLength, maxPrecision, maxScale);
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta, ACTION.DDL action) {
        return super.nullable(runtime, builder, meta, action);
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.charset(runtime, builder, meta);
    }

    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.defaultValue(runtime, builder, meta);
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.primary(runtime, builder, meta);
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.increment(runtime, builder, meta);
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.onupdate(runtime, builder, meta);
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.position(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        return super.alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildAddRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildDropRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildRenameRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeDefaultRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeNullableRun(runtime, meta, slice);
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        String comment = meta.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append("COMMENT ON TABLE ");
            this.name(runtime, builder, (Column)meta);
            builder.append(" IS '").append(comment).append("'");
        }
        return runs;
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta, boolean slice) throws Exception {
        return super.buildChangeTypeRun(runtime, meta, slice);
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        return super.checkTagExists(runtime, builder, exists);
    }

    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = meta.getColumns();
        if (null != columns && !columns.isEmpty()) {
            if (!this.slice(slice)) {
                builder.append("ALTER TABLE ");
                this.name(runtime, builder, (Metadata)meta.getTable(true));
            } else {
                run.slice(slice);
            }
            String name = meta.getName();
            if (BasicUtil.isEmpty((Object)name)) {
                name = "PK_" + meta.getTableName(true);
            }
            builder.append(" ADD CONSTRAINT ");
            this.delimiter(builder, name);
            builder.append(" PRIMARY KEY(");
            Column.sort((LinkedHashMap)meta.getPositions(), (LinkedHashMap)columns);
            this.delimiter(builder, Column.names((LinkedHashMap)columns));
            builder.append(")");
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta, boolean slice) throws Exception {
        return super.buildAlterRun(runtime, origin, meta, slice);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        if (!this.slice(slice)) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)meta.getTable(true));
        } else {
            run.slice(slice);
        }
        builder.append(" DROP PRIMARY KEY");
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAppendIndexRun(DataRuntime runtime, Table meta) throws Exception {
        return super.buildAppendIndexRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add((Run)run);
        StringBuilder builder = run.getBuilder();
        Table table = meta.getTable(true);
        if (meta.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, (Metadata)table);
            builder.append(" DROP CONSTRAINT ").append(meta.getName());
        } else {
            builder.append("DROP INDEX ").append(meta.getName());
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.type(runtime, builder, meta);
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        return super.comment(runtime, builder, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        return super.alter(runtime, table, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAddRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        return super.add(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        return super.each(runtime, builder, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        return super.parameter(runtime, builder, parameter);
    }

    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public boolean create(DataRuntime runtime, Sequence meta) throws Exception {
        return super.create(runtime, meta);
    }

    @Override
    public boolean alter(DataRuntime runtime, Sequence meta) throws Exception {
        return super.alter(runtime, meta);
    }

    @Override
    public boolean drop(DataRuntime runtime, Sequence meta) throws Exception {
        return super.drop(runtime, meta);
    }

    @Override
    public boolean rename(DataRuntime runtime, Sequence origin, String name) throws Exception {
        return super.rename(runtime, origin, name);
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildCreateRun(runtime, meta);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildAlterRun(runtime, meta);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildDropRun(runtime, meta);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Sequence meta) throws Exception {
        return super.buildRenameRun(runtime, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, DataSource datasource, T meta) {
        super.checkSchema(runtime, datasource, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, Connection con, T meta) {
        super.checkSchema(runtime, con, meta);
    }

    @Override
    public <T extends Metadata> void checkSchema(DataRuntime runtime, T meta) {
        super.checkSchema(runtime, meta);
    }

    public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema, boolean overrideRuntime, boolean overrideMeta) {
        super.correctSchemaFromJDBC(runtime, meta, catalog, schema, overrideRuntime, overrideMeta);
    }

    public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema) {
        this.correctSchemaFromJDBC(runtime, meta, catalog, schema, false, true);
    }

    public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return super.correctSchemaFromJDBC(catalog, schema);
    }

    public String columnFieldLengthRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldLengthRefer(runtime, meta);
    }

    public String columnFieldPrecisionRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldPrecisionRefer(runtime, meta);
    }

    public String columnFieldScaleRefer(DataRuntime runtime, TypeMetadata meta) {
        return super.columnFieldScaleRefer(runtime, meta);
    }

    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        if (value == DriverAdapter.SQL_BUILD_IN_VALUE.CURRENT_DATETIME) {
            return "sysdate";
        }
        return null;
    }

    @Override
    public String concat(DataRuntime runtime, String ... args) {
        return this.concatOr(runtime, args);
    }

    @Override
    protected String dummy() {
        return super.dummy();
    }

    protected void merge(DataRuntime runtime, StringBuilder builder, Table dest, ConfigStore configs, String select, LinkedHashMap<String, Column> columns, LinkedHashMap<String, Column> pks) {
        List bys = configs.overrideByColumns();
        if (null == bys) {
            bys = new ArrayList();
        }
        if (bys.isEmpty()) {
            bys = Column.names(pks);
        }
        builder.append("MERGE INTO ");
        this.name(runtime, builder, (Metadata)dest);
        builder.append(" M\n");
        builder.append("USING (\n");
        builder.append(select);
        builder.append(") D ON(");
        builder.append(this.concatEqual("D", "M", "AND", bys)).append(")\n");
        builder.append("WHEN NOT MATCHED THEN \n");
        builder.append("INSERT(");
        builder.append(this.concat("M", ",", Column.names(columns)));
        builder.append(")VALUES(");
        builder.append(this.concat("D", ",", Column.names(columns)));
        builder.append(")\n");
        if (configs.override().booleanValue()) {
            builder.append("WHEN MATCHED THEN \n");
            List cols = Column.names(columns);
            cols.removeAll(bys);
            builder.append("UPDATE SET ").append(this.concatEqual("M", "D", ",", cols));
        }
    }

    protected String insertSelectHead(LinkedHashMap<String, Column> columns, Map<String, Sequence> sequens) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        boolean start = true;
        for (Column column : columns.values()) {
            String key = column.getName();
            Sequence seq = sequens.get(key);
            if (!start) {
                builder.append(", ");
            }
            start = false;
            if (null != seq) {
                builder.append(seq.sql());
            } else {
                builder.append("I.");
                this.delimiter(builder, key);
            }
            builder.append(" AS ");
            this.delimiter(builder, key);
        }
        builder.append("\nFROM( ");
        for (Sequence seq : sequens.values()) {
            columns.remove(seq.sql().toUpperCase());
        }
        return builder.toString();
    }

    protected String insertsSelect(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns, Map<String, Sequence> sequens, PrimaryGenerator generator, LinkedHashMap<String, Column> pks) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.insertSelectHead(columns, sequens));
        boolean first = true;
        boolean el = ConfigStore.IS_AUTO_CHECK_EL_VALUE((ConfigStore)configs);
        boolean batch = run.getBatch() > 1;
        for (DataRow row : set) {
            if (row.hasPrimaryKeys() && null != generator) {
                generator.create((Object)row, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            if (!first && !batch) {
                builder.append("\n\tUNION ALL");
            }
            if (first || !batch) {
                builder.append("\n\tSELECT ");
            }
            builder.append(this.insertValue(runtime, run, row, first, true, true, true, false, el, columns));
            if (first || !batch) {
                builder.append(" FROM DUAL ");
            }
            first = false;
        }
        builder.append(") I ");
        return builder.toString();
    }

    protected String insertsSelect(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns, Map<String, Sequence> sequens, PrimaryGenerator generator, LinkedHashMap<String, Column> pks) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.insertSelectHead(columns, sequens));
        boolean batch = run.getBatch() > 1;
        boolean el = ConfigStore.IS_AUTO_CHECK_EL_VALUE((ConfigStore)configs);
        boolean first = true;
        for (Object obj : list) {
            boolean create = EntityAdapterProxy.createPrimaryValue(obj, pks);
            if (!create && null != generator) {
                generator.create(obj, this.type(), dest.getName().replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), ""), pks, null);
            }
            if (!first && !batch) {
                builder.append("\n\tUNION ALL");
            }
            if (first || !batch) {
                builder.append("\n\tSELECT ");
            }
            builder.append(this.insertValue(runtime, run, obj, first, true, true, true, false, el, columns));
            if (first || !batch) {
                builder.append(" FROM DUAL ");
            }
            first = false;
        }
        builder.append(") I ");
        return builder.toString();
    }

    protected void createPrimaryValue(DataRuntime runtime, Collection list, Sequence sequence) {
        SimpleRun run = new SimpleRun(runtime);
        StringBuilder builder = run.getBuilder();
        builder.append("SELECT ").append(sequence.sql()).append(" AS ID FROM(\n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append("SELECT NULL FROM DUAL\n");
            if (i >= size - 1) continue;
            builder.append("UNION ALL\n");
        }
        builder.append(") M");
        try {
            List maps = this.actuator.maps((DriverAdapter)this, runtime, null, null, (Run)run);
            int i = 0;
            for (Object obj : list) {
                Object value = ((Map)maps.get(i++)).get("ID");
                this.setPrimaryValue(obj, value);
            }
        }
        catch (Exception e) {
            log.error("create primary value exception", (Throwable)e);
        }
    }

    static {
        types.put((Type)Table.TYPE.NORMAL, "TABLE");
        types.put((Type)Table.TYPE.VIEW, "VIEW");
        types.put((Type)View.TYPE.NORMAL, "VIEW");
        types.put((Type)Metadata.TYPE.TABLE, "TABLE");
        types.put((Type)Metadata.TYPE.VIEW, "VIEW");
    }
}

