/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserPropertyOptionCollector {
    private static final Pattern INDEXED_PROPERTY_NAME_RX = Pattern.compile("([^\\[]+)\\[([0-9]+)\\]");
    private final String prefix;
    private final String command;

    public UserPropertyOptionCollector(String prefix) {
        this.prefix = prefix;
        this.command = System.getProperty("sun.java.command");
    }

    public List<String> collectOptions(Properties userProperties) {
        ArrayList<String> options = new ArrayList<String>();
        int startIdx = this.prefix.length();
        for (String name : this.getSortedPropertyNames(userProperties)) {
            int endIdx;
            if (!name.startsWith(this.prefix) || name.indexOf(".", startIdx) > -1) continue;
            int n = endIdx = name.endsWith("]") ? name.indexOf("[", startIdx) : -1;
            if (endIdx == -1) {
                String value = userProperties.getProperty(name);
                options.add(name.substring(startIdx) + (String)(this.isNameOnlyUserProperty(name, value) ? "" : "=" + value));
                continue;
            }
            options.add(name.substring(startIdx, endIdx) + "[]=" + userProperties.getProperty(name));
        }
        return options;
    }

    private List<String> getSortedPropertyNames(Properties properties) {
        ArrayList<String> propertyNames = new ArrayList<String>(properties.stringPropertyNames());
        propertyNames.sort((a, b) -> {
            Matcher bMatcher;
            Matcher aMatcher;
            if (a.endsWith("]") && b.endsWith("]") && (aMatcher = INDEXED_PROPERTY_NAME_RX.matcher((CharSequence)a)).matches() && b.startsWith(aMatcher.group(1)) && (bMatcher = INDEXED_PROPERTY_NAME_RX.matcher((CharSequence)b)).matches() && aMatcher.group(1).equals(bMatcher.group(1))) {
                return Integer.valueOf(aMatcher.group(2)).compareTo(Integer.valueOf(bMatcher.group(2)));
            }
            return a.compareTo((String)b);
        });
        return propertyNames;
    }

    private boolean isNameOnlyUserProperty(String name, String value) {
        if (!"true".equals(value)) {
            return false;
        }
        if (this.command == null) {
            return !name.endsWith("?") && !name.endsWith("]");
        }
        return (this.command + " ").contains(" -D" + name + " ");
    }
}

