/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import org.antora.maven.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;

public class FrontendMojoExecutor {
    private static final String FRONTEND_MAVEN_PLUGIN_COORDINATES = "com.github.eirslett:frontend-maven-plugin:1.15.0";
    private static final String NPM_REGISTRY_URL_PARAMETER = "npmRegistryURL";
    private static final String NPM_INHERITS_PROXY_CONFIG_PARAMETER = "npmInheritsProxyConfigFromMaven";
    private final Log log;
    private final Xpp3Dom[] baseConfiguration;
    private final BuildPluginManager buildPluginManager;
    private final MavenSession mavenSession;
    private final PluginDescriptor pluginDescriptor;

    public FrontendMojoExecutor(Log log, BuildPluginManager buildPluginManager, MavenSession mavenSession, Xpp3Dom ... configurationElements) throws MojoExecutionException {
        this.log = log;
        this.baseConfiguration = configurationElements;
        this.pluginDescriptor = this.loadFrontendMavenPlugin(buildPluginManager, mavenSession);
        this.buildPluginManager = buildPluginManager;
        this.mavenSession = mavenSession;
    }

    public void executeMojo(String goal, Xpp3Dom ... configurationElements) throws MojoExecutionException {
        MojoDescriptor mojoDescriptor = this.pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoExecutionException("Could not find goal " + goal + " in " + this.pluginDescriptor.getId());
        }
        Xpp3Dom configuration = this.buildConfiguration(mojoDescriptor, configurationElements);
        Xpp3Dom npmRegistryURL = configuration.getChild(NPM_REGISTRY_URL_PARAMETER);
        String npmRegistryURLOverride = null;
        if (npmRegistryURL != null) {
            npmRegistryURL.setValue("");
            npmRegistryURLOverride = System.clearProperty(NPM_REGISTRY_URL_PARAMETER);
            Xpp3Dom npmInheritsProxyConfig = configuration.getChild(NPM_INHERITS_PROXY_CONFIG_PARAMETER);
            if (npmInheritsProxyConfig != null) {
                npmInheritsProxyConfig.setValue("false");
            }
        }
        MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, goal + "-antora");
        mojoExecution.setConfiguration(configuration);
        try {
            this.buildPluginManager.executeMojo(this.mavenSession, mojoExecution);
        }
        catch (MojoFailureException | PluginConfigurationException | PluginManagerException e) {
            String msg = "Unable to execute " + mojoDescriptor.getId();
            if (e instanceof MojoFailureException) {
                Throwable rootCause = e;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (rootCause.getMessage().endsWith("(Exit value: 1)")) {
                    msg = msg + " (inspect prior log messages to find cause)";
                }
            }
            throw new MojoExecutionException(msg, (Exception)e);
        }
        finally {
            if (npmRegistryURLOverride != null) {
                System.setProperty(NPM_REGISTRY_URL_PARAMETER, npmRegistryURLOverride);
            }
        }
    }

    public void handleNodeVersionChange(File nodeHomeDir, String nodeVersion) throws MojoExecutionException {
        File nodeVersionFile = new File(nodeHomeDir, ".node-version");
        if (FileUtils.hasContents(nodeVersionFile, nodeVersion)) {
            return;
        }
        try {
            FileUtils.cleanDirectory(nodeHomeDir);
            Files.writeString(nodeVersionFile.toPath(), (CharSequence)nodeVersion, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to handle Node.js version change", (Exception)e);
        }
    }

    private PluginDescriptor loadFrontendMavenPlugin(BuildPluginManager buildPluginManager, MavenSession mavenSession) throws MojoExecutionException {
        Plugin plugin = this.getFrontendMavenPlugin(mavenSession);
        List repositories = mavenSession.getCurrentProject() == null ? List.of() : mavenSession.getCurrentProject().getRemotePluginRepositories();
        RepositorySystemSession repositorySession = mavenSession.getRepositorySession();
        try {
            return buildPluginManager.loadPlugin(plugin, repositories, repositorySession);
        }
        catch (InvalidPluginDescriptorException | PluginDescriptorParsingException | PluginNotFoundException | PluginResolutionException e) {
            throw new MojoExecutionException("Failed to load plugin " + plugin.getId(), (Exception)e);
        }
    }

    private Plugin getFrontendMavenPlugin(MavenSession mavenSession) {
        String[] coordinates = FRONTEND_MAVEN_PLUGIN_COORDINATES.split(":", 3);
        Plugin result = new Plugin();
        result.setGroupId(coordinates[0]);
        result.setArtifactId(coordinates[1]);
        result.setVersion(coordinates[2]);
        PluginManagement pluginManagement = mavenSession.getCurrentProject().getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin candidate : pluginManagement.getPlugins()) {
                if (!candidate.getGroupId().equals(result.getGroupId()) || !candidate.getArtifactId().equals(candidate.getArtifactId())) continue;
                result.setVersion(candidate.getVersion());
                break;
            }
        }
        this.log.info((CharSequence)("Using " + result.getId() + " to manage Node.js."));
        return result;
    }

    private Xpp3Dom buildConfiguration(MojoDescriptor mojoDescriptor, Xpp3Dom[] configurationElements) {
        Xpp3Dom configuration = this.toXpp3Dom(mojoDescriptor.getMojoConfiguration());
        this.mergeConfigurationElements(configuration, this.baseConfiguration);
        this.mergeConfigurationElements(configuration, configurationElements);
        return configuration;
    }

    private void mergeConfigurationElements(Xpp3Dom configuration, Xpp3Dom[] overrides) {
        Arrays.stream(overrides).forEach(it -> {
            String name = it.getName();
            int l = configuration.getChildCount();
            for (int i = 0; i < l; ++i) {
                Xpp3Dom candidate = configuration.getChild(i);
                if (!name.equals(candidate.getName())) continue;
                for (String attributeName : candidate.getAttributeNames()) {
                    if ("default-value".equals(attributeName)) continue;
                    it.setAttribute(attributeName, candidate.getAttribute(attributeName));
                }
                configuration.removeChild(i);
                break;
            }
            configuration.addChild(it);
        });
    }

    private Xpp3Dom toXpp3Dom(PlexusConfiguration configuration) {
        Xpp3Dom result = new Xpp3Dom(configuration.getName());
        for (String string : configuration.getAttributeNames()) {
            result.setAttribute(string, configuration.getAttribute(string));
        }
        if (configuration.getChildCount() > 0) {
            for (String string : configuration.getChildren()) {
                result.addChild(this.toXpp3Dom((PlexusConfiguration)string));
            }
        } else {
            result.setValue(configuration.getValue());
        }
        return result;
    }
}

