/*
 * Decompiled with CFR 0.152.
 */
package org.antora.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class FrontendMojoExecutor {
    private static final String FRONTEND_MAVEN_PLUGIN_COORDINATES = "com.github.eirslett:frontend-maven-plugin:1.15.0";
    private final List<MojoExecutor.Element> baseConfigurationElements;
    private final MojoExecutor.ExecutionEnvironment executionEnvironment;
    private final Plugin plugin;

    public FrontendMojoExecutor(BuildPluginManager pluginManager, MavenSession mavenSession, MojoExecutor.Element ... configuration) {
        this.baseConfigurationElements = new ArrayList<MojoExecutor.Element>(Arrays.asList(configuration));
        this.plugin = this.getFrontendMavenPlugin(mavenSession);
        this.executionEnvironment = new MojoExecutor.ExecutionEnvironment(mavenSession, pluginManager);
    }

    public void executeMojo(String goal, MojoExecutor.Element ... configuration) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> mergedConfiguration = new ArrayList<MojoExecutor.Element>(Arrays.asList(configuration));
        mergedConfiguration.addAll(this.baseConfigurationElements);
        MojoExecutor.executeMojo((Plugin)this.plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])mergedConfiguration.toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
    }

    private Plugin getFrontendMavenPlugin(MavenSession mavenSession) {
        String[] coordinates = FRONTEND_MAVEN_PLUGIN_COORDINATES.split(":", 3);
        Plugin result = MojoExecutor.plugin((String)MojoExecutor.groupId((String)coordinates[0]), (String)MojoExecutor.artifactId((String)coordinates[1]), (String)MojoExecutor.version((String)coordinates[2]));
        PluginManagement pluginManagement = mavenSession.getCurrentProject().getPluginManagement();
        if (pluginManagement != null) {
            for (Plugin candidate : pluginManagement.getPlugins()) {
                if (!candidate.getGroupId().equals(result.getGroupId()) || !candidate.getArtifactId().equals(candidate.getArtifactId())) continue;
                result.setVersion(candidate.getVersion());
                break;
            }
        }
        return result;
    }
}

