/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr3;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.gunit.AbstractTest;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.Interp;
import org.antlr.gunit.gUnitExecutor;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class GUnitExecuteMojo
extends AbstractMojo {
    public static final String ANTLR_GROUP_ID = "org.antlr";
    public static final String ANTLR_ARTIFACT_NAME = "antlr";
    public static final String ANTLR_RUNTIME_ARTIFACT_NAME = "antlr-runtime";
    private MavenProject project;
    private List<Artifact> pluginArtifacts;
    private File sourceDirectory;
    private Set includes;
    private Set excludes;
    private File reportDirectory;
    private boolean skip;

    public Set getIncludePatterns() {
        return this.includes == null || this.includes.isEmpty() ? Collections.singleton("**/*.testsuite") : this.includes;
    }

    public Set getExcludePatterns() {
        return this.excludes == null ? Collections.emptySet() : this.excludes;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping gUnit processing");
            return;
        }
        Artifact pluginAntlrArtifact = this.determinePluginAntlrArtifact();
        this.validateProjectsAntlrVersion(this.determineArtifactVersion(pluginAntlrArtifact));
        this.performExecution(this.determineProjectCompileScopeClassLoader(pluginAntlrArtifact));
    }

    private Artifact determinePluginAntlrArtifact() throws MojoExecutionException {
        for (Artifact artifact : this.pluginArtifacts) {
            boolean match;
            boolean bl = match = ANTLR_GROUP_ID.equals(artifact.getGroupId()) && ANTLR_ARTIFACT_NAME.equals(artifact.getArtifactId());
            if (!match) continue;
            return artifact;
        }
        throw new MojoExecutionException("Unexpected state : could not locate org.antlr:antlr in plugin dependencies");
    }

    private ArtifactVersion determineArtifactVersion(Artifact artifact) throws MojoExecutionException {
        try {
            return artifact.getVersion() != null ? new DefaultArtifactVersion(artifact.getVersion()) : artifact.getSelectedVersion();
        }
        catch (OverConstrainedVersionException e) {
            throw new MojoExecutionException("artifact [" + artifact.getId() + "] defined an overly constrained version range");
        }
    }

    private void validateProjectsAntlrVersion(ArtifactVersion pluginAntlrVersion) throws MojoExecutionException {
        Artifact antlrArtifact = null;
        Artifact antlrRuntimeArtifact = null;
        if (this.project.getCompileArtifacts() != null) {
            for (Object o : this.project.getCompileArtifacts()) {
                Artifact artifact = (Artifact)o;
                if (!ANTLR_GROUP_ID.equals(artifact.getGroupId())) continue;
                if (ANTLR_ARTIFACT_NAME.equals(artifact.getArtifactId())) {
                    antlrArtifact = artifact;
                    break;
                }
                if (!ANTLR_RUNTIME_ARTIFACT_NAME.equals(artifact.getArtifactId())) continue;
                antlrRuntimeArtifact = artifact;
            }
        }
        this.validateBuildTimeArtifact(antlrArtifact, pluginAntlrVersion);
        this.validateRunTimeArtifact(antlrRuntimeArtifact, pluginAntlrVersion);
    }

    protected void validateBuildTimeArtifact(Artifact antlrArtifact, ArtifactVersion pluginAntlrVersion) throws MojoExecutionException {
        if (antlrArtifact == null) {
            this.validateMissingBuildtimeArtifact();
            return;
        }
        ArtifactVersion projectAntlrVersion = this.determineArtifactVersion(antlrArtifact);
        if (pluginAntlrVersion.compareTo((Object)projectAntlrVersion) != 0) {
            this.getLog().warn((CharSequence)("Encountered org.antlr:antlr:" + projectAntlrVersion.toString() + " which did not match Antlr version used by plugin [" + pluginAntlrVersion.toString() + "]"));
        }
    }

    protected void validateMissingBuildtimeArtifact() {
    }

    protected void validateRunTimeArtifact(Artifact antlrRuntimeArtifact, ArtifactVersion pluginAntlrVersion) throws MojoExecutionException {
        if (antlrRuntimeArtifact == null) {
            return;
        }
        ArtifactVersion projectAntlrVersion = this.determineArtifactVersion(antlrRuntimeArtifact);
        if (pluginAntlrVersion.compareTo((Object)projectAntlrVersion) != 0) {
            this.getLog().warn((CharSequence)("Encountered org.antlr:antlr-runtime:" + projectAntlrVersion.toString() + " which did not match Antlr version used by plugin [" + pluginAntlrVersion.toString() + "]"));
        }
    }

    private ClassLoader determineProjectCompileScopeClassLoader(Artifact antlrArtifact) throws MojoExecutionException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        this.getLog().info((CharSequence)("Adding Antlr artifact : " + antlrArtifact.getId()));
        classPathUrls.add(GUnitExecuteMojo.resolveLocalURL(antlrArtifact));
        for (String path : this.classpathElements()) {
            try {
                this.getLog().info((CharSequence)("Adding project compile classpath element : " + path));
                classPathUrls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Unable to build path URL [" + path + "]");
            }
        }
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected static URL resolveLocalURL(Artifact artifact) throws MojoExecutionException {
        try {
            return artifact.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to resolve artifact url : " + artifact.getId(), (Exception)e);
        }
    }

    private List<String> classpathElements() throws MojoExecutionException {
        try {
            return this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Call to Project#getCompileClasspathElements required dependency resolution");
        }
    }

    private void performExecution(ClassLoader projectCompileScopeClassLoader) throws MojoExecutionException {
        boolean directoryCreated;
        this.getLog().info((CharSequence)("gUnit report directory : " + this.reportDirectory.getAbsolutePath()));
        if (!this.reportDirectory.exists() && !(directoryCreated = this.reportDirectory.mkdirs())) {
            this.getLog().warn((CharSequence)"mkdirs() reported problem creating report directory");
        }
        Result runningResults = new Result();
        ArrayList<String> failureNames = new ArrayList<String>();
        System.out.println();
        System.out.println("-----------------------------------------------------------");
        System.out.println(" G U N I T   R E S U L T S");
        System.out.println("-----------------------------------------------------------");
        for (File script : this.collectIncludedSourceGrammars()) {
            String scriptPath = script.getAbsolutePath();
            System.out.println("Executing script " + scriptPath);
            try {
                String scriptBaseName = StringUtils.chompLast((String)FileUtils.basename((String)script.getName()), (String)".");
                ANTLRFileStream antlrStream = new ANTLRFileStream(scriptPath);
                GrammarInfo grammarInfo = Interp.parse((CharStream)antlrStream);
                gUnitExecutor executor = new gUnitExecutor(grammarInfo, projectCompileScopeClassLoader, script.getParentFile().getAbsolutePath());
                String report = executor.execTest();
                this.writeReportFile(new File(this.reportDirectory, String.valueOf(scriptBaseName) + ".txt"), report);
                Result testResult = new Result();
                testResult.tests = executor.numOfTest;
                testResult.failures = executor.numOfFailure;
                testResult.invalids = executor.numOfInvalidInput;
                System.out.println(testResult.render());
                runningResults.add(testResult);
                for (AbstractTest test : executor.failures) {
                    failureNames.add(String.valueOf(scriptBaseName) + "#" + test.getHeader());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not open specified script file", (Exception)e);
            }
            catch (RecognitionException e) {
                throw new MojoExecutionException("Could not parse gUnit script", (Exception)((Object)e));
            }
        }
        System.out.println();
        System.out.println("Summary :");
        if (!failureNames.isEmpty()) {
            System.out.println("  Found " + failureNames.size() + " failures");
            for (String name : failureNames) {
                System.out.println("    - " + name);
            }
        }
        System.out.println(runningResults.render());
        System.out.println();
        if (runningResults.failures > 0) {
            throw new MojoExecutionException("Found gUnit test failures");
        }
        if (runningResults.invalids > 0) {
            throw new MojoExecutionException("Found invalid gUnit tests");
        }
    }

    private Set<File> collectIncludedSourceGrammars() throws MojoExecutionException {
        SuffixMapping mapping = new SuffixMapping("g", Collections.EMPTY_SET);
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(this.getIncludePatterns(), this.getExcludePatterns());
        scan.addSourceMapping((SourceMapping)mapping);
        try {
            Set scanResults = scan.getIncludedSources(this.sourceDirectory, null);
            HashSet<File> results = new HashSet<File>();
            for (Object result : scanResults) {
                if (result instanceof File) {
                    results.add((File)result);
                    continue;
                }
                if (result instanceof String) {
                    results.add(new File((String)result));
                    continue;
                }
                throw new MojoExecutionException("Unexpected result type from scanning [" + result.getClass().getName() + "]");
            }
            return results;
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error determining gUnit sources", (Exception)((Object)e));
        }
    }

    private void writeReportFile(File reportFile, String results) {
        try {
            Writer writer = new FileWriter(reportFile);
            writer = new BufferedWriter(writer);
            try {
                writer.write(results);
                writer.flush();
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Error writing gUnit report file", (Throwable)e);
        }
    }

    private static class Result {
        private int tests = 0;
        private int failures = 0;
        private int invalids = 0;

        private Result() {
        }

        public String render() {
            return String.format("Tests run: %d,  Failures: %d,  Invalid: %d", this.tests, this.failures, this.invalids);
        }

        public void add(Result result) {
            this.tests += result.tests;
            this.failures += result.failures;
            this.invalids += result.invalids;
        }
    }
}

