/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.antlr.gunit.InvalidInputException;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Parser;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeAdaptor;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplate;

public abstract class gUnitBaseTest
extends TestCase {
    public String treeAdaptorPath;
    public String packagePath;
    public String lexerPath;
    public String parserPath;
    public String treeParserPath;
    protected String stdout;
    protected String stderr;
    private PrintStream console = System.out;
    private PrintStream consoleErr = System.err;

    public String execLexer(String testRuleName, int line, String testInput, boolean isFile) throws Exception {
        ANTLRStringStream input;
        if (isFile) {
            String filePath = testInput;
            File testInputFile = new File(filePath);
            if (!testInputFile.exists() && this.packagePath != null && (testInputFile = new File(this.packagePath, filePath)).exists()) {
                filePath = testInputFile.getCanonicalPath();
            }
            input = new ANTLRFileStream(filePath);
        } else {
            input = new ANTLRStringStream(testInput);
        }
        Class<?> lexer = null;
        PrintStream ps = null;
        PrintStream ps2 = null;
        try {
            lexer = Class.forName(this.lexerPath);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor<?> lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Lexer lexObj = (Lexer)lexConstructor.newInstance(lexArgs);
            input.setLine(line);
            Method ruleName = lexer.getMethod("m" + testRuleName, new Class[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            ps2 = new PrintStream(err);
            System.setOut(ps);
            System.setErr(ps2);
            ruleName.invoke((Object)lexObj, new Object[0]);
            Method ruleName2 = lexer.getMethod("getCharIndex", new Class[0]);
            int currentIndex = (Integer)ruleName2.invoke((Object)lexObj, new Object[0]);
            if (currentIndex != input.size()) {
                ps2.println("extra text found, '" + input.substring(currentIndex, input.size() - 1) + "'");
            }
            this.stdout = null;
            this.stderr = null;
            if (err.toString().length() > 0) {
                String string = this.stderr = err.toString();
                return string;
            }
            if (out.toString().length() > 0) {
                this.stdout = out.toString();
            }
            if (err.toString().length() == 0 && out.toString().length() == 0) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            this.handleUnexpectedException(e);
        }
        catch (SecurityException e) {
            this.handleUnexpectedException(e);
        }
        catch (NoSuchMethodException e) {
            this.handleUnexpectedException(e);
        }
        catch (IllegalArgumentException e) {
            this.handleUnexpectedException(e);
        }
        catch (InstantiationException e) {
            this.handleUnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            this.handleUnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            this.stderr = e.getCause() != null ? e.getCause().toString() : e.toString();
            String string = this.stderr;
            return string;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.stdout;
    }

    public Object execParser(String testRuleName, int line, String testInput, boolean isFile) throws Exception {
        ANTLRStringStream input;
        if (isFile) {
            String filePath = testInput;
            File testInputFile = new File(filePath);
            if (!testInputFile.exists() && this.packagePath != null && (testInputFile = new File(this.packagePath, filePath)).exists()) {
                filePath = testInputFile.getCanonicalPath();
            }
            input = new ANTLRFileStream(filePath);
        } else {
            input = new ANTLRStringStream(testInput);
        }
        Class<?> lexer = null;
        Class<?> parser = null;
        PrintStream ps = null;
        PrintStream ps2 = null;
        ByteArrayOutputStream out = null;
        ByteArrayOutputStream err = null;
        try {
            lexer = Class.forName(this.lexerPath);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor<?> lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Lexer lexObj = (Lexer)lexConstructor.newInstance(lexArgs);
            input.setLine(line);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexObj);
            parser = Class.forName(this.parserPath);
            Class[] parArgTypes = new Class[]{TokenStream.class};
            Constructor<?> parConstructor = parser.getConstructor(parArgTypes);
            Object[] parArgs = new Object[]{tokens};
            Parser parObj = (Parser)parConstructor.newInstance(parArgs);
            if (this.treeAdaptorPath != null) {
                parArgTypes = new Class[]{TreeAdaptor.class};
                Method _setTreeAdaptor = parser.getMethod("setTreeAdaptor", parArgTypes);
                Class<?> _treeAdaptor = Class.forName(this.treeAdaptorPath);
                _setTreeAdaptor.invoke((Object)parObj, _treeAdaptor.newInstance());
            }
            Method ruleName = parser.getMethod(testRuleName, new Class[0]);
            out = new ByteArrayOutputStream();
            err = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            ps2 = new PrintStream(err);
            System.setOut(ps);
            System.setErr(ps2);
            Object ruleReturn = ruleName.invoke((Object)parObj, new Object[0]);
            String astString = null;
            String stString = null;
            if (ruleReturn != null && ruleReturn.getClass().toString().indexOf(String.valueOf(testRuleName) + "_return") > 0) {
                try {
                    Method[] methods;
                    Class<?> _return = Class.forName(String.valueOf(this.parserPath) + "$" + testRuleName + "_return");
                    Method[] methodArray = methods = _return.getDeclaredMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method returnName;
                        Method method = methodArray[n2];
                        if (method.getName().equals("getTree")) {
                            returnName = _return.getMethod("getTree", new Class[0]);
                            CommonTree tree = (CommonTree)returnName.invoke(ruleReturn, new Object[0]);
                            astString = tree.toStringTree();
                        } else if (method.getName().equals("getTemplate")) {
                            returnName = _return.getMethod("getTemplate", new Class[0]);
                            StringTemplate st = (StringTemplate)returnName.invoke(ruleReturn, new Object[0]);
                            stString = st.toString();
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            this.stdout = "";
            this.stderr = "";
            if (tokens.index() != tokens.size() - 1) {
                this.stderr = String.valueOf(this.stderr) + "Stopped parsing at token index " + tokens.index() + ": ";
            }
            this.stdout = String.valueOf(this.stdout) + out.toString();
            this.stderr = String.valueOf(this.stderr) + err.toString();
            if (err.toString().length() > 0) {
                String string = this.stderr;
                return string;
            }
            if (out.toString().length() > 0) {
                String string = this.stdout;
                return string;
            }
            if (astString != null) {
                String string = astString;
                return string;
            }
            if (stString != null) {
                String string = stString;
                return string;
            }
            if (ruleReturn != null) {
                Object object = ruleReturn;
                return object;
            }
            if (err.toString().length() == 0 && out.toString().length() == 0) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            this.handleUnexpectedException(e);
        }
        catch (SecurityException e) {
            this.handleUnexpectedException(e);
        }
        catch (NoSuchMethodException e) {
            this.handleUnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            this.handleUnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            this.stdout = out.toString();
            this.stderr = err.toString();
            this.stderr = e.getCause() != null ? String.valueOf(this.stderr) + e.getCause().toString() : String.valueOf(this.stderr) + e.toString();
            String string = this.stderr;
            return string;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.stdout;
    }

    public Object execTreeParser(String testTreeRuleName, String testRuleName, String testInput, boolean isFile) throws Exception {
        ANTLRStringStream input;
        if (isFile) {
            String filePath = testInput;
            File testInputFile = new File(filePath);
            if (!testInputFile.exists() && this.packagePath != null && (testInputFile = new File(this.packagePath, filePath)).exists()) {
                filePath = testInputFile.getCanonicalPath();
            }
            input = new ANTLRFileStream(filePath);
        } else {
            input = new ANTLRStringStream(testInput);
        }
        Class<?> lexer = null;
        Class<?> parser = null;
        Class<?> treeParser = null;
        PrintStream ps = null;
        PrintStream ps2 = null;
        try {
            lexer = Class.forName(this.lexerPath);
            Class[] lexArgTypes = new Class[]{CharStream.class};
            Constructor<?> lexConstructor = lexer.getConstructor(lexArgTypes);
            Object[] lexArgs = new Object[]{input};
            Object lexObj = lexConstructor.newInstance(lexArgs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)((Lexer)lexObj));
            parser = Class.forName(this.parserPath);
            Class[] parArgTypes = new Class[]{TokenStream.class};
            Constructor<?> parConstructor = parser.getConstructor(parArgTypes);
            Object[] parArgs = new Object[]{tokens};
            Object parObj = parConstructor.newInstance(parArgs);
            TreeAdaptor customTreeAdaptor = null;
            if (this.treeAdaptorPath != null) {
                parArgTypes = new Class[]{TreeAdaptor.class};
                Method _setTreeAdaptor = parser.getMethod("setTreeAdaptor", parArgTypes);
                Class<?> _treeAdaptor = Class.forName(this.treeAdaptorPath);
                customTreeAdaptor = (TreeAdaptor)_treeAdaptor.newInstance();
                _setTreeAdaptor.invoke(parObj, customTreeAdaptor);
            }
            Method ruleName = parser.getMethod(testRuleName, new Class[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ps = new PrintStream(out);
            ps2 = new PrintStream(err);
            System.setOut(ps);
            System.setErr(ps2);
            Object ruleReturn = ruleName.invoke(parObj, new Object[0]);
            Class<?> _return = Class.forName(String.valueOf(this.parserPath) + "$" + testRuleName + "_return");
            Method returnName = _return.getMethod("getTree", new Class[0]);
            CommonTree tree = (CommonTree)returnName.invoke(ruleReturn, new Object[0]);
            CommonTreeNodeStream nodes = customTreeAdaptor != null ? new CommonTreeNodeStream(customTreeAdaptor, (Object)tree) : new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)tokens);
            treeParser = Class.forName(this.treeParserPath);
            Class[] treeParArgTypes = new Class[]{TreeNodeStream.class};
            Constructor<?> treeParConstructor = treeParser.getConstructor(treeParArgTypes);
            Object[] treeParArgs = new Object[]{nodes};
            Object treeParObj = treeParConstructor.newInstance(treeParArgs);
            Method treeRuleName = treeParser.getMethod(testTreeRuleName, new Class[0]);
            Object treeRuleReturn = treeRuleName.invoke(treeParObj, new Object[0]);
            String astString = null;
            String stString = null;
            if (treeRuleReturn != null && treeRuleReturn.getClass().toString().indexOf(String.valueOf(testTreeRuleName) + "_return") > 0) {
                try {
                    Method[] methods;
                    Class<?> _treeReturn = Class.forName(String.valueOf(this.treeParserPath) + "$" + testTreeRuleName + "_return");
                    Method[] methodArray = methods = _treeReturn.getDeclaredMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method treeReturnName;
                        Method method = methodArray[n2];
                        if (method.getName().equals("getTree")) {
                            treeReturnName = _treeReturn.getMethod("getTree", new Class[0]);
                            CommonTree returnTree = (CommonTree)treeReturnName.invoke(treeRuleReturn, new Object[0]);
                            astString = returnTree.toStringTree();
                        } else if (method.getName().equals("getTemplate")) {
                            treeReturnName = _return.getMethod("getTemplate", new Class[0]);
                            StringTemplate st = (StringTemplate)treeReturnName.invoke(treeRuleReturn, new Object[0]);
                            stString = st.toString();
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            this.stdout = null;
            this.stderr = null;
            if (tokens.index() != tokens.size() - 1) {
                throw new InvalidInputException();
            }
            if (err.toString().length() > 0) {
                String string = this.stderr = err.toString();
                return string;
            }
            if (out.toString().length() > 0) {
                this.stdout = out.toString();
            }
            if (astString != null) {
                String string = astString;
                return string;
            }
            if (stString != null) {
                String string = stString;
                return string;
            }
            if (treeRuleReturn != null) {
                Object object = treeRuleReturn;
                return object;
            }
            if (err.toString().length() == 0 && out.toString().length() == 0) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            this.handleUnexpectedException(e);
        }
        catch (SecurityException e) {
            this.handleUnexpectedException(e);
        }
        catch (NoSuchMethodException e) {
            this.handleUnexpectedException(e);
        }
        catch (IllegalAccessException e) {
            this.handleUnexpectedException(e);
        }
        catch (InvocationTargetException e) {
            this.stderr = e.getCause() != null ? e.getCause().toString() : e.toString();
            String string = this.stderr;
            return string;
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.stdout;
    }

    public Object examineExecResult(int tokenType, Object retVal) {
        System.out.println("expect " + (tokenType == 16 ? "OK" : "FAIL") + "stderr==" + this.stderr);
        if (tokenType == 16) {
            if (this.stderr == null || this.stderr.length() == 0) {
                return "OK";
            }
            return "FAIL, " + this.stderr;
        }
        if (tokenType == 10) {
            if (this.stderr != null && this.stderr.length() > 0) {
                return "FAIL";
            }
            return "OK";
        }
        return retVal;
    }

    protected void handleUnexpectedException(Exception e) {
        e.printStackTrace();
        System.exit(1);
    }
}

