package org.antlr.v4.runtime.tree.xpath;

import com.google.gwt.core.shared.GwtIncompatible;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@GwtIncompatible
public class XPathWildcardElement extends XPathElement {
	public XPathWildcardElement() {
		super(XPath.WILDCARD);
	}

	@Override
	public Collection<ParseTree> evaluate(final ParseTree t) {
		if ( invert ) return new ArrayList<ParseTree>(); // !* is weird but valid (empty)
		List<ParseTree> kids = new ArrayList<ParseTree>();
		for (Tree c : Trees.getChildren(t)) {
			kids.add((ParseTree)c);
		}
		return kids;
	}
}
