/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr4;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.mojo.antlr4.Antlr4ErrorLog;
import org.antlr.mojo.antlr4.GrammarDependencies;
import org.antlr.mojo.antlr4.MojoUtils;
import org.antlr.v4.Tool;
import org.antlr.v4.runtime.misc.MultiMap;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.tool.Grammar;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="antlr4", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class Antlr4Mojo
extends AbstractMojo {
    @Parameter(property="antlr4.atn", defaultValue="false")
    protected boolean atn;
    @Parameter(property="project.build.sourceEncoding")
    protected String inputEncoding;
    @Parameter(property="project.build.sourceEncoding")
    protected String outputEncoding;
    @Parameter(property="antlr4.listener", defaultValue="true")
    protected boolean listener;
    @Parameter(property="antlr4.visitor", defaultValue="false")
    protected boolean visitor;
    @Parameter(property="antlr4.treatWarningsAsErrors", defaultValue="false")
    protected boolean treatWarningsAsErrors;
    @Parameter(property="antlr4.forceATN", defaultValue="false")
    protected boolean forceATN;
    @Parameter
    protected Map<String, String> options;
    @Parameter
    protected List<String> arguments;
    @Parameter
    protected Set<String> includes = new HashSet<String>();
    @Parameter
    protected Set<String> excludes = new HashSet<String>();
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/main/antlr4")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/antlr4")
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}/src/main/antlr4/imports")
    private File libDirectory;
    @Parameter(defaultValue="${project.build.directory}/maven-status/antlr4", readonly=true)
    private File statusDirectory;
    @Component
    private BuildContext buildContext;
    protected Tool tool;

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public File getLibDirectory() {
        return this.libDirectory;
    }

    void addSourceRoot(File outputDir) {
        this.project.addCompileSourceRoot(outputDir.getPath());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<List<String>> argumentSets;
        Set<File> importGrammarFiles;
        Set<File> grammarFiles;
        Log log = this.getLog();
        this.outputEncoding = this.validateEncoding(this.outputEncoding);
        if (log.isDebugEnabled()) {
            for (String e : this.excludes) {
                log.debug((CharSequence)("ANTLR: Exclude: " + e));
            }
            for (String e : this.includes) {
                log.debug((CharSequence)("ANTLR: Include: " + e));
            }
            log.debug((CharSequence)("ANTLR: Output: " + this.outputDirectory));
            log.debug((CharSequence)("ANTLR: Library: " + this.libDirectory));
        }
        if (!this.sourceDirectory.isDirectory()) {
            log.info((CharSequence)("No ANTLR 4 grammars to compile in " + this.sourceDirectory.getAbsolutePath()));
            return;
        }
        File outputDir = this.getOutputDirectory();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        GrammarDependencies dependencies = new GrammarDependencies(this.sourceDirectory, this.libDirectory, this.arguments, this.getDependenciesStatusFile(), this.getLog());
        try {
            List<String> args = this.getCommandArguments();
            grammarFiles = this.getGrammarFiles(this.sourceDirectory);
            importGrammarFiles = this.getImportFiles(this.sourceDirectory);
            argumentSets = this.processGrammarFiles(args, grammarFiles, dependencies, this.sourceDirectory);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new MojoExecutionException("Fatal error occured while evaluating the names of the grammar files to analyze", e);
        }
        log.debug((CharSequence)("Output directory base will be " + this.outputDirectory.getAbsolutePath()));
        log.info((CharSequence)("ANTLR 4: Processing source directory " + this.sourceDirectory.getAbsolutePath()));
        for (List<String> args : argumentSets) {
            try {
                this.tool = new CustomTool(args.toArray(new String[args.size()]));
            }
            catch (Exception e) {
                log.error((CharSequence)"The attempt to create the ANTLR 4 build tool failed, see exception report for details", (Throwable)e);
                throw new MojoFailureException("Error creating an instanceof the ANTLR tool.", (Throwable)e);
            }
            try {
                dependencies.analyze(grammarFiles, importGrammarFiles, this.tool);
            }
            catch (Exception e) {
                log.error((CharSequence)"Dependency analysis failed, see exception report for details", (Throwable)e);
                throw new MojoFailureException("Dependency analysis failed.", (Throwable)e);
            }
            this.tool.inputDirectory = this.sourceDirectory;
            this.tool.processGrammarsOnCommandLine();
            if (this.tool.getNumErrors() <= 0) continue;
            throw new MojoExecutionException("ANTLR 4 caught " + this.tool.getNumErrors() + " build errors.");
        }
        if (this.project != null) {
            this.addSourceRoot(this.getOutputDirectory());
        }
        try {
            dependencies.save();
        }
        catch (IOException ex) {
            log.warn((CharSequence)"Could not save grammar dependency status", (Throwable)ex);
        }
    }

    private List<String> getCommandArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.getOutputDirectory() != null) {
            args.add("-o");
            args.add(this.outputDirectory.getAbsolutePath());
        }
        if (this.getLibDirectory() != null && this.getLibDirectory().isDirectory()) {
            args.add("-lib");
            args.add(this.libDirectory.getAbsolutePath());
        }
        if (this.atn) {
            args.add("-atn");
        }
        if (this.inputEncoding != null && !this.inputEncoding.isEmpty()) {
            args.add("-encoding");
            this.outputEncoding = this.inputEncoding;
            args.add(this.inputEncoding);
        }
        if (this.listener) {
            args.add("-listener");
        } else {
            args.add("-no-listener");
        }
        if (this.visitor) {
            args.add("-visitor");
        } else {
            args.add("-no-visitor");
        }
        if (this.treatWarningsAsErrors) {
            args.add("-Werror");
        }
        if (this.forceATN) {
            args.add("-Xforce-atn");
        }
        if (this.options != null) {
            for (Map.Entry<String, String> option : this.options.entrySet()) {
                args.add(String.format("-D%s=%s", option.getKey(), option.getValue()));
            }
        }
        if (this.arguments != null) {
            args.addAll(this.arguments);
        }
        return args;
    }

    private List<List<String>> processGrammarFiles(List<String> args, Set<File> grammarFiles, GrammarDependencies dependencies, File sourceDirectory) throws InclusionScanException, IOException {
        HashSet<File> grammarFilesToProcess = new HashSet<File>();
        for (File file : grammarFiles) {
            String tokensFileName = file.getName().split("\\.")[0] + ".tokens";
            File outputFile = new File(this.outputDirectory, tokensFileName);
            if (outputFile.exists() && outputFile.lastModified() >= file.lastModified() && !dependencies.isDependencyChanged(file)) continue;
            grammarFilesToProcess.add(file);
        }
        grammarFiles = grammarFilesToProcess;
        if (grammarFiles.isEmpty()) {
            this.getLog().info((CharSequence)"No grammars to process");
            return Collections.emptyList();
        }
        MultiMap grammarFileByFolder = new MultiMap();
        for (File grammarFile : grammarFiles) {
            if (!this.buildContext.hasDelta(grammarFile)) continue;
            this.buildContext.removeMessages(grammarFile);
            this.getLog().debug((CharSequence)("Grammar file '" + grammarFile.getPath() + "' detected."));
            String relPathBase = MojoUtils.findSourceSubdir(sourceDirectory, grammarFile);
            String relPath = relPathBase + grammarFile.getName();
            this.getLog().debug((CharSequence)("  ... relative path is: " + relPath));
            grammarFileByFolder.map((Object)relPathBase, (Object)grammarFile);
        }
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (Map.Entry entry : grammarFileByFolder.entrySet()) {
            ArrayList<String> folderArgs = new ArrayList<String>(args);
            if (!folderArgs.contains("-package") && !((String)entry.getKey()).isEmpty()) {
                folderArgs.add("-package");
                folderArgs.add(Antlr4Mojo.getPackageName((String)entry.getKey()));
            }
            for (File file : (List)entry.getValue()) {
                folderArgs.add((String)entry.getKey() + file.getName());
            }
            arrayList.add(folderArgs);
        }
        return arrayList;
    }

    private Set<File> getImportFiles(File sourceDirectory) throws InclusionScanException {
        if (!this.libDirectory.exists()) {
            return Collections.emptySet();
        }
        HashSet<String> includes = new HashSet<String>();
        includes.add("*.g4");
        includes.add("*.tokens");
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(includes, Collections.emptySet());
        scan.addSourceMapping((SourceMapping)new SuffixMapping("G4", "g4"));
        return scan.getIncludedSources(this.libDirectory, null);
    }

    private Set<File> getGrammarFiles(File sourceDirectory) throws InclusionScanException {
        SuffixMapping mapping = new SuffixMapping("g4", Collections.emptySet());
        Set<String> includes = this.getIncludesPatterns();
        this.excludes.add("imports/**");
        SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(includes, this.excludes);
        scan.addSourceMapping((SourceMapping)mapping);
        return scan.getIncludedSources(sourceDirectory, null);
    }

    private static String getPackageName(String relativeFolderPath) {
        if (relativeFolderPath.contains("..")) {
            throw new UnsupportedOperationException("Cannot handle relative paths containing '..'");
        }
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(relativeFolderPath.split("[/\\\\\\.]+")));
        while (parts.remove("")) {
        }
        return Utils.join(parts.iterator(), (String)".");
    }

    public Set<String> getIncludesPatterns() {
        if (this.includes == null || this.includes.isEmpty()) {
            return Collections.singleton("**/*.g4");
        }
        return this.includes;
    }

    private File getDependenciesStatusFile() {
        File statusFile = new File(this.statusDirectory, "dependencies.ser");
        if (!statusFile.getParentFile().exists()) {
            statusFile.getParentFile().mkdirs();
        }
        return statusFile;
    }

    private String validateEncoding(String encoding) {
        return encoding == null ? Charset.defaultCharset().name() : Charset.forName(encoding.trim()).name();
    }

    private final class CustomTool
    extends Tool {
        public CustomTool(String[] args) {
            super(args);
            this.addListener(new Antlr4ErrorLog(this, Antlr4Mojo.this.buildContext, Antlr4Mojo.this.getLog()));
        }

        public void process(Grammar g, boolean gencode) {
            Antlr4Mojo.this.getLog().info((CharSequence)("Processing grammar: " + g.fileName));
            super.process(g, gencode);
        }

        public Writer getOutputFileWriter(Grammar g, String fileName) throws IOException {
            if (this.outputDirectory == null) {
                return new StringWriter();
            }
            File outputDir = fileName.endsWith(".tokens") ? new File(this.outputDirectory) : this.getOutputDirectory(g.fileName);
            File outputFile = new File(outputDir, fileName);
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            URI relativePath = Antlr4Mojo.this.project.getBasedir().toURI().relativize(outputFile.toURI());
            Antlr4Mojo.this.getLog().debug((CharSequence)("  Writing file: " + relativePath));
            OutputStream outputStream = Antlr4Mojo.this.buildContext.newFileOutputStream(outputFile);
            if (Antlr4Mojo.this.outputEncoding != null && !Antlr4Mojo.this.outputEncoding.isEmpty()) {
                return new BufferedWriter(new OutputStreamWriter(outputStream, Antlr4Mojo.this.outputEncoding));
            }
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }
}

