/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.intentFactory;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import javax.inject.Inject;
import org.androidtransfuse.intentFactory.IntentFactoryStrategy;

public class IntentFactory {
    private final Context context;
    private final IntentAdapterFactory intentMockFactory;

    @Inject
    public IntentFactory(Context context) {
        this(context, new IntentAdapterFactoryImpl());
    }

    protected IntentFactory(Context context, IntentAdapterFactory intentMockFactory) {
        this.context = context;
        this.intentMockFactory = intentMockFactory;
    }

    public void start(IntentFactoryStrategy parameters) {
        Intent intent = this.buildIntent(parameters);
        parameters.start(this.context, intent);
    }

    public Intent buildIntent(IntentFactoryStrategy parameters) {
        Intent intent = this.intentMockFactory.buildIntent(this.context, parameters.getTargetContext());
        intent.setFlags(parameters.getFlags());
        for (String category : parameters.getCategories()) {
            intent.addCategory(category);
        }
        intent.putExtras(parameters.getExtras());
        return intent;
    }

    public PendingIntent buildPendingIntent(IntentFactoryStrategy parameters) {
        return this.buildPendingIntent(0, parameters);
    }

    public PendingIntent buildPendingIntent(int requestCode, IntentFactoryStrategy parameters) {
        return this.buildPendingIntent(requestCode, 0, parameters);
    }

    public PendingIntent buildPendingIntent(int requestCode, int flags, IntentFactoryStrategy parameters) {
        return PendingIntent.getActivity((Context)this.context, (int)requestCode, (Intent)this.buildIntent(parameters), (int)flags);
    }

    private static final class IntentAdapterFactoryImpl
    implements IntentAdapterFactory {
        private IntentAdapterFactoryImpl() {
        }

        @Override
        public Intent buildIntent(Context context, Class<? extends Context> clazz) {
            return new Intent(context, clazz);
        }
    }

    protected static interface IntentAdapterFactory {
        public Intent buildIntent(Context var1, Class<? extends Context> var2);
    }
}

