/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.event;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Singleton;
import org.androidtransfuse.event.EventObserver;
import org.androidtransfuse.util.TransfuseRuntimeException;

@Singleton
public class EventManager {
    private final ConcurrentMap<Class, Set<EventObserver>> observers = new ConcurrentHashMap<Class, Set<EventObserver>>();
    private final ThreadLocal<ConcurrentLinkedQueue<EventExecution>> executionQueue = new ExecutionQueueThreadLocal();
    private final ThreadLocal<Boolean> executing = new BooleanThreadLocal();

    public <T> void register(Class<T> event, EventObserver<T> observer) {
        if (event == null) {
            throw new IllegalArgumentException("Null Event type passed to register");
        }
        if (observer == null) {
            throw new IllegalArgumentException("Null observer passed to register");
        }
        this.nullSafeGet(event).add(observer);
    }

    private Set<EventObserver> nullSafeGet(Class<?> clazz) {
        CopyOnWriteArraySet value;
        CopyOnWriteArraySet result = (CopyOnWriteArraySet)this.observers.get(clazz);
        if (result == null && (result = (Set)this.observers.putIfAbsent(clazz, value = new CopyOnWriteArraySet())) == null) {
            result = value;
        }
        return result;
    }

    public void trigger(Object event) {
        Set<Class> eventTypes = this.getAllInheritedClasses(event.getClass());
        for (Class eventType : eventTypes) {
            if (!this.observers.containsKey(eventType)) continue;
            for (EventObserver eventObserver : (Set)this.observers.get(eventType)) {
                this.executionQueue.get().add(new EventExecution(event, eventObserver));
            }
        }
        this.triggerQueue();
    }

    private void triggerQueue() {
        if (this.executing.get().booleanValue()) {
            return;
        }
        this.executing.set(true);
        try {
            EventExecution execution = this.executionQueue.get().poll();
            while (execution != null) {
                execution.trigger();
                execution = this.executionQueue.get().poll();
            }
        }
        finally {
            this.executing.set(false);
        }
    }

    private Set<Class> getAllInheritedClasses(Class type) {
        HashSet<Class> inheritedClasses = new HashSet<Class>();
        this.addAllInheritedClasses(inheritedClasses, type);
        return inheritedClasses;
    }

    private void addAllInheritedClasses(Set<Class> inheritedClasses, Class type) {
        if (type != null) {
            inheritedClasses.add(type);
            this.addAllInheritedClasses(inheritedClasses, type.getSuperclass());
            for (Class<?> interf : type.getInterfaces()) {
                this.addAllInheritedClasses(inheritedClasses, interf);
            }
        }
    }

    public void unregister(EventObserver<?> observer) {
        for (Map.Entry entry : this.observers.entrySet()) {
            ((Set)entry.getValue()).remove(observer);
        }
    }

    private static class ExecutionQueueThreadLocal
    extends ThreadLocal<ConcurrentLinkedQueue<EventExecution>> {
        private ExecutionQueueThreadLocal() {
        }

        @Override
        protected ConcurrentLinkedQueue<EventExecution> initialValue() {
            return new ConcurrentLinkedQueue<EventExecution>();
        }
    }

    private static class BooleanThreadLocal
    extends ThreadLocal<Boolean> {
        private BooleanThreadLocal() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }

    private static final class EventExecution<T> {
        private final T event;
        private final EventObserver<T> observer;

        private EventExecution(T event, EventObserver<T> observer) {
            this.event = event;
            this.observer = observer;
        }

        public void trigger() {
            try {
                this.observer.trigger(this.event);
            }
            catch (Exception e) {
                throw new TransfuseRuntimeException("Exception caught during event trigger", e);
            }
        }
    }
}

