/*
 * Decompiled with CFR 0.152.
 */
package org.androidtransfuse.aop;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.androidtransfuse.util.TransfuseInjectionException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MethodInterceptorChain {
    private final MethodInterceptor[] methodInterceptors;
    private final MethodExecution methodExecution;
    private final Object proxy;

    public MethodInterceptorChain(MethodExecution methodExecution, Object proxy, MethodInterceptor ... methodInterceptorChains) {
        this.methodExecution = methodExecution;
        this.methodInterceptors = methodInterceptorChains;
        this.proxy = proxy;
    }

    public Object invoke(Object[] arguments) {
        try {
            return new MethodInterceptorIterator(arguments).proceed();
        }
        catch (Throwable e) {
            throw new TransfuseInjectionException("Error while invoking Method Interceptor", e);
        }
    }

    public static interface MethodExecution {
        public static final String GET_METHOD = "getMethod";
        public static final String INVOKE = "invoke";

        public Method getMethod() throws Exception;

        public Object invoke() throws Throwable;
    }

    private final class MethodInterceptorIterator
    implements MethodInvocation {
        private int i = -1;
        private final Object[] arguments;

        private MethodInterceptorIterator(Object[] arguments) {
            this.arguments = arguments;
        }

        public Method getMethod() {
            try {
                return MethodInterceptorChain.this.methodExecution.getMethod();
            }
            catch (Exception e) {
                throw new TransfuseInjectionException("Error while calling getMethod", e);
            }
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Object proceed() throws Throwable {
            ++this.i;
            if (this.i == MethodInterceptorChain.this.methodInterceptors.length) {
                return MethodInterceptorChain.this.methodExecution.invoke();
            }
            return MethodInterceptorChain.this.methodInterceptors[this.i].invoke((MethodInvocation)this);
        }

        public Object getThis() {
            return MethodInterceptorChain.this.proxy;
        }

        public AccessibleObject getStaticPart() {
            return this.getMethod();
        }
    }
}

