/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.lzo.hadoop.codec;

import java.io.IOException;
import org.anarres.lzo.LzoAlgorithm;
import org.anarres.lzo.LzoConstraint;
import org.anarres.lzo.LzoLibrary;
import org.anarres.lzo.lzo_uintp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Decompressor;

public class LzoDecompressor
implements Decompressor {
    private static final Log LOG = LogFactory.getLog(LzoDecompressor.class);
    private final org.anarres.lzo.LzoDecompressor decompressor;
    private byte[] outputBuffer;
    private int outputBufferPos;
    private final lzo_uintp outputBufferLen = new lzo_uintp();

    public LzoDecompressor(CompressionStrategy strategy, int outputBufferSize) {
        this.decompressor = strategy.newDecompressor();
        this.setOutputBufferSize(outputBufferSize);
    }

    public void setOutputBufferSize(int outputBufferSize) {
        if (this.outputBuffer == null || outputBufferSize > this.outputBuffer.length) {
            this.outputBuffer = new byte[outputBufferSize];
        }
    }

    public LzoDecompressor() {
        this(CompressionStrategy.LZO1X, 65536);
    }

    private void logState(String when) {
        LOG.info((Object)"\n");
        LOG.info((Object)(when + " Output buffer pos=" + this.outputBufferPos + "; length=" + this.outputBufferLen));
    }

    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Illegal range in buffer: Buffer length=" + b.length + ", offset=" + off + ", length=" + len);
        }
        if (!this.needsInput()) {
            throw new IllegalStateException("I don't need input: pos=" + this.outputBufferPos + "; len=" + this.outputBufferLen);
        }
        this.outputBufferLen.value = this.outputBuffer.length;
        try {
            this.outputBufferPos = 0;
            int code = this.decompressor.decompress(b, off, len, this.outputBuffer, this.outputBufferPos, this.outputBufferLen);
            if (code != 0) {
                this.logState("LZO error: " + code);
                throw new IllegalArgumentException(this.decompressor.toErrorString(code));
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.logState("IndexOutOfBoundsException: " + e);
            throw e;
        }
    }

    public void setDictionary(byte[] b, int off, int len) {
    }

    public boolean needsInput() {
        return this.outputBufferLen.value <= 0;
    }

    public boolean needsDictionary() {
        return false;
    }

    public boolean finished() {
        return this.outputBufferLen.value <= 0;
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Illegal range in buffer: Buffer length=" + b.length + ", offset=" + off + ", length=" + len);
        }
        len = Math.min(len, this.outputBufferLen.value);
        System.arraycopy(this.outputBuffer, this.outputBufferPos, b, off, len);
        this.outputBufferPos += len;
        this.outputBufferLen.value -= len;
        return len;
    }

    public int getRemaining() {
        return this.outputBufferLen.value;
    }

    public void reset() {
        this.outputBufferPos = 0;
        this.outputBufferLen.value = 0;
    }

    public void end() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionStrategy {
        LZO1(LzoAlgorithm.LZO1),
        LZO1A(LzoAlgorithm.LZO1A),
        LZO1B(LzoAlgorithm.LZO1B),
        LZO1B_SAFE(LzoAlgorithm.LZO1B, LzoConstraint.SAFETY),
        LZO1C(LzoAlgorithm.LZO1C),
        LZO1C_SAFE(LzoAlgorithm.LZO1C, LzoConstraint.SAFETY),
        LZO1C_ASM(LzoAlgorithm.LZO1C),
        LZO1C_ASM_SAFE(LzoAlgorithm.LZO1C, LzoConstraint.SAFETY),
        LZO1F(LzoAlgorithm.LZO1F),
        LZO1F_SAFE(LzoAlgorithm.LZO1F, LzoConstraint.SAFETY),
        LZO1F_ASM_FAST(LzoAlgorithm.LZO1F),
        LZO1F_ASM_FAST_SAFE(LzoAlgorithm.LZO1F, LzoConstraint.SAFETY),
        LZO1X(LzoAlgorithm.LZO1X),
        LZO1X_SAFE(LzoAlgorithm.LZO1X, LzoConstraint.SAFETY),
        LZO1X_ASM(LzoAlgorithm.LZO1X),
        LZO1X_ASM_SAFE(LzoAlgorithm.LZO1X, LzoConstraint.SAFETY),
        LZO1X_ASM_FAST(LzoAlgorithm.LZO1X, LzoConstraint.SPEED),
        LZO1X_ASM_FAST_SAFE(LzoAlgorithm.LZO1X, LzoConstraint.SAFETY),
        LZO1Y(LzoAlgorithm.LZO1Y),
        LZO1Y_SAFE(LzoAlgorithm.LZO1Y, LzoConstraint.SAFETY),
        LZO1Y_ASM(LzoAlgorithm.LZO1Y),
        LZO1Y_ASM_SAFE(LzoAlgorithm.LZO1Y, LzoConstraint.SAFETY),
        LZO1Y_ASM_FAST(LzoAlgorithm.LZO1Y, LzoConstraint.SPEED),
        LZO1Y_ASM_FAST_SAFE(LzoAlgorithm.LZO1Y, LzoConstraint.SAFETY),
        LZO1Z(LzoAlgorithm.LZO1Z),
        LZO1Z_SAFE(LzoAlgorithm.LZO1Z, LzoConstraint.SAFETY),
        LZO2A(LzoAlgorithm.LZO2A),
        LZO2A_SAFE(LzoAlgorithm.LZO2A, LzoConstraint.SAFETY);

        private final LzoAlgorithm algorithm;
        private final LzoConstraint constraint;

        private CompressionStrategy(LzoAlgorithm algorithm, LzoConstraint constraint) {
            this.algorithm = algorithm;
            this.constraint = constraint;
        }

        private CompressionStrategy(LzoAlgorithm algorithm) {
            this(algorithm, null);
        }

        public org.anarres.lzo.LzoDecompressor newDecompressor() {
            return LzoLibrary.getInstance().newDecompressor(this.algorithm, this.constraint);
        }
    }
}

