/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.quarkus.qpid.jms.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.jms.spi.deployment.ConnectionFactoryWrapperBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.function.Function;
import org.amqphub.quarkus.qpid.jms.runtime.ConnectionFactoryWrapper;
import org.amqphub.quarkus.qpid.jms.runtime.QpidJmsProducer;
import org.amqphub.quarkus.qpid.jms.runtime.QpidJmsRecorder;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpProviderFactory;
import org.apache.qpid.jms.provider.failover.FailoverProvider;
import org.apache.qpid.jms.provider.failover.FailoverProviderFactory;
import org.apache.qpid.jms.sasl.AnonymousMechanism;
import org.apache.qpid.jms.sasl.AnonymousMechanismFactory;
import org.apache.qpid.jms.sasl.CramMD5Mechanism;
import org.apache.qpid.jms.sasl.CramMD5MechanismFactory;
import org.apache.qpid.jms.sasl.ExternalMechanism;
import org.apache.qpid.jms.sasl.ExternalMechanismFactory;
import org.apache.qpid.jms.sasl.PlainMechanism;
import org.apache.qpid.jms.sasl.PlainMechanismFactory;
import org.apache.qpid.jms.sasl.ScramSHA1Mechanism;
import org.apache.qpid.jms.sasl.ScramSHA1MechanismFactory;
import org.apache.qpid.jms.sasl.ScramSHA256Mechanism;
import org.apache.qpid.jms.sasl.ScramSHA256MechanismFactory;
import org.apache.qpid.jms.sasl.XOauth2Mechanism;
import org.apache.qpid.jms.sasl.XOauth2MechanismFactory;
import org.apache.qpid.jms.tracing.JmsNoOpTracer;
import org.apache.qpid.jms.tracing.JmsNoOpTracerFactory;
import org.apache.qpid.jms.tracing.opentracing.OpenTracingTracer;
import org.apache.qpid.jms.tracing.opentracing.OpenTracingTracerFactory;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.netty.NettySslTransportFactory;
import org.apache.qpid.jms.transports.netty.NettyTcpTransport;
import org.apache.qpid.jms.transports.netty.NettyTcpTransportFactory;
import org.apache.qpid.jms.transports.netty.NettyWsTransport;
import org.apache.qpid.jms.transports.netty.NettyWsTransportFactory;
import org.apache.qpid.jms.transports.netty.NettyWssTransportFactory;
import org.apache.qpid.proton.engine.impl.TransportImpl;

public class QpidJmsProcessor {
    private static final String QPID_JMS = "qpid-jms";
    private static final String GLOBAL_TRACER_CLASS = "io.opentracing.util.GlobalTracer";

    @BuildStep
    public void enableSecurityServices(BuildProducer<FeatureBuildItem> feature, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        feature.produce((BuildItem)new FeatureBuildItem(QPID_JMS));
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(QPID_JMS));
    }

    @BuildStep
    AdditionalBeanBuildItem registerBean() {
        return AdditionalBeanBuildItem.unremovableOf(QpidJmsProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void connectionFactoryWrapper(Optional<ConnectionFactoryWrapperBuildItem> connectionFactoryWrapper, QpidJmsRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer) {
        if (connectionFactoryWrapper.isPresent()) {
            Function wrapper = connectionFactoryWrapper.get().getWrapper();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ConnectionFactoryWrapper.class).setRuntimeInit().defaultBean()).unremovable()).scope(ApplicationScoped.class)).runtimeValue(recorder.getConnectionFactoryWrapper(wrapper));
            syntheticBeanProducer.produce((BuildItem)configurator.done());
        }
    }

    @BuildStep
    public void build(CombinedIndexBuildItem indexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RuntimeInitializedClassBuildItem> delayedInitialisation, BuildProducer<NativeImageResourceBuildItem> resource) {
        delayedInitialisation.produce((BuildItem)new RuntimeInitializedClassBuildItem(TransportImpl.class.getName()));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/amqp"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/amqps"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/amqpws"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/amqpwss"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/redirects/ws"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/redirects/wss"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AmqpProviderFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AmqpProvider.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/provider/failover"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FailoverProviderFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FailoverProvider.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JmsConnectionFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JmsConnectionInfo.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{TransportOptions.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/transports/tcp"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/transports/ssl"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{NettyTcpTransportFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{NettySslTransportFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{NettyTcpTransport.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/transports/ws"}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/transports/wss"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{NettyWsTransportFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{NettyWssTransportFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{NettyWsTransport.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/PLAIN"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{PlainMechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{PlainMechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/ANONYMOUS"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AnonymousMechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{AnonymousMechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/EXTERNAL"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ExternalMechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ExternalMechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/CRAM-MD5"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{CramMD5MechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{CramMD5Mechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/SCRAM-SHA-1"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ScramSHA1MechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ScramSHA1Mechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/SCRAM-SHA-256"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ScramSHA256MechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ScramSHA256Mechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/sasl/XOAUTH2"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{XOauth2MechanismFactory.class}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{XOauth2Mechanism.class}).methods().build());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/tracing/noop"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JmsNoOpTracerFactory.class}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JmsNoOpTracer.class}).build());
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)GLOBAL_TRACER_CLASS)) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org/apache/qpid/jms/tracing/opentracing"}));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{OpenTracingTracerFactory.class}).build());
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{OpenTracingTracer.class}).build());
        }
    }
}

