/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import java.util.Collection;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.RangingData;

@TargetApi(value=3)
public class BeaconIntentProcessor
extends IntentService {
    private static final String TAG = "BeaconIntentProcessor";

    public BeaconIntentProcessor() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        Object notifier;
        LogManager.d(TAG, "got an intent to process", new Object[0]);
        MonitoringData monitoringData = null;
        RangingData rangingData = null;
        if (intent != null && intent.getExtras() != null) {
            monitoringData = (MonitoringData)intent.getExtras().get("monitoringData");
            rangingData = (RangingData)intent.getExtras().get("rangingData");
        }
        if (rangingData != null) {
            LogManager.d(TAG, "got ranging data", new Object[0]);
            if (rangingData.getBeacons() == null) {
                LogManager.w(TAG, "Ranging data has a null beacons collection", new Object[0]);
            }
            notifier = BeaconManager.getInstanceForApplication((Context)this).getRangingNotifier();
            Collection<Beacon> beacons = rangingData.getBeacons();
            if (notifier != null) {
                notifier.didRangeBeaconsInRegion(beacons, rangingData.getRegion());
            } else {
                LogManager.d(TAG, "but ranging notifier is null, so we're dropping it.", new Object[0]);
            }
            RangeNotifier dataNotifier = BeaconManager.getInstanceForApplication((Context)this).getDataRequestNotifier();
            if (dataNotifier != null) {
                dataNotifier.didRangeBeaconsInRegion(beacons, rangingData.getRegion());
            }
        }
        if (monitoringData != null) {
            LogManager.d(TAG, "got monitoring data", new Object[0]);
            notifier = BeaconManager.getInstanceForApplication((Context)this).getMonitoringNotifier();
            if (notifier != null) {
                LogManager.d(TAG, "Calling monitoring notifier: %s", notifier);
                notifier.didDetermineStateForRegion(monitoringData.isInside() ? 1 : 0, monitoringData.getRegion());
                if (monitoringData.isInside()) {
                    notifier.didEnterRegion(monitoringData.getRegion());
                } else {
                    notifier.didExitRegion(monitoringData.getRegion());
                }
            }
        }
    }
}

