/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table.transform;

import alluxio.collections.Pair;
import alluxio.job.wire.Status;
import alluxio.table.common.Layout;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.validation.constraints.NotNull;

@ThreadSafe
public final class TransformJobInfo {
    private final Pair<String, String> mDbTable;
    private final String mDefinition;
    private final Map<String, Layout> mTransformedLayouts;
    private final long mJobId;
    private volatile Status mJobStatus;
    private volatile String mJobErrorMessage;

    public TransformJobInfo(@NotNull String db, @NotNull String table, @NotNull String definition, long jobId, @NotNull Map<String, Layout> transformedLayouts) {
        Preconditions.checkNotNull((Object)db, (Object)"db");
        Preconditions.checkNotNull((Object)table, (Object)"table");
        Preconditions.checkNotNull((Object)definition, (Object)"definition");
        Preconditions.checkNotNull(transformedLayouts, (Object)"transformedLayouts");
        this.mDbTable = new Pair((Object)db, (Object)table);
        this.mDefinition = definition;
        this.mTransformedLayouts = Collections.unmodifiableMap(transformedLayouts);
        this.mJobId = jobId;
        this.mJobStatus = Status.RUNNING;
        this.mJobErrorMessage = "";
    }

    public String getDb() {
        return (String)this.mDbTable.getFirst();
    }

    public String getTable() {
        return (String)this.mDbTable.getSecond();
    }

    public Pair<String, String> getDbTable() {
        return this.mDbTable;
    }

    public String getDefinition() {
        return this.mDefinition;
    }

    public Map<String, Layout> getTransformedLayouts() {
        return this.mTransformedLayouts;
    }

    public long getJobId() {
        return this.mJobId;
    }

    public Status getJobStatus() {
        return this.mJobStatus;
    }

    public void setJobStatus(@NotNull Status status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        this.mJobStatus = status;
    }

    public String getJobErrorMessage() {
        return this.mJobErrorMessage;
    }

    public void setJobErrorMessage(@NotNull String error) {
        Preconditions.checkNotNull((Object)error, (Object)"error");
        this.mJobErrorMessage = error;
    }

    public alluxio.grpc.table.TransformJobInfo toProto() {
        return alluxio.grpc.table.TransformJobInfo.newBuilder().setDbName(this.getDb()).setTableName(this.getTable()).setDefinition(this.getDefinition()).setJobId(this.getJobId()).setJobStatus(this.getJobStatus().toProto()).setJobError(this.getJobErrorMessage()).build();
    }
}

