/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.ClientContext;
import alluxio.Server;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.master.CoreMasterContext;
import alluxio.master.MasterContext;
import alluxio.master.MasterFactory;
import alluxio.master.MasterRegistry;
import alluxio.master.table.DefaultTableMaster;
import alluxio.master.table.TableMaster;
import alluxio.worker.job.JobMasterClientContext;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TableMasterFactory
implements MasterFactory<CoreMasterContext> {
    private static final Logger LOG = LoggerFactory.getLogger(TableMasterFactory.class);

    public boolean isEnabled() {
        return Configuration.getBoolean((PropertyKey)PropertyKey.TABLE_ENABLED);
    }

    public String getName() {
        return "TableMaster";
    }

    public TableMaster create(MasterRegistry registry, CoreMasterContext context) {
        LOG.info("Creating {} ", (Object)TableMaster.class.getName());
        JobMasterClient jobMasterClient = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)Configuration.global())).build());
        DefaultTableMaster master = new DefaultTableMaster((MasterContext)context, jobMasterClient);
        registry.add(TableMaster.class, (Server)master);
        return master;
    }
}

