/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.table;

import alluxio.RpcUtils;
import alluxio.grpc.table.AttachDatabasePRequest;
import alluxio.grpc.table.AttachDatabasePResponse;
import alluxio.grpc.table.DetachDatabasePRequest;
import alluxio.grpc.table.DetachDatabasePResponse;
import alluxio.grpc.table.GetAllDatabasesPRequest;
import alluxio.grpc.table.GetAllDatabasesPResponse;
import alluxio.grpc.table.GetAllTablesPRequest;
import alluxio.grpc.table.GetAllTablesPResponse;
import alluxio.grpc.table.GetDatabasePRequest;
import alluxio.grpc.table.GetDatabasePResponse;
import alluxio.grpc.table.GetPartitionColumnStatisticsPRequest;
import alluxio.grpc.table.GetPartitionColumnStatisticsPResponse;
import alluxio.grpc.table.GetTableColumnStatisticsPRequest;
import alluxio.grpc.table.GetTableColumnStatisticsPResponse;
import alluxio.grpc.table.GetTablePRequest;
import alluxio.grpc.table.GetTablePResponse;
import alluxio.grpc.table.GetTransformJobInfoPRequest;
import alluxio.grpc.table.GetTransformJobInfoPResponse;
import alluxio.grpc.table.ReadTablePRequest;
import alluxio.grpc.table.ReadTablePResponse;
import alluxio.grpc.table.SyncDatabasePRequest;
import alluxio.grpc.table.SyncDatabasePResponse;
import alluxio.grpc.table.SyncStatus;
import alluxio.grpc.table.TableMasterClientServiceGrpc;
import alluxio.grpc.table.TransformTablePRequest;
import alluxio.grpc.table.TransformTablePResponse;
import alluxio.master.table.Table;
import alluxio.master.table.TableMaster;
import alluxio.master.table.transform.TransformJobInfo;
import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMasterClientServiceHandler
extends TableMasterClientServiceGrpc.TableMasterClientServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(TableMasterClientServiceHandler.class);
    private final TableMaster mTableMaster;

    public TableMasterClientServiceHandler(TableMaster tableMaster) {
        Preconditions.checkNotNull((Object)tableMaster, (Object)"tableMaster");
        this.mTableMaster = tableMaster;
    }

    public void attachDatabase(AttachDatabasePRequest request, StreamObserver<AttachDatabasePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            SyncStatus status = this.mTableMaster.attachDatabase(request.getUdbType(), request.getUdbConnectionUri(), request.getUdbDbName(), request.getDbName(), request.getOptionsMap(), request.getIgnoreSyncErrors());
            return AttachDatabasePResponse.newBuilder().setSuccess(status.getTablesErrorsCount() == 0).setSyncStatus(status).build();
        }, (String)"attachDatabase", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void detachDatabase(DetachDatabasePRequest request, StreamObserver<DetachDatabasePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> DetachDatabasePResponse.newBuilder().setSuccess(this.mTableMaster.detachDatabase(request.getDbName())).build(), (String)"detachDatabase", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getAllDatabases(GetAllDatabasesPRequest request, StreamObserver<GetAllDatabasesPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetAllDatabasesPResponse.newBuilder().addAllDatabase(this.mTableMaster.getAllDatabases()).build(), (String)"getAllDatabases", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getAllTables(GetAllTablesPRequest request, StreamObserver<GetAllTablesPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetAllTablesPResponse.newBuilder().addAllTable(this.mTableMaster.getAllTables(request.getDatabase())).build(), (String)"getAllTables", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getDatabase(GetDatabasePRequest request, StreamObserver<GetDatabasePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetDatabasePResponse.newBuilder().setDb(this.mTableMaster.getDatabase(request.getDbName())).build(), (String)"getDatabase", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getTable(GetTablePRequest request, StreamObserver<GetTablePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            Table table = this.mTableMaster.getTable(request.getDbName(), request.getTableName());
            if (table != null) {
                return GetTablePResponse.newBuilder().setTableInfo(table.toProto()).build();
            }
            return GetTablePResponse.getDefaultInstance();
        }, (String)"getTable", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getTableColumnStatistics(GetTableColumnStatisticsPRequest request, StreamObserver<GetTableColumnStatisticsPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetTableColumnStatisticsPResponse.newBuilder().addAllStatistics(this.mTableMaster.getTableColumnStatistics(request.getDbName(), request.getTableName(), (List<String>)request.getColNamesList())).build(), (String)"getTableColumnStatistics", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getPartitionColumnStatistics(GetPartitionColumnStatisticsPRequest request, StreamObserver<GetPartitionColumnStatisticsPResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> GetPartitionColumnStatisticsPResponse.newBuilder().putAllPartitionStatistics(this.mTableMaster.getPartitionColumnStatistics(request.getDbName(), request.getTableName(), (List<String>)request.getPartNamesList(), (List<String>)request.getColNamesList())).build(), (String)"getPartitionColumnStatistics", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void readTable(ReadTablePRequest request, StreamObserver<ReadTablePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> ReadTablePResponse.newBuilder().addAllPartitions(this.mTableMaster.readTable(request.getDbName(), request.getTableName(), request.getConstraint())).build(), (String)"readTable", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void transformTable(TransformTablePRequest request, StreamObserver<TransformTablePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> TransformTablePResponse.newBuilder().setJobId(this.mTableMaster.transformTable(request.getDbName(), request.getTableName(), request.getDefinition())).build(), (String)"transformTable", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void syncDatabase(SyncDatabasePRequest request, StreamObserver<SyncDatabasePResponse> responseObserver) {
        RpcUtils.call((Logger)LOG, () -> {
            SyncStatus status = this.mTableMaster.syncDatabase(request.getDbName());
            return SyncDatabasePResponse.newBuilder().setSuccess(status.getTablesErrorsCount() == 0).setStatus(status).build();
        }, (String)"syncDatabase", (String)"", responseObserver, (Object[])new Object[0]);
    }

    public void getTransformJobInfo(GetTransformJobInfoPRequest request, StreamObserver<GetTransformJobInfoPResponse> responseObserver) {
        if (request.hasJobId()) {
            RpcUtils.call((Logger)LOG, () -> GetTransformJobInfoPResponse.newBuilder().addInfo(this.mTableMaster.getTransformJobInfo(request.getJobId()).toProto()).build(), (String)"getTransformJobInfo", (String)"", responseObserver, (Object[])new Object[0]);
        } else {
            RpcUtils.call((Logger)LOG, () -> GetTransformJobInfoPResponse.newBuilder().addAllInfo((Iterable)this.mTableMaster.getAllTransformJobInfo().stream().map(TransformJobInfo::toProto).collect(Collectors.toList())).build(), (String)"getTransformJobInfo", (String)"", responseObserver, (Object[])new Object[0]);
        }
    }
}

